/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.bugreport.main;

import com.google.common.io.Files;
import de.planetensuche.bugreport.main.BugreportDialog;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.TimerTask;
import javax.swing.JTextArea;

public final class AktualisierenThread
extends TimerTask {
    private final ISprachcontainer sprache;
    private final ILogging logger;
    private final BugreportDialog gui;
    private final File datei;

    public AktualisierenThread(BugreportDialog bugreportDialog, String string, ISprachcontainer iSprachcontainer) {
        this.gui = bugreportDialog;
        this.datei = new File(string);
        this.sprache = iSprachcontainer;
        this.logger = LoggingFactory.getLoggerForClass(this.getClass());
    }

    @Override
    public void run() {
        if (!this.datei.exists()) {
            return;
        }
        try {
            JTextArea jTextArea = new JTextArea();
            jTextArea.setText("\n---------------------" + this.sprache.getString("bug_m13") + "---------------------\n\n");
            List<String> list = Files.readLines(this.datei, Charset.forName("UTF-8"));
            int n = 0;
            boolean bl = false;
            for (String string : list) {
                if (n > this.gui.getZeilenBereitsEingelesen()) {
                    jTextArea.append(string + "\n");
                    bl = true;
                }
                ++n;
            }
            if (bl) {
                this.gui.appendText(jTextArea);
                this.gui.setZeilenBereitsEingelesen(n);
            }
        }
        catch (IOException iOException) {
            this.logger.error(iOException);
        }
    }
}

