/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datamodel.api;

import java.util.Optional;

public enum StarObjectType {
    SINGLE_STAR("Einzelstern"),
    DOUBLE_STAR_REAL("Doppelstern physisch"),
    DOUBLE_STAR_OPTICAL("Doppelstern optisch"),
    MULTI_STAR_SYSTEM("Mehrfachsternensystem"),
    ECLIPSING_BINARY("Bedeckungsveraenderlicher"),
    ECLIPSING_BINARY_CANDIDATE("Bedeckungsveraenderlicher-Kandidat"),
    VARIABLE_IRREGULAR("Veraenderlicher unregelmaessig"),
    VARIABLE_HALF_REGULAR("Veraenderlicher halbregelmaessig"),
    VARIABLE_SHORT_PERIOD("Veraenderlicher kurzperiodisch"),
    VARIABLE_LONG_PERIOD("Veraenderlicher langperiodisch"),
    VARIABLE_UNKNOWN_TYPE("Veraenderlicher unbekannten Typs"),
    NEUTRON_STAR("Neutronenstern"),
    PULSAR("Pulsar"),
    MAGNETAR("Magnetar"),
    SUPERNOVA_I_A("Supernova Typ Ia"),
    SUPERNOVA_II("Supernova Typ II"),
    WHITE_DWARF("Weisser Zwerg"),
    NOVA("Nova"),
    WOLF_RAYET_STAR("Wolf-Rayet-Stern");

    private final String typeName;

    private StarObjectType(String string2) {
        this.typeName = string2;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public static Optional<StarObjectType> parse(String string) {
        for (StarObjectType starObjectType : StarObjectType.values()) {
            if (!starObjectType.getTypeName().equalsIgnoreCase(string)) continue;
            return Optional.of(starObjectType);
        }
        return Optional.empty();
    }
}

