/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datamodel.api;

public class Temperatur {
    private static final double O_T_MIN = 25000.0;
    private static final double O_T_MAX = 150000.0;
    private static final double B_T_MIN = 10000.0;
    private static final double B_T_MAX = 25000.0;
    private static final double A_T_MIN = 7600.0;
    private static final double A_T_MAX = 10000.0;
    private static final double F_T_MIN = 6000.0;
    private static final double F_T_MAX = 7600.0;
    private static final double G_T_MIN = 5100.0;
    private static final double G_T_MAX = 6000.0;
    private static final double K_T_MIN = 3600.0;
    private static final double K_T_MAX = 5100.0;
    private static final double M_T_MIN = 2500.0;
    private static final double M_T_MAX = 3600.0;
    private static final double DA_T_MIN = 4000.0;
    private static final double DA_T_MAX = 70000.0;
    private static final double DB_T_MIN = 30000.0;
    private static final double DB_T_MAX = 12000.0;
    private static final double DC_T_MIN = 3000.0;
    private static final double DC_T_MAX = 12000.0;
    private static final double DO_T_MIN = 100000.0;
    private static final double DO_T_MAX = 45000.0;
    private static final double DQ_T_MIN = 15000.0;
    private static final double DQ_T_MAX = 30000.0;
    private static final double DZ_T_MIN = 45000.0;
    private static final double DZ_T_MAX = 150000.0;

    public String getSpektraltypFuerStern(double d, boolean bl) {
        Object object = "";
        if (bl) {
            if (d >= 250000.0) {
                object = "DA0.0";
            } else {
                double d2 = (double)Math.round(50400.0 / d * 10.0) / 10.0;
                object = "DA" + this.roundByFive(d2);
            }
        } else {
            double d3 = 0.0;
            double d4 = 0.0;
            if (d > 25000.0) {
                object = "O";
                d3 = 150000.0;
                d4 = 25000.0;
            } else if (d <= 25000.0 && d > 10000.0) {
                object = "B";
                d3 = 25000.0;
                d4 = 10000.0;
            } else if (d <= 10000.0 && d > 7600.0) {
                object = "A";
                d3 = 10000.0;
                d4 = 7600.0;
            } else if (d <= 7600.0 && d > 6000.0) {
                object = "F";
                d3 = 7600.0;
                d4 = 6000.0;
            } else if (d <= 6000.0 && d > 5100.0) {
                object = "G";
                d3 = 6000.0;
                d4 = 5100.0;
            } else if (d <= 5100.0 && d > 3600.0) {
                object = "K";
                d3 = 5100.0;
                d4 = 3600.0;
            } else if (d <= 3600.0 && d > 2500.0) {
                object = "M";
                d3 = 3600.0;
                d4 = 2500.0;
            } else {
                return "L/T/Y";
            }
            if (!"L0.0".equals(object)) {
                double d5 = (d - d3) / ((d4 - d3) / 9.5) * 10.0;
                double d6 = (double)Math.round(d5) / 10.0;
                object = (String)object + this.roundByFive(d6);
            }
        }
        return object;
    }

    private double roundByFive(double d) {
        long l = (long)d;
        double d2 = d - (double)l;
        if (d2 < 0.299) {
            return l;
        }
        if (d2 < 0.799) {
            return (double)l + 0.5;
        }
        return (double)l + 1.0;
    }

    public double getTemperaturFuerStern(String string, double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        boolean bl = false;
        if ("DA".equals(string)) {
            d3 = 70000.0;
            d4 = 4000.0;
            bl = true;
        } else if ("DB".equals(string)) {
            d3 = 12000.0;
            d4 = 30000.0;
            bl = true;
        } else if ("DC".equals(string)) {
            d3 = 12000.0;
            d4 = 3000.0;
            bl = true;
        } else if ("DO".equals(string)) {
            d3 = 45000.0;
            d4 = 100000.0;
            bl = true;
        } else if ("DQ".equals(string)) {
            d3 = 30000.0;
            d4 = 15000.0;
            bl = true;
        } else if ("DZ".equals(string)) {
            d3 = 150000.0;
            d4 = 45000.0;
            bl = true;
        } else if ("O".equals(string)) {
            d3 = 150000.0;
            d4 = 25000.0;
        } else if ("B".equals(string)) {
            d3 = 25000.0;
            d4 = 10000.0;
        } else if ("A".equals(string)) {
            d3 = 10000.0;
            d4 = 7600.0;
        } else if ("F".equals(string)) {
            d3 = 7600.0;
            d4 = 6000.0;
        } else if ("G".equals(string)) {
            d3 = 6000.0;
            d4 = 5100.0;
        } else if ("K".equals(string)) {
            d3 = 5100.0;
            d4 = 3600.0;
        } else if ("M".equals(string)) {
            d3 = 3600.0;
            d4 = 2500.0;
        }
        d2 = bl ? ("DA".equals(string) ? (d == 0.0 ? 250000.0 : 50400.0 / d) : d3 - d * ((d3 - d4) / 13.0)) : d3 - d * ((d3 - d4) / 9.5);
        return d2;
    }
}

