/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datamodel.cleanarch.bo.impl;

import de.planetensuche.datamodel.cleanarch.bo.api.IPlanet;
import de.planetensuche.datamodel.cleanarch.bo.api.types.MassType;
import de.planetensuche.datamodel.cleanarch.bo.impl.Star;
import java.util.Set;

public final class Planet
implements IPlanet {
    private final Long id;
    private final Set<String> planetNames;
    private final MassType massInJupiterTimes;
    private final Star hostStar;

    private Planet(Builder builder) {
        this.planetNames = builder.planetNames;
        this.massInJupiterTimes = builder.massInJupiterTimes;
        this.hostStar = builder.hostStar;
        this.id = builder.id;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public MassType getMassInJupiterTimes() {
        return this.massInJupiterTimes;
    }

    @Override
    public Set<String> getPlanetNames() {
        return this.planetNames;
    }

    @Override
    public Star getHostStar() {
        return this.hostStar;
    }

    public static class Builder {
        private final Set<String> planetNames;
        private Long id;
        private Star hostStar;
        private MassType massInJupiterTimes;

        public Builder(Set<String> set) {
            if (set == null || set.isEmpty()) {
                throw new IllegalArgumentException("planet name is required");
            }
            this.planetNames = set;
        }

        public Builder setId(Long l) {
            this.id = l;
            return this;
        }

        public Builder setMass(MassType massType) {
            this.massInJupiterTimes = massType;
            return this;
        }

        public Builder setHostStar(Star star) {
            this.hostStar = star;
            return this;
        }

        public IPlanet build() {
            return new Planet(this);
        }
    }
}

