/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datamodel.formeln;

import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import java.util.Optional;

public class EarthSimilarityIndexExoplanetCalculator {
    public Optional<Double> calcESI(IPlanetensucheObjekt iPlanetensucheObjekt, IPlanetensucheObjekt iPlanetensucheObjekt2) {
        return this.calcESI(iPlanetensucheObjekt2.getDurchmesser(), iPlanetensucheObjekt2.getEntfernung(), iPlanetensucheObjekt2.getUmlaufszeit(), iPlanetensucheObjekt.getAbsoluteHelligkeit(), iPlanetensucheObjekt.getTemperatur(), iPlanetensucheObjekt.getDurchmesser());
    }

    public Optional<Double> calcESI(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        if (d == 0.0) {
            return Optional.empty();
        }
        double d8 = this.calcStarLum(d4, d6, d5);
        if (d8 == -1.0) {
            return Optional.empty();
        }
        double d9 = d7 = d2 > 0.0 ? d2 : this.calcDistanceFromPeriod(d3);
        if (d7 <= 0.0) {
            return Optional.empty();
        }
        double d10 = d8 / Math.pow(d7, 2.0) * 1368.0;
        double d11 = (d10 - 1368.0) / (d10 + 1368.0);
        d11 = Math.pow(d11, 2.0);
        double d12 = (d - 0.0892) / (d + 0.0892);
        d12 = Math.pow(d12, 2.0);
        double d13 = d11 + d12;
        double d14 = 1.0 - Math.sqrt(0.5 * d13);
        return Optional.of(d14);
    }

    private double calcDistanceFromPeriod(double d) {
        return Math.pow(Math.pow(d / 365.25, 2.0), 0.3333333333333333);
    }

    private double calcStarLum(double d, double d2, double d3) {
        if (d2 > 0.0 && d3 > 0.0) {
            double d4 = d2 * 696392.0;
            double d5 = Math.pow(d4 / 696392.0, 2.0);
            double d6 = Math.pow(d3 / 5778.0, 4.0);
            return d5 * d6;
        }
        if (d > -100.0) {
            return Math.pow(10.0, (4.82 - d) / 2.5);
        }
        return -1.0;
    }
}

