/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datamodel.formeln;

import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.formeln.IHabitateZone;
import de.planetensuche.datamodel.formeln.Konstanten;
import de.planetensuche.datamodel.formeln.SternleuchtkraftTemperatur;

public final class HabitateZoneSimple
extends Konstanten
implements IHabitateZone {
    private final SternleuchtkraftTemperatur sternleuchtkraft = new SternleuchtkraftTemperatur();
    private double innereHZ;
    private double aeussereHZ;

    public void berechne(double d, double d2) {
        double d3 = this.sternleuchtkraft.getErgebnis(d2, d);
        double d4 = this.sternleuchtkraft.getErgebnis(1.0, 5778.0);
        double d5 = d3 / d4;
        this.innereHZ = 0.82 * d5;
        this.aeussereHZ = 1.2 * d5;
    }

    @Override
    public boolean berechne(IPlanetensucheObjekt iPlanetensucheObjekt) {
        if (iPlanetensucheObjekt.isTemperaturUnbekannt() || iPlanetensucheObjekt.isDurchmesserUnbekannt()) {
            return false;
        }
        this.berechne(iPlanetensucheObjekt.getTemperatur(), iPlanetensucheObjekt.getDurchmesser());
        return this.innereHZ > 0.0 && this.aeussereHZ > 0.0;
    }

    @Override
    public double getAeussereHZ() {
        return this.aeussereHZ;
    }

    @Override
    public double getInnereHZ() {
        return this.innereHZ;
    }
}

