/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datamodel.formeln;

import java.util.List;

public class PlanetSystemTypeCalculator {
    public PlanetSystemType determineType(List<Double> list) {
        double d;
        double d2 = this.calcQuantities(list);
        if (d2 < -0.2) {
            return PlanetSystemType.ANTI_ORDERED;
        }
        if (d2 > 0.2) {
            return PlanetSystemType.ORDERED;
        }
        double d3 = this.calcStandardDeviationModified(list);
        if (d3 <= (d = Math.sqrt(list.size() - 1) / 2.0)) {
            return PlanetSystemType.SIMILAR;
        }
        return PlanetSystemType.MIXED;
    }

    public double calcQuantities(List<Double> list) {
        double d = 0.0;
        for (int i = 0; i < list.size() - 1; ++i) {
            d += this.calcQuantity(list.get(i), list.get(i + 1));
        }
        return 1.0 / (double)(list.size() - 1) * d;
    }

    private double calcQuantity(double d, double d2) {
        return Math.log10(d2 / d);
    }

    public double calcStandardDeviationModified(List<Double> list) {
        return this.calcStandardDeviation(list) / this.calcAverage(list);
    }

    public double calcStandardDeviation(List<Double> list) {
        double d = this.calcAverage(list);
        double d2 = 0.0;
        for (double d3 : list) {
            d2 += Math.pow(d3 - d, 2.0);
        }
        return Math.sqrt(d2 /= (double)(list.size() - 1));
    }

    private double calcAverage(List<Double> list) {
        double d = 0.0;
        for (double d2 : list) {
            d += d2;
        }
        return d /= (double)list.size();
    }

    public static enum PlanetSystemType {
        ANTI_ORDERED,
        ORDERED,
        SIMILAR,
        MIXED;

    }
}

