/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datamodel.impl;

import de.planetensuche.datamodel.api.IKoordinate;
import de.planetensuche.datamodel.api.IKoordinatenKonverter;
import de.planetensuche.datamodel.api.ISimpleSprachcontainer;
import de.planetensuche.datamodel.api.KoordinatenFormat;
import de.planetensuche.datamodel.api.KoordinatenFormatI18n;
import de.planetensuche.datamodel.impl.Koordinate;

public final class KoordinatenKonverter
implements IKoordinatenKonverter {
    private final ISimpleSprachcontainer i18n;
    private IKoordinate koordinateRa;
    private IKoordinate koordinateDecl;

    public KoordinatenKonverter(ISimpleSprachcontainer iSimpleSprachcontainer) {
        this.i18n = iSimpleSprachcontainer;
    }

    @Override
    public void setDecl(Double d) {
        this.koordinateDecl = new Koordinate(d);
    }

    @Override
    public void setRa(Double d) {
        this.koordinateRa = new Koordinate(d);
    }

    @Override
    public double berechneStundenMinutenSekunden(IKoordinate iKoordinate) {
        if (iKoordinate.getStunden() >= 0) {
            return (double)iKoordinate.getStunden() + (double)iKoordinate.getMinuten() / 60.0 + iKoordinate.getSekunden() / 3600.0;
        }
        return ((double)(iKoordinate.getStunden() * -1) + (double)iKoordinate.getMinuten() / 60.0 + iKoordinate.getSekunden() / 3600.0) * -1.0;
    }

    @Override
    public String toRaString(KoordinatenFormat koordinatenFormat, KoordinatenFormatI18n koordinatenFormatI18n) {
        return this.toStringCoordinate(RaOrDecl.RA, koordinatenFormat, koordinatenFormatI18n);
    }

    @Override
    public String toDeclString(KoordinatenFormat koordinatenFormat, KoordinatenFormatI18n koordinatenFormatI18n) {
        return this.toStringCoordinate(RaOrDecl.DECL, koordinatenFormat, koordinatenFormatI18n);
    }

    @Override
    public String toString(KoordinatenFormat koordinatenFormat, boolean bl) {
        if (bl) {
            return this.toRaString(koordinatenFormat, KoordinatenFormatI18n.NORMAL);
        }
        return this.toDeclString(koordinatenFormat, KoordinatenFormatI18n.NORMAL);
    }

    private String toStringCoordinate(RaOrDecl raOrDecl, KoordinatenFormat koordinatenFormat, KoordinatenFormatI18n koordinatenFormatI18n) {
        if (KoordinatenFormat.STUNDEN_DEZIMAL.equals((Object)koordinatenFormat)) {
            if (RaOrDecl.RA.equals((Object)raOrDecl)) {
                if (KoordinatenFormatI18n.NORMAL.equals((Object)koordinatenFormatI18n)) {
                    return this.i18n.toLocalisedDouble(this.berechneStundenMinutenSekunden(this.koordinateRa)) + " " + this.i18n.getString("db_m77");
                }
                return this.i18n.toLocalisedDouble(this.berechneStundenMinutenSekunden(this.koordinateRa)) + "h";
            }
            if (KoordinatenFormatI18n.NORMAL.equals((Object)koordinatenFormatI18n)) {
                return this.i18n.toLocalisedDouble(this.berechneStundenMinutenSekunden(this.koordinateDecl)) + " " + this.i18n.getString("db_m79");
            }
            return this.i18n.toLocalisedDouble(this.berechneStundenMinutenSekunden(this.koordinateDecl)) + "\u00b0";
        }
        double d = RaOrDecl.RA.equals((Object)raOrDecl) ? this.berechneStundenMinutenSekunden(this.koordinateRa) : this.berechneStundenMinutenSekunden(this.koordinateDecl);
        double d2 = (int)d;
        double d3 = (d - d2) * 60.0;
        double d4 = (d3 - (double)((int)d3)) * 60.0;
        if (d3 < 0.0) {
            d3 *= -1.0;
        }
        if (d4 < 0.0) {
            d4 *= -1.0;
        }
        if (RaOrDecl.RA.equals((Object)raOrDecl)) {
            return this.getRa((int)d2, (int)d3, d4, koordinatenFormatI18n);
        }
        return this.getDecl((int)d2, (int)d3, d4, koordinatenFormatI18n);
    }

    private String getRa(int n, int n2, double d, KoordinatenFormatI18n koordinatenFormatI18n) {
        boolean bl = KoordinatenFormatI18n.SHORT.equals((Object)koordinatenFormatI18n);
        boolean bl2 = KoordinatenFormatI18n.NORMAL.equals((Object)koordinatenFormatI18n);
        StringBuilder stringBuilder = new StringBuilder(10);
        stringBuilder.append(n);
        stringBuilder.append("h ");
        if (bl2 || bl && (n2 > 0 || d > 0.04)) {
            stringBuilder.append(n2);
            stringBuilder.append("m ");
            if (bl2 || bl && d > 0.04) {
                stringBuilder.append(this.i18n.toLocalisedDouble(d));
                stringBuilder.append("s");
            }
        }
        return stringBuilder.toString();
    }

    private String getDecl(int n, int n2, double d, KoordinatenFormatI18n koordinatenFormatI18n) {
        boolean bl = KoordinatenFormatI18n.SHORT.equals((Object)koordinatenFormatI18n);
        boolean bl2 = KoordinatenFormatI18n.NORMAL.equals((Object)koordinatenFormatI18n);
        StringBuilder stringBuilder = new StringBuilder(10);
        stringBuilder.append(n);
        stringBuilder.append('\u00b0');
        stringBuilder.append(" ");
        if (bl2 || bl && (n2 > 0 || d > 0.04)) {
            stringBuilder.append(n2);
            stringBuilder.append("' ");
            if (bl2 || bl && d > 0.04) {
                stringBuilder.append(this.i18n.toLocalisedDouble(d));
                stringBuilder.append("''");
            }
        }
        return stringBuilder.toString();
    }

    private static enum RaOrDecl {
        RA,
        DECL;

    }
}

