/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datamodel.impl;

import com.google.inject.Inject;
import de.planetensuche.datamodel.api.ILeuchtkraftklassenDao;
import de.planetensuche.datamodel.impl.ILeuchtkraftklassenService;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.util.ArrayList;
import java.util.Collections;

public final class LeuchtkraftklassenService
implements ILeuchtkraftklassenService {
    private final ILogging logging;
    private final Double[][][] wertebereicheLernen = new Double[70][8][2];
    private Double[][][] sterne;
    private int arrayMaxLaenge;
    private final boolean debug = false;
    private final ILeuchtkraftklassenDao dao;

    @Inject
    public LeuchtkraftklassenService(ILeuchtkraftklassenDao iLeuchtkraftklassenDao) {
        this.dao = iLeuchtkraftklassenDao;
        this.logging = LoggingFactory.getLoggerForClass(this.getClass());
    }

    @Override
    public String predictLk(String string, double d) {
        if (d <= -100.0 || string == null || string.isEmpty() || "unbekannt".equals(string) || "unknown".equals(string)) {
            return null;
        }
        this.lerneLK();
        return this.klassifiziereStern(string, d);
    }

    private String klassifiziereStern(String string, double d) {
        int n;
        String[] stringArray = new String[]{string, "" + d};
        int n2 = this.getSptypAsInt(string);
        boolean bl = false;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (bl) {
            for (n = 0; n < 8; ++n) {
                arrayList.add(n);
            }
        } else {
            for (n = 0; n < 8; ++n) {
                if (!(d <= this.wertebereicheLernen[n2][n][0]) || !(d >= this.wertebereicheLernen[n2][n][1])) continue;
                arrayList.add(n);
            }
        }
        if (arrayList.size() > 0) {
            double d2 = 100.0;
            int n3 = -1;
            if (arrayList.size() > 1) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    double d3 = this.getEntfernung(d, (Integer)arrayList.get(i), n2);
                    if (!(d3 < d2)) continue;
                    d2 = d3;
                    n3 = (Integer)arrayList.get(i);
                }
            } else {
                n3 = (Integer)arrayList.get(0);
            }
            if (n3 <= -1) {
                n3 = this.klassifiziereUnbekannt(d, n2);
            }
            return this.getLKfuerIndex(n3);
        }
        n = this.klassifiziereUnbekannt(d, n2);
        return this.getLKfuerIndex(n);
    }

    private int klassifiziereUnbekannt(double d, int n) {
        double d2;
        int n2;
        double d3 = 100.0;
        int n3 = -1;
        for (n2 = 0; n2 < 8; ++n2) {
            d2 = this.getEntfernung(d, n2, n);
            if (!(d2 < d3) || !(d2 < 4.0)) continue;
            d3 = d2;
            n3 = n2;
        }
        if (n3 > -1) {
            return n3;
        }
        d3 = 100.0;
        n3 = -1;
        for (n2 = 0; n2 < 8; ++n2) {
            d2 = 0.0;
            d2 = n2 < 4 ? 10.0 : (n2 == 4 || n2 == 7 ? 4.0 : (n2 == 5 || n2 == 6 ? 2.0 : -1.0));
            for (int i = -30; i < 31; ++i) {
                double d4;
                if (i == 0 || n + i < 0 || n + i > 69 || !((d4 = this.getEntfernung(d + (double)i / d2, n2, n + i)) < d3)) continue;
                d3 = d4;
                n3 = n2;
            }
        }
        return n3;
    }

    private boolean lerneLK() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        String[][] stringArray = this.dao.findAbsHelligkeitSpTypLk();
        for (String[] stringArray2 : stringArray) {
            if (stringArray2[0] == null) continue;
            if (stringArray2[2].equals("Ia")) {
                ++n;
            } else if (stringArray2[2].equals("Ib")) {
                ++n2;
            } else if (stringArray2[2].equals("II")) {
                ++n3;
            } else if (stringArray2[2].equals("III")) {
                ++n4;
            } else if (stringArray2[2].equals("IV")) {
                ++n5;
            } else if (stringArray2[2].equals("V")) {
                ++n6;
            } else if (stringArray2[2].equals("VI")) {
                ++n7;
            } else if (stringArray2[2].equals("VII")) {
                ++n8;
            }
            if (stringArray2[1].startsWith("O")) {
                ++n9;
            } else if (stringArray2[1].startsWith("B")) {
                ++n10;
            } else if (stringArray2[1].startsWith("A")) {
                ++n11;
            } else if (stringArray2[1].startsWith("F")) {
                ++n12;
            } else if (stringArray2[1].startsWith("G")) {
                ++n13;
            } else if (stringArray2[1].startsWith("K")) {
                ++n14;
            } else if (stringArray2[1].startsWith("M")) {
                ++n15;
            }
            ++n16;
        }
        if (n16 < 1200) {
            this.logging.warn("Im Lern-Datensatz sind nur " + n16 + " Sterne enthalten. Auf Grund der geringen Anzahl k\ufffdnnen viele Sterne\nnicht richtig oder gar nicht ihrer LK zugeordnet werden. Der Vorgang wird aber trotzdem fortgesetzt.");
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(n);
        arrayList.add(n2);
        arrayList.add(n3);
        arrayList.add(n4);
        arrayList.add(n5);
        arrayList.add(n6);
        arrayList.add(n7);
        arrayList.add(n8);
        Collections.sort(arrayList);
        this.arrayMaxLaenge = (Integer)arrayList.get(arrayList.size() - 1);
        this.sterne = new Double[70][8][this.arrayMaxLaenge];
        for (int i = 0; i < 70; ++i) {
            for (int j = 0; j < 8; ++j) {
                this.wertebereicheLernen[i][j][0] = -100.0;
                this.wertebereicheLernen[i][j][1] = -100.0;
            }
        }
        for (String[] stringArray3 : stringArray) {
            if (stringArray3[0] == null) continue;
            double d = Double.parseDouble(stringArray3[0]);
            int n17 = this.getSptypAsInt(stringArray3[1]);
            if (stringArray3[2].equals("Ia")) {
                this.sterne[n17][0][--n] = d;
                this.speichereWertebereich(n17, 0, d);
                continue;
            }
            if (stringArray3[2].equals("Ib")) {
                this.sterne[n17][1][--n2] = d;
                this.speichereWertebereich(n17, 1, d);
                continue;
            }
            if (stringArray3[2].equals("II")) {
                this.sterne[n17][2][--n3] = d;
                this.speichereWertebereich(n17, 2, d);
                continue;
            }
            if (stringArray3[2].equals("III")) {
                this.sterne[n17][3][--n4] = d;
                this.speichereWertebereich(n17, 3, d);
                continue;
            }
            if (stringArray3[2].equals("IV")) {
                this.sterne[n17][4][--n5] = d;
                this.speichereWertebereich(n17, 4, d);
                continue;
            }
            if (stringArray3[2].equals("V")) {
                this.sterne[n17][5][--n6] = d;
                this.speichereWertebereich(n17, 5, d);
                continue;
            }
            if (stringArray3[2].equals("VI")) {
                this.sterne[n17][6][--n7] = d;
                this.speichereWertebereich(n17, 6, d);
                continue;
            }
            if (stringArray3[2].equals("VII")) {
                this.sterne[n17][7][--n8] = d;
                this.speichereWertebereich(n17, 7, d);
                continue;
            }
            this.logging.warn("lk " + stringArray3[2] + " nicht erkannt!");
        }
        return true;
    }

    private int getSptypAsInt(String string) {
        if (string.startsWith("D") || string.startsWith("W")) {
            return 0;
        }
        int n = this.getIndexFuerSpektraltyp(string.charAt(0));
        try {
            String string2 = string.substring(1, string.length());
            n += (int)Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.logging.error(string + ": " + numberFormatException.getMessage(), numberFormatException);
        }
        return n;
    }

    private void speichereWertebereich(int n, int n2, double d) {
        if (n2 > -1) {
            if (this.wertebereicheLernen[n][n2][0] == -100.0) {
                this.wertebereicheLernen[n][n2][0] = d;
            } else if (d > this.wertebereicheLernen[n][n2][0]) {
                this.wertebereicheLernen[n][n2][0] = d;
            }
            if (this.wertebereicheLernen[n][n2][1] == -100.0) {
                this.wertebereicheLernen[n][n2][1] = d;
            } else if (d < this.wertebereicheLernen[n][n2][1]) {
                this.wertebereicheLernen[n][n2][1] = d;
            }
        }
    }

    private double getEntfernung(double d, int n, int n2) {
        double d2 = 100.0;
        for (int i = 0; i < this.arrayMaxLaenge; ++i) {
            double d3;
            Double d4 = this.sterne[n2][n][i];
            if (d4 == null) continue;
            if (d4 > d) {
                d3 = d4 - d;
                if (!(d3 < d2)) continue;
                d2 = d3;
                continue;
            }
            d3 = d - d4;
            if (!(d3 < d2)) continue;
            d2 = d3;
        }
        return d2;
    }

    private String getLKfuerIndex(int n) {
        switch (n) {
            case 0: {
                return "Ia";
            }
            case 1: {
                return "Ib";
            }
            case 2: {
                return "II";
            }
            case 3: {
                return "III";
            }
            case 4: {
                return "IV";
            }
            case 5: {
                return "V";
            }
            case 6: {
                return "VI";
            }
            case 7: {
                return "VII";
            }
        }
        return "unbekannt";
    }

    private int getIndexFuerSpektraltyp(char c) {
        switch (c) {
            case 'B': {
                return 10;
            }
            case 'A': {
                return 20;
            }
            case 'F': {
                return 30;
            }
            case 'G': {
                return 40;
            }
            case 'K': {
                return 50;
            }
            case 'M': {
                return 60;
            }
        }
        return 0;
    }
}

