/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datamodel.impl;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import de.planetensuche.datamodel.api.GaiaNonSingleStar;
import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.api.ObjektKategorie;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PlanetensucheObjekt
implements IPlanetensucheObjekt {
    public static final String VERSION = "2.1";
    public static final String WERT_UNBEKANNT = "unbekannt";
    private int orginalHashCode;
    private Integer datenid;
    private List<String> objektnamen;
    private Set<String> bilder;
    private Map<String, String> entdeckerNachnamenVornamen;
    private Map<String, String> entdeckerNachnamenFachgebiete;
    private String entdeckungsmethode;
    private ObjektKategorie kategorie = ObjektKategorie.UNDEFINED;
    private String objekttyp = "";
    private String sternbildDtbezeichnung;
    private String sternbildEngbezeichnung;
    private String sternbildLatbezeichnung;
    private String sternbildCode;
    private double entfernung = 0.0;
    private double durchmesser = 0.0;
    private double durchmesserGalaxieInLy = 0.0;
    private double masse = 0.0;
    private double umlaufszeit = 0.0;
    private double exzentritaet = 0.0;
    private String entdeckungsdatum;
    private int entdeckungsjahr;
    private double ra = 0.0;
    private double decl = 0.0;
    private double scheinbareHelligkeit = -100.0;
    private double absoluteHelligkeit = -100.0;
    private double flaechenhelligkeit = -100.0;
    private double temperatur = -273.15;
    private double geschwindigkeit = 0.0;
    private String spektralklasse;
    private double spektralklasse2 = 0.0;
    private String leuchtkraftklasse;
    private double bv = -100.0;
    private double metallizitaet = -100.0;
    private double albedo = 0.0;
    private String galaxienform;
    private String galaxienart;
    private int sternentstehung = 0;
    private double rotverschiebung = -10.0;
    private String sternhaufenform;
    private String nebelform;
    private String notiz;
    private boolean entdeckungBestaetigt;
    private String umkreistObjektnamen;
    private Integer umkreistDatenId;
    private Set<String> wirdUmkreistVonNamen;
    private Set<Integer> wirdUmkreistVonIds;
    private double objektAlterInMrdJahre = 0.0;
    private String autor;
    private Timestamp stamp;
    private GaiaNonSingleStar gaiaNonSingle = GaiaNonSingleStar.UNKNOWN;
    private Double gaiaRuwe;
    private Double gaiaAstrometricExNoiseSig;
    private Double gaiaRvErrorInKms;

    public PlanetensucheObjekt() {
        this.orginalHashCode = this.hashCode();
    }

    @Override
    public final boolean isGeaendert() {
        return this.orginalHashCode != this.hashCode();
    }

    @Override
    public final Integer getDatenid() {
        return this.datenid;
    }

    @Override
    public final void setDatenid(Integer n) {
        this.datenid = n;
    }

    @Override
    public double getAlterInMrdJahre() {
        return this.objektAlterInMrdJahre;
    }

    @Override
    public boolean setAlterInMrdJahre(double d) {
        this.objektAlterInMrdJahre = d;
        return true;
    }

    @Override
    public boolean isAlterInMrdJahreUnbekannt() {
        return this.objektAlterInMrdJahre == 0.0;
    }

    @Override
    public boolean setGalaxienform(String string) throws SQLException {
        this.galaxienform = string;
        return true;
    }

    @Override
    public String getGalaxienform() {
        if (this.galaxienform == null) {
            return "";
        }
        return this.galaxienform;
    }

    @Override
    public boolean isGalaxienformUnbekannt() {
        return this.galaxienform == null || "".equals(this.galaxienform);
    }

    @Override
    public boolean setGalaxienart(String string) throws SQLException {
        this.galaxienart = string;
        return true;
    }

    @Override
    public String getGalaxienart() {
        if (this.galaxienart == null) {
            return "";
        }
        return this.galaxienart;
    }

    @Override
    public boolean isGalaxienartUnbekannt() {
        return this.galaxienart == null || "".equals(this.galaxienart);
    }

    @Override
    public double getRotverschiebung() {
        return this.rotverschiebung;
    }

    @Override
    public boolean setRotverschiebung(double d) {
        this.rotverschiebung = d;
        return true;
    }

    @Override
    public boolean isRotverschiebungUnbekannt() {
        return this.rotverschiebung == -10.0;
    }

    @Override
    public int getSternentstehung() {
        return this.sternentstehung;
    }

    @Override
    public boolean setSternentstehung(int n) {
        this.sternentstehung = n;
        return true;
    }

    @Override
    public boolean isSternentstehungUnbekannt() {
        return this.sternentstehung == 0;
    }

    @Override
    public boolean setSternhaufenform(String string) throws SQLException {
        this.sternhaufenform = string;
        return true;
    }

    @Override
    public String getSternhaufenform() {
        if (this.sternhaufenform == null) {
            return "";
        }
        return this.sternhaufenform;
    }

    @Override
    public boolean isSternhaufenformUnbekannt() {
        return this.sternhaufenform == null || "".equals(this.sternhaufenform);
    }

    @Override
    public boolean setNebelform(String string) throws SQLException {
        this.nebelform = string;
        return true;
    }

    @Override
    public String getNebelform() {
        if (this.nebelform == null) {
            return "";
        }
        return this.nebelform;
    }

    @Override
    public boolean isNebelformUnbekannt() {
        return this.nebelform == null || "".equals(this.nebelform);
    }

    @Override
    public boolean setNotiz(String string) {
        this.notiz = string != null && string.endsWith(".txt") ? string.substring(0, string.length() - 4) : string;
        return true;
    }

    @Override
    public String getNotiz() {
        if (this.notiz == null) {
            return "";
        }
        return this.notiz;
    }

    @Override
    public boolean setEntdeckungsdatum(String string) {
        this.entdeckungsdatum = string;
        return true;
    }

    @Override
    public String getEntdeckungsdatum() {
        if (this.entdeckungsdatum == null) {
            return "";
        }
        return this.entdeckungsdatum;
    }

    @Override
    public boolean isEntdeckungsdatumUnbekannt() {
        return this.entdeckungsdatum == null || "".equals(this.entdeckungsdatum);
    }

    @Override
    public boolean setBV(double d) {
        this.bv = d;
        return true;
    }

    @Override
    public double getBV() {
        return this.bv;
    }

    @Override
    public boolean isBVUnbekannt() {
        return this.bv == -100.0;
    }

    @Override
    public boolean setMetallizitaet(double d) {
        this.metallizitaet = d;
        return true;
    }

    @Override
    public double getMetallizitaet() {
        return this.metallizitaet;
    }

    @Override
    public boolean isMetallizitaetUnbekannt() {
        return this.metallizitaet == -100.0;
    }

    @Override
    public boolean setEntfernung(double d) {
        this.entfernung = d;
        return true;
    }

    @Override
    public double getEntfernung() {
        return this.entfernung;
    }

    @Override
    public boolean isEntfernungUnbekannt() {
        return this.entfernung == 0.0;
    }

    @Override
    public boolean setDurchmesser(double d) {
        this.durchmesser = d;
        return true;
    }

    @Override
    public double getDurchmesser() {
        return this.durchmesser;
    }

    @Override
    public boolean isDurchmesserUnbekannt() {
        return this.durchmesser == 0.0;
    }

    @Override
    public boolean setGalaxienDurchmesserInLy(double d) {
        this.durchmesserGalaxieInLy = d;
        return true;
    }

    @Override
    public double getGalaxienDurchmesserInLy() {
        return this.durchmesserGalaxieInLy;
    }

    @Override
    public boolean isGalaxiendurchmesserInLyUnbekannt() {
        return this.durchmesserGalaxieInLy == 0.0;
    }

    @Override
    public boolean setMasse(double d) {
        this.masse = d;
        return true;
    }

    @Override
    public double getMasse() {
        return this.masse;
    }

    @Override
    public boolean isMasseUnbekannt() {
        return this.masse == 0.0;
    }

    @Override
    public boolean setUmlaufszeit(double d) {
        this.umlaufszeit = d;
        return true;
    }

    @Override
    public double getUmlaufszeit() {
        return this.umlaufszeit;
    }

    @Override
    public boolean isUmlaufszeitUnbekannt() {
        return this.umlaufszeit == 0.0;
    }

    @Override
    public boolean setExzentritaet(double d) {
        this.exzentritaet = d;
        return true;
    }

    @Override
    public double getExzentritaet() {
        return this.exzentritaet;
    }

    @Override
    public boolean isExzentritaetUnbekannt() {
        return this.exzentritaet == 0.0;
    }

    @Override
    public boolean setTemperatur(double d) {
        this.temperatur = d;
        return true;
    }

    @Override
    public double getTemperatur() {
        return this.temperatur;
    }

    @Override
    public boolean isTemperaturUnbekannt() {
        return this.temperatur == -273.15;
    }

    @Override
    public boolean setAlbedo(double d) {
        this.albedo = d;
        return true;
    }

    @Override
    public double getAlbedo() {
        return this.albedo;
    }

    @Override
    public boolean isAlbedoUnbekannt() {
        return this.albedo == 0.0;
    }

    @Override
    public boolean setGeschwindigkeit(double d) {
        this.geschwindigkeit = d;
        return true;
    }

    @Override
    public double getGeschwindigkeit() {
        return this.geschwindigkeit;
    }

    @Override
    public boolean isGeschwindigkeitUnbekannt() {
        return this.geschwindigkeit == 0.0;
    }

    @Override
    public boolean setScheinbareHelligkeit(double d) {
        this.scheinbareHelligkeit = d;
        return true;
    }

    @Override
    public double getScheinbareHelligkeit() {
        return this.scheinbareHelligkeit;
    }

    @Override
    public boolean isScheinbareHelligkeitUnbekannt() {
        return this.scheinbareHelligkeit == -100.0;
    }

    @Override
    public boolean setAbsoluteHelligkeit(double d) {
        this.absoluteHelligkeit = d;
        return true;
    }

    @Override
    public double getAbsoluteHelligkeit() {
        return this.absoluteHelligkeit;
    }

    @Override
    public boolean isAbsoluteHelligkeitUnbekannt() {
        return this.absoluteHelligkeit == -100.0;
    }

    @Override
    public boolean setFlaechenhelligkeit(double d) {
        this.flaechenhelligkeit = d;
        return true;
    }

    @Override
    public double getFlaechenhelligkeit() {
        return this.flaechenhelligkeit;
    }

    @Override
    public boolean isFlaechenhelligkeitUnbekannt() {
        return this.flaechenhelligkeit == -100.0;
    }

    @Override
    public boolean setRA(double d) {
        this.ra = d;
        return true;
    }

    @Override
    public double getRA() {
        return this.ra;
    }

    @Override
    public boolean isRaUnbekannt() {
        return this.ra == 0.0;
    }

    @Override
    public boolean setDECL(double d) {
        this.decl = d;
        return true;
    }

    @Override
    public double getDECL() {
        return this.decl;
    }

    @Override
    public boolean isDeclUnbekannt() {
        return this.decl == 0.0;
    }

    @Override
    public boolean isKoordinatenUnbekannt() {
        return this.isDeclUnbekannt() && this.isRaUnbekannt();
    }

    @Override
    public boolean setSpektralklasse(String string) throws SQLException {
        this.spektralklasse = string;
        return true;
    }

    @Override
    public String getSpektralklasse() {
        if (this.spektralklasse == null) {
            return WERT_UNBEKANNT;
        }
        return this.spektralklasse;
    }

    @Override
    public boolean isSpektralklasseUnbekannt() {
        return this.spektralklasse == null || WERT_UNBEKANNT.equals(this.spektralklasse);
    }

    @Override
    public boolean setSpektralklasse2(double d) throws SQLException {
        this.spektralklasse2 = d;
        return true;
    }

    @Override
    public double getSpektralklasse2() {
        return this.spektralklasse2;
    }

    @Override
    public boolean setLeuchtkraftklasse(String string) throws SQLException {
        this.leuchtkraftklasse = string;
        return true;
    }

    @Override
    public String getLeuchtkraftklasse() {
        if (this.leuchtkraftklasse == null) {
            return WERT_UNBEKANNT;
        }
        return this.leuchtkraftklasse;
    }

    @Override
    public boolean isLeuchtkraftklasseUnbekannt() {
        return this.leuchtkraftklasse == null || WERT_UNBEKANNT.equals(this.leuchtkraftklasse);
    }

    @Override
    public boolean setUmkreistObjekt(String string) throws SQLException {
        this.umkreistObjektnamen = string;
        return true;
    }

    @Override
    public String getUmkreistObjekt() {
        if (this.umkreistObjektnamen == null) {
            return "";
        }
        return this.umkreistObjektnamen;
    }

    @Override
    public boolean setUmkreistDatenId(Integer n) throws SQLException {
        this.umkreistDatenId = n;
        return true;
    }

    @Override
    public Integer getUmkreistDatenId() {
        return this.umkreistDatenId;
    }

    @Override
    public void setWirdUmkreistVon(Set<String> set) {
        this.wirdUmkreistVonNamen = set;
    }

    @Override
    public void setWirdUmkreistVonIDs(Set<Integer> set) {
        this.wirdUmkreistVonIds = set;
    }

    @Override
    public Set<String> getWirdUmkreistVonNamen() {
        if (this.wirdUmkreistVonNamen == null) {
            return new HashSet<String>(0);
        }
        return this.wirdUmkreistVonNamen;
    }

    @Override
    public Set<Integer> getWirdUmkreistVonIDs() {
        if (this.wirdUmkreistVonIds == null) {
            return new HashSet<Integer>(0);
        }
        return this.wirdUmkreistVonIds;
    }

    @Override
    public void setSternbildDTBezeichnung(String string) {
        this.sternbildDtbezeichnung = string;
    }

    @Override
    public String getSternbildDTBezeichnung() {
        if (this.sternbildDtbezeichnung == null) {
            return WERT_UNBEKANNT;
        }
        return this.sternbildDtbezeichnung;
    }

    @Override
    public void setSternbildENGBezeichnung(String string) {
        this.sternbildEngbezeichnung = string;
    }

    @Override
    public String getSternbildENGBezeichnung() {
        if (this.sternbildEngbezeichnung == null) {
            return "unknown";
        }
        return this.sternbildEngbezeichnung;
    }

    @Override
    public void setSternbildLATBezeichnung(String string) {
        this.sternbildLatbezeichnung = string;
    }

    @Override
    public String getSternbildLATBezeichnung() {
        if (this.sternbildLatbezeichnung == null) {
            return WERT_UNBEKANNT;
        }
        return this.sternbildLatbezeichnung;
    }

    @Override
    public boolean setKategorie(String string) throws SQLException {
        this.kategorie = ObjektKategorie.parse(string);
        return true;
    }

    @Override
    public String getKategorie() {
        return this.kategorie.getKategorienName();
    }

    @Override
    public boolean setObjekttyp(String string) throws SQLException {
        this.objekttyp = string;
        return true;
    }

    @Override
    public String getObjekttyp() {
        return this.objekttyp;
    }

    @Override
    public boolean setEntdeckungsmethode(String string) throws SQLException {
        this.entdeckungsmethode = string;
        return true;
    }

    @Override
    public String getEntdeckungsmethode() {
        if (this.entdeckungsmethode == null) {
            return "";
        }
        return this.entdeckungsmethode;
    }

    @Override
    public boolean isEntdeckungsmethodeUnbekannt() {
        return this.entdeckungsmethode == null || "".equals(this.entdeckungsmethode);
    }

    @Override
    public boolean setObjektNamen(Set<String> set) {
        this.erzeugeNeueObjektnamenListe(set);
        return true;
    }

    @Override
    public final void nichtMehrGeaendert() {
        this.orginalHashCode = this.hashCode();
    }

    @Override
    public void setEntdeckungBestaetigt(boolean bl) {
        this.entdeckungBestaetigt = bl;
    }

    @Override
    public boolean isEntdeckungBestaetigt() {
        return this.entdeckungBestaetigt;
    }

    private void erzeugeNeueObjektnamenListe(Set<String> set) {
        this.objektnamen = new ArrayList<String>();
        this.objektnamen.addAll(set);
        Collections.sort(this.objektnamen);
    }

    @Override
    public List<String> getObjektNamen() {
        if (this.objektnamen == null) {
            return new ArrayList<String>();
        }
        return this.objektnamen;
    }

    @Override
    public void setBilder(Set<String> set) {
        this.bilder = set;
    }

    @Override
    public Set<String> getBilder() {
        if (this.bilder == null) {
            return new HashSet<String>();
        }
        return this.bilder;
    }

    @Override
    public String getAutor() {
        if (this.autor == null) {
            return WERT_UNBEKANNT;
        }
        return this.autor;
    }

    @Override
    public void setAutor(String string) {
        this.autor = string;
    }

    @Override
    public int getEntdeckungsjahr() {
        return this.entdeckungsjahr;
    }

    @Override
    public void setEntdeckungsjahr(Integer n) {
        if (n != null) {
            this.entdeckungsjahr = n;
        }
    }

    @Override
    public Timestamp getStamp() {
        if (this.stamp == null) {
            return new Timestamp(System.currentTimeMillis());
        }
        return this.stamp;
    }

    @Override
    public void setStamp(Timestamp timestamp) {
        this.stamp = timestamp;
    }

    @Override
    public final String toString(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder(37);
        for (int i = 0; i < list.size(); ++i) {
            stringBuilder.append(list.get(i));
            if (i >= list.size() - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    @Override
    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder(37);
        stringBuilder.append("datenId:");
        stringBuilder.append(this.datenid).append("; ");
        stringBuilder.append("Namen:[");
        stringBuilder.append(this.toString(this.getObjektNamen()));
        stringBuilder.append("]");
        stringBuilder.append("; Kategorie:");
        stringBuilder.append((Object)this.kategorie);
        stringBuilder.append("; Objekttyp:");
        stringBuilder.append(this.objekttyp);
        stringBuilder.append("; Timestamp:");
        stringBuilder.append(this.stamp);
        stringBuilder.append("; AH:");
        stringBuilder.append(this.absoluteHelligkeit);
        stringBuilder.append("; Albedo:");
        stringBuilder.append(this.albedo);
        stringBuilder.append("; Autor:");
        stringBuilder.append(this.autor);
        stringBuilder.append("; Bilder:[");
        stringBuilder.append(Arrays.toString(this.getBilder().toArray()));
        stringBuilder.append("]");
        stringBuilder.append("; B-V:");
        stringBuilder.append(this.bv);
        stringBuilder.append("; DECL:");
        stringBuilder.append(this.decl);
        stringBuilder.append("; dt. Bez.:");
        stringBuilder.append(this.sternbildDtbezeichnung);
        stringBuilder.append("; Durchmesser:");
        stringBuilder.append(this.durchmesser);
        stringBuilder.append("; Durchmesser2:");
        stringBuilder.append(this.durchmesserGalaxieInLy);
        stringBuilder.append("; Entdeckungsdatum:");
        stringBuilder.append(this.entdeckungsdatum);
        stringBuilder.append("; Entdeckungsmethode:");
        stringBuilder.append(this.entdeckungsmethode);
        stringBuilder.append("; Entfernung:");
        stringBuilder.append(this.entfernung);
        stringBuilder.append("; Exzentritaet:");
        stringBuilder.append(this.exzentritaet);
        stringBuilder.append("; Galaxienart:");
        stringBuilder.append(this.galaxienart);
        stringBuilder.append("; Galaxienform:");
        stringBuilder.append(this.galaxienform);
        stringBuilder.append("; Geschwindigkeit:");
        stringBuilder.append(this.geschwindigkeit);
        stringBuilder.append("; Leuchtkraftklasse:");
        stringBuilder.append(this.leuchtkraftklasse);
        stringBuilder.append("; Masse:");
        stringBuilder.append(this.masse);
        stringBuilder.append("; Metallizitaet:");
        stringBuilder.append(this.metallizitaet);
        stringBuilder.append("; Entdecker:[");
        if (this.entdeckerNachnamenVornamen != null) {
            for (String string : this.entdeckerNachnamenVornamen.keySet()) {
                stringBuilder.append(string);
                stringBuilder.append(", ");
            }
        }
        stringBuilder.append("]");
        stringBuilder.append("; Nebelform:");
        stringBuilder.append(this.nebelform);
        stringBuilder.append("; Notiz:");
        stringBuilder.append(this.notiz);
        stringBuilder.append("; RA:");
        stringBuilder.append(this.ra);
        stringBuilder.append("; Rotverschiebung:");
        stringBuilder.append(this.rotverschiebung);
        stringBuilder.append("; SH:");
        stringBuilder.append(this.scheinbareHelligkeit);
        stringBuilder.append("; Spektraltyp:");
        stringBuilder.append(this.spektralklasse);
        stringBuilder.append(this.spektralklasse2);
        stringBuilder.append("; Sternentstehungsrate:");
        stringBuilder.append(this.sternentstehung);
        stringBuilder.append("; Sternhaufenform:");
        stringBuilder.append(this.sternhaufenform);
        stringBuilder.append("; Temperatur:");
        stringBuilder.append(this.temperatur);
        stringBuilder.append("; Umlaufszeit:");
        stringBuilder.append(this.umlaufszeit);
        stringBuilder.append("; Umkreist Objekt:");
        stringBuilder.append(this.umkreistObjektnamen);
        stringBuilder.append("; Wird umkreist von:[");
        stringBuilder.append(Arrays.toString(this.getWirdUmkreistVonNamen().toArray()));
        stringBuilder.append("]");
        stringBuilder.append("; Alter:");
        stringBuilder.append(this.objektAlterInMrdJahre);
        stringBuilder.append("; gaia rv error:");
        stringBuilder.append(this.gaiaRvErrorInKms == null ? "" : this.gaiaRvErrorInKms);
        stringBuilder.append("; gaia ruwe:");
        stringBuilder.append(this.gaiaRuwe == null ? "" : this.gaiaRuwe);
        stringBuilder.append("; gaia astrometric ex noise sig:");
        stringBuilder.append(this.gaiaAstrometricExNoiseSig == null ? "" : this.gaiaAstrometricExNoiseSig);
        stringBuilder.append("; gaia non single:");
        stringBuilder.append(this.gaiaNonSingle == null ? "" : this.gaiaNonSingle);
        stringBuilder.append("; ge\u00e4ndert?:");
        stringBuilder.append(this.isGeaendert());
        return stringBuilder.toString();
    }

    @Override
    public final boolean equalsContent(IPlanetensucheObjekt iPlanetensucheObjekt) {
        if (iPlanetensucheObjekt == null) {
            return false;
        }
        if (!this.kategorie.equals((Object)iPlanetensucheObjekt.getCategory())) {
            return false;
        }
        if (!this.objekttyp.equals(iPlanetensucheObjekt.getObjekttyp())) {
            return false;
        }
        if (!this.objektnamen.equals(iPlanetensucheObjekt.getObjektNamen())) {
            return false;
        }
        if (!this.getBilder().equals(iPlanetensucheObjekt.getBilder())) {
            return false;
        }
        if (!this.getEntdeckerMitNachnamenVornamen().equals(iPlanetensucheObjekt.getEntdeckerMitNachnamenVornamen())) {
            MapDifference<String, String> mapDifference = Maps.difference(this.getEntdeckerMitNachnamenVornamen(), iPlanetensucheObjekt.getEntdeckerMitNachnamenVornamen());
            return false;
        }
        if (!this.getEntdeckerMitNachnamenFachgebiete().equals(iPlanetensucheObjekt.getEntdeckerMitNachnamenFachgebiete())) {
            MapDifference<String, String> mapDifference = Maps.difference(this.getEntdeckerMitNachnamenVornamen(), iPlanetensucheObjekt.getEntdeckerMitNachnamenVornamen());
            return false;
        }
        if (!this.getEntdeckungsmethode().equals(iPlanetensucheObjekt.getEntdeckungsmethode())) {
            return false;
        }
        if (!this.getSternbildDTBezeichnung().equals(iPlanetensucheObjekt.getSternbildDTBezeichnung())) {
            return false;
        }
        if (!this.getSternbildENGBezeichnung().equals(iPlanetensucheObjekt.getSternbildENGBezeichnung())) {
            return false;
        }
        if (!this.getSternbildLATBezeichnung().equals(iPlanetensucheObjekt.getSternbildLATBezeichnung())) {
            return false;
        }
        if (!this.getSternbildCode().equals(iPlanetensucheObjekt.getSternbildCode())) {
            return false;
        }
        if (this.entfernung != iPlanetensucheObjekt.getEntfernung()) {
            return false;
        }
        if (this.durchmesser != iPlanetensucheObjekt.getDurchmesser()) {
            return false;
        }
        if (this.durchmesserGalaxieInLy != iPlanetensucheObjekt.getGalaxienDurchmesserInLy()) {
            return false;
        }
        if (this.masse != iPlanetensucheObjekt.getMasse()) {
            return false;
        }
        if (this.umlaufszeit != iPlanetensucheObjekt.getUmlaufszeit()) {
            return false;
        }
        if (this.exzentritaet != iPlanetensucheObjekt.getExzentritaet()) {
            return false;
        }
        if (!this.getEntdeckungsdatum().equals(iPlanetensucheObjekt.getEntdeckungsdatum())) {
            return false;
        }
        if (this.isEntdeckungBestaetigt() != iPlanetensucheObjekt.isEntdeckungBestaetigt()) {
            return false;
        }
        if (this.ra != iPlanetensucheObjekt.getRA()) {
            return false;
        }
        if (this.decl != iPlanetensucheObjekt.getDECL()) {
            return false;
        }
        if (this.scheinbareHelligkeit != iPlanetensucheObjekt.getScheinbareHelligkeit()) {
            return false;
        }
        if (this.absoluteHelligkeit != iPlanetensucheObjekt.getAbsoluteHelligkeit()) {
            return false;
        }
        if (this.flaechenhelligkeit != iPlanetensucheObjekt.getFlaechenhelligkeit()) {
            return false;
        }
        if (this.temperatur != iPlanetensucheObjekt.getTemperatur()) {
            return false;
        }
        if (this.geschwindigkeit != iPlanetensucheObjekt.getGeschwindigkeit()) {
            return false;
        }
        if (!this.getSpektralklasse().equals(iPlanetensucheObjekt.getSpektralklasse())) {
            return false;
        }
        if (this.spektralklasse2 != iPlanetensucheObjekt.getSpektralklasse2()) {
            return false;
        }
        if (!this.getLeuchtkraftklasse().equals(iPlanetensucheObjekt.getLeuchtkraftklasse())) {
            return false;
        }
        if (this.bv != iPlanetensucheObjekt.getBV()) {
            return false;
        }
        if (this.metallizitaet != iPlanetensucheObjekt.getMetallizitaet()) {
            return false;
        }
        if (this.albedo != iPlanetensucheObjekt.getAlbedo()) {
            return false;
        }
        if (!this.getGalaxienform().equals(iPlanetensucheObjekt.getGalaxienform())) {
            return false;
        }
        if (!this.getGalaxienart().equals(iPlanetensucheObjekt.getGalaxienart())) {
            return false;
        }
        if (this.sternentstehung != iPlanetensucheObjekt.getSternentstehung()) {
            return false;
        }
        if (this.rotverschiebung != iPlanetensucheObjekt.getRotverschiebung()) {
            return false;
        }
        if (!this.getSternhaufenform().equals(iPlanetensucheObjekt.getSternhaufenform())) {
            return false;
        }
        if (!this.getNebelform().equals(iPlanetensucheObjekt.getNebelform())) {
            return false;
        }
        if (!this.getNotiz().equals(iPlanetensucheObjekt.getNotiz())) {
            return false;
        }
        if (!this.getUmkreistObjekt().equals(iPlanetensucheObjekt.getUmkreistObjekt())) {
            return false;
        }
        if (!Objects.equals(this.getUmkreistDatenId(), iPlanetensucheObjekt.getUmkreistDatenId())) {
            return false;
        }
        if (!this.getWirdUmkreistVonNamen().equals(iPlanetensucheObjekt.getWirdUmkreistVonNamen())) {
            return false;
        }
        if (!this.getWirdUmkreistVonIDs().equals(iPlanetensucheObjekt.getWirdUmkreistVonIDs())) {
            return false;
        }
        if (this.objektAlterInMrdJahre != iPlanetensucheObjekt.getAlterInMrdJahre()) {
            return false;
        }
        if (!this.autor.equals(iPlanetensucheObjekt.getAutor())) {
            return false;
        }
        if (this.isGaiaAstroExNoiseSigUnbekannt() != iPlanetensucheObjekt.isGaiaAstroExNoiseSigUnbekannt()) {
            return false;
        }
        if (this.isGaiaNonSingleUnbekannt() != iPlanetensucheObjekt.isGaiaNonSingleUnbekannt()) {
            return false;
        }
        if (this.isGaiaRuweUnbekannt() != iPlanetensucheObjekt.isGaiaRuweUnbekannt()) {
            return false;
        }
        return this.isGaiaRvErrorUnbekannt() == iPlanetensucheObjekt.isGaiaRvErrorUnbekannt();
    }

    public int hashCode() {
        int n = 7;
        n = 79 * n + Objects.hashCode(this.datenid);
        n = 79 * n + Objects.hashCode(this.objektnamen);
        n = 79 * n + Objects.hashCode(this.bilder);
        n = 79 * n + Objects.hashCode(this.entdeckerNachnamenVornamen);
        n = 79 * n + Objects.hashCode(this.entdeckerNachnamenFachgebiete);
        n = 79 * n + Objects.hashCode(this.entdeckungsmethode);
        n = 79 * n + Objects.hashCode((Object)this.kategorie);
        n = 79 * n + Objects.hashCode(this.objekttyp);
        n = 79 * n + Objects.hashCode(this.sternbildDtbezeichnung);
        n = 79 * n + Objects.hashCode(this.sternbildEngbezeichnung);
        n = 79 * n + Objects.hashCode(this.sternbildLatbezeichnung);
        n = 79 * n + Objects.hashCode(this.sternbildCode);
        n = 79 * n + (int)(Double.doubleToLongBits(this.entfernung) ^ Double.doubleToLongBits(this.entfernung) >>> 32);
        n = 79 * n + (int)(Double.doubleToLongBits(this.durchmesser) ^ Double.doubleToLongBits(this.durchmesser) >>> 32);
        n = 79 * n + (int)(Double.doubleToLongBits(this.durchmesserGalaxieInLy) ^ Double.doubleToLongBits(this.durchmesserGalaxieInLy) >>> 32);
        n = 79 * n + (int)(Double.doubleToLongBits(this.masse) ^ Double.doubleToLongBits(this.masse) >>> 32);
        n = 79 * n + (int)(Double.doubleToLongBits(this.umlaufszeit) ^ Double.doubleToLongBits(this.umlaufszeit) >>> 32);
        n = 79 * n + (int)(Double.doubleToLongBits(this.exzentritaet) ^ Double.doubleToLongBits(this.exzentritaet) >>> 32);
        n = 79 * n + Objects.hashCode(this.entdeckungsdatum);
        n = 79 * n + this.entdeckungsjahr;
        n = 79 * n + (int)(Double.doubleToLongBits(this.ra) ^ Double.doubleToLongBits(this.ra) >>> 32);
        n = 79 * n + (int)(Double.doubleToLongBits(this.decl) ^ Double.doubleToLongBits(this.decl) >>> 32);
        n = 79 * n + (int)(Double.doubleToLongBits(this.scheinbareHelligkeit) ^ Double.doubleToLongBits(this.scheinbareHelligkeit) >>> 32);
        n = 79 * n + (int)(Double.doubleToLongBits(this.absoluteHelligkeit) ^ Double.doubleToLongBits(this.absoluteHelligkeit) >>> 32);
        n = 79 * n + (int)(Double.doubleToLongBits(this.flaechenhelligkeit) ^ Double.doubleToLongBits(this.flaechenhelligkeit) >>> 32);
        n = 79 * n + (int)(Double.doubleToLongBits(this.temperatur) ^ Double.doubleToLongBits(this.temperatur) >>> 32);
        n = 79 * n + (int)(Double.doubleToLongBits(this.geschwindigkeit) ^ Double.doubleToLongBits(this.geschwindigkeit) >>> 32);
        n = 79 * n + Objects.hashCode(this.spektralklasse);
        n = 79 * n + (int)(Double.doubleToLongBits(this.spektralklasse2) ^ Double.doubleToLongBits(this.spektralklasse2) >>> 32);
        n = 79 * n + Objects.hashCode(this.leuchtkraftklasse);
        n = 79 * n + (int)(Double.doubleToLongBits(this.bv) ^ Double.doubleToLongBits(this.bv) >>> 32);
        n = 79 * n + (int)(Double.doubleToLongBits(this.metallizitaet) ^ Double.doubleToLongBits(this.metallizitaet) >>> 32);
        n = 79 * n + (int)(Double.doubleToLongBits(this.albedo) ^ Double.doubleToLongBits(this.albedo) >>> 32);
        n = 79 * n + Objects.hashCode(this.galaxienform);
        n = 79 * n + Objects.hashCode(this.galaxienart);
        n = 79 * n + this.sternentstehung;
        n = 79 * n + (int)(Double.doubleToLongBits(this.rotverschiebung) ^ Double.doubleToLongBits(this.rotverschiebung) >>> 32);
        n = 79 * n + Objects.hashCode(this.sternhaufenform);
        n = 79 * n + Objects.hashCode(this.nebelform);
        n = 79 * n + Objects.hashCode(this.notiz);
        n = 79 * n + (this.entdeckungBestaetigt ? 1 : 0);
        n = 79 * n + Objects.hashCode(this.umkreistObjektnamen);
        n = 79 * n + Objects.hashCode(this.umkreistDatenId);
        n = 79 * n + Objects.hashCode(this.wirdUmkreistVonNamen);
        n = 79 * n + Objects.hashCode(this.wirdUmkreistVonIds);
        n = 79 * n + (int)(Double.doubleToLongBits(this.objektAlterInMrdJahre) ^ Double.doubleToLongBits(this.objektAlterInMrdJahre) >>> 32);
        n = 79 * n + Objects.hashCode(this.autor);
        n = 79 * n + Objects.hashCode(this.stamp);
        n = 79 * n + Objects.hashCode((Object)this.gaiaNonSingle);
        n = 79 * n + Objects.hashCode(this.gaiaRuwe);
        n = 79 * n + Objects.hashCode(this.gaiaAstrometricExNoiseSig);
        n = 79 * n + Objects.hashCode(this.gaiaRvErrorInKms);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PlanetensucheObjekt planetensucheObjekt = (PlanetensucheObjekt)object;
        return this.equalsContent(planetensucheObjekt);
    }

    @Override
    public Map<String, String> getEntdeckerMitNachnamenVornamen() {
        if (this.entdeckerNachnamenVornamen == null) {
            return new HashMap<String, String>();
        }
        return this.entdeckerNachnamenVornamen;
    }

    @Override
    public Map<String, String> getEntdeckerMitNachnamenFachgebiete() {
        if (this.entdeckerNachnamenFachgebiete == null) {
            return new HashMap<String, String>();
        }
        return this.entdeckerNachnamenFachgebiete;
    }

    @Override
    public void setEntdeckerMitNachnamenVornamen(Map<String, String> map) {
        this.entdeckerNachnamenVornamen = map;
    }

    @Override
    public void setEntdeckerMitNachnamenFachgebiete(Map<String, String> map) {
        this.entdeckerNachnamenFachgebiete = map;
    }

    @Override
    public boolean setSternbildCode(String string) {
        this.sternbildCode = string;
        return true;
    }

    @Override
    public String getSternbildCode() {
        if (this.sternbildCode == null) {
            return WERT_UNBEKANNT;
        }
        return this.sternbildCode;
    }

    @Override
    public boolean isSternbildUnbekannt() {
        boolean bl = this.sternbildDtbezeichnung == null || this.sternbildDtbezeichnung.isEmpty() || WERT_UNBEKANNT.equals(this.sternbildDtbezeichnung);
        boolean bl2 = this.sternbildEngbezeichnung == null || this.sternbildEngbezeichnung.isEmpty() || WERT_UNBEKANNT.equals(this.sternbildEngbezeichnung) || "unknown".equals(this.sternbildEngbezeichnung);
        boolean bl3 = this.sternbildLatbezeichnung == null || this.sternbildLatbezeichnung.isEmpty() || WERT_UNBEKANNT.equals(this.sternbildLatbezeichnung);
        boolean bl4 = this.sternbildCode == null || this.sternbildCode.isEmpty() || WERT_UNBEKANNT.equals(this.sternbildCode) || "unb".equals(this.sternbildCode);
        return bl4 && bl && bl2 && bl3;
    }

    @Override
    public double getGaiaRvError() {
        return this.gaiaRvErrorInKms;
    }

    @Override
    public void setGaiaRvError(double d) {
        this.gaiaRvErrorInKms = d;
    }

    @Override
    public boolean isGaiaRvErrorUnbekannt() {
        return this.gaiaRvErrorInKms == null;
    }

    @Override
    public double getGaiaRuwe() {
        return this.gaiaRuwe;
    }

    @Override
    public void setGaiaRuwe(double d) {
        this.gaiaRuwe = d;
    }

    @Override
    public boolean isGaiaRuweUnbekannt() {
        return this.gaiaRuwe == null;
    }

    @Override
    public double getGaiaAstroExNoiseSig() {
        return this.gaiaAstrometricExNoiseSig;
    }

    @Override
    public void setGaiaAstroExNoiseSig(double d) {
        this.gaiaAstrometricExNoiseSig = d;
    }

    @Override
    public boolean isGaiaAstroExNoiseSigUnbekannt() {
        return this.gaiaAstrometricExNoiseSig == null;
    }

    @Override
    public GaiaNonSingleStar getGaiaNonSingle() {
        return this.gaiaNonSingle;
    }

    @Override
    public void setGaiaNonSingle(GaiaNonSingleStar gaiaNonSingleStar) {
        this.gaiaNonSingle = gaiaNonSingleStar == null ? GaiaNonSingleStar.UNKNOWN : gaiaNonSingleStar;
    }

    @Override
    public boolean isGaiaNonSingleUnbekannt() {
        return this.gaiaNonSingle == null || this.gaiaNonSingle == GaiaNonSingleStar.UNKNOWN;
    }

    @Override
    public ObjektKategorie getCategory() {
        return this.kategorie;
    }

    @Override
    public boolean setCategory(ObjektKategorie objektKategorie) {
        this.kategorie = objektKategorie;
        return true;
    }
}

