/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.errorlogger.api;

import de.planetensuche.errorlogger.api.IBugreport;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.Modulnummer;
import de.planetensuche.errorlogger.impl.DateiLogging;
import de.planetensuche.errorlogger.impl.KonsolenLogging;
import de.planetensuche.errorlogger.test.NullLogging;
import java.awt.HeadlessException;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.JOptionPane;

public final class LoggingFactory {
    private static IBugreport registeredBugreport;
    private static final Map<Modulnummer, ILogging> LOGGERS;

    private LoggingFactory() {
    }

    public static void addBugreport(IBugreport iBugreport) {
        registeredBugreport = iBugreport;
        for (Map.Entry<Modulnummer, ILogging> entry : LOGGERS.entrySet()) {
            entry.getValue().registriereBugreport(iBugreport);
        }
    }

    public static ILogging getLoggerForClass(Class<?> clazz) {
        Package package_ = clazz.getPackage();
        String string = package_.getName();
        if (string.startsWith("de.planetensuche.installer.")) {
            return LoggingFactory.getLoggerForModule(Modulnummer.INSTALLER);
        }
        if (string.startsWith("de.planetensuche.updater.")) {
            return LoggingFactory.getLoggerForModule(Modulnummer.UPDATE);
        }
        return LoggingFactory.getLoggerForModule(Modulnummer.HAUPTLOG);
    }

    public static ILogging getLoggerForModule(Modulnummer modulnummer) {
        ILogging iLogging = LOGGERS.get((Object)modulnummer);
        if (iLogging == null) {
            try {
                iLogging = LoggingFactory.isUnitTestRunning() ? new KonsolenLogging() : LoggingFactory.createProductionLogger(modulnummer);
            }
            catch (Exception exception) {
                LoggingFactory.handleExceptionWithoutLogger(exception);
                iLogging = new NullLogging();
            }
            LOGGERS.put(modulnummer, iLogging);
        } else {
            try {
                if (iLogging instanceof DateiLogging && LoggingFactory.isUnitTestRunning()) {
                    iLogging = new KonsolenLogging();
                    LOGGERS.put(modulnummer, iLogging);
                } else if (iLogging instanceof KonsolenLogging && !LoggingFactory.isUnitTestRunning()) {
                    iLogging = LoggingFactory.createProductionLogger(modulnummer);
                    LOGGERS.put(modulnummer, iLogging);
                }
            }
            catch (Exception exception) {
                LoggingFactory.handleExceptionWithoutLogger(exception);
                iLogging = new NullLogging();
            }
        }
        return iLogging;
    }

    private static void handleExceptionWithoutLogger(Exception exception) throws HeadlessException {
        exception.printStackTrace();
        System.out.println("can't create logger; use null logger because of " + exception.getMessage());
        JOptionPane.showMessageDialog(null, exception.getLocalizedMessage(), "Logging", 0);
    }

    private static ILogging createProductionLogger(Modulnummer modulnummer) throws Exception {
        DateiLogging dateiLogging = new DateiLogging(modulnummer);
        if (registeredBugreport != null) {
            dateiLogging.registriereBugreport(registeredBugreport);
        }
        return dateiLogging;
    }

    private static boolean isUnitTestRunning() {
        String string = System.getProperty("planetensuchetest");
        return "true".equalsIgnoreCase(string);
    }

    static {
        LOGGERS = new EnumMap<Modulnummer, ILogging>(Modulnummer.class);
    }
}

