/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.errorlogger.impl;

import de.planetensuche.errorlogger.api.ILogging;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JOptionPane;

public class GlobalerThrowableBehandler
extends EventQueue {
    private final ILogging logger;

    protected GlobalerThrowableBehandler(ILogging iLogging) {
        this.logger = iLogging;
    }

    @Override
    protected void dispatchEvent(AWTEvent aWTEvent) {
        try {
            super.dispatchEvent(aWTEvent);
        }
        catch (Throwable throwable) {
            boolean bl = false;
            for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                String string = stackTraceElement.getClassName().toLowerCase();
                if (!string.startsWith("de.planetensuche") || string.contains("globalerthrowablebehandler")) continue;
                bl = true;
                break;
            }
            if (!bl) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("unbehandelte Exception gefangen!", throwable);
                }
                return;
            }
            if (this.logger != null) {
                this.logger.error(throwable);
            }
            try (PrintWriter printWriter = new PrintWriter(new FileOutputStream("logs" + File.separator + "global_error.log", true));){
                throwable.printStackTrace(printWriter);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(null, iOException.toString(), "Error", 0);
            }
        }
    }
}

