/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.errorlogger.impl;

import de.planetensuche.errorlogger.api.IBugreport;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LogLevel;
import de.planetensuche.errorlogger.api.Modulnummer;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.JFrame;

public class KonsolenLogging
implements ILogging {
    private LogLevel logLevel = LogLevel.DEBUG;

    @Override
    public String getErrorMessage() {
        return "";
    }

    @Override
    public boolean isBereit() {
        return true;
    }

    @Override
    public void setErrorZaehlerAufNull() {
    }

    @Override
    public boolean isErrorZaehlerAufMax() {
        return false;
    }

    @Override
    public LogLevel getLevel() {
        return this.logLevel;
    }

    @Override
    public void setLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public void showErrorMessageBox(Frame frame, String string, String string2) {
    }

    @Override
    public void showErrorMessageBox(JFrame jFrame, String string, String string2) {
    }

    @Override
    public void info(Object object) {
        if (this.logLevel == LogLevel.INFO || this.logLevel == LogLevel.DEBUG || this.logLevel == LogLevel.ALL) {
            this.log("INFO " + String.valueOf(object));
        }
    }

    @Override
    public void info(Object object, Throwable throwable) {
        if (this.logLevel == LogLevel.INFO || this.logLevel == LogLevel.DEBUG || this.logLevel == LogLevel.ALL) {
            this.logWithStacktrace("INFO " + String.valueOf(object), throwable);
        }
    }

    @Override
    public void warn(Object object) {
        if (this.logLevel != LogLevel.OFF) {
            this.log("WARN " + String.valueOf(object));
        }
    }

    @Override
    public void warn(Object object, Throwable throwable) {
        if (this.logLevel != LogLevel.OFF) {
            this.logWithStacktrace("WARN " + String.valueOf(object), throwable);
        }
    }

    @Override
    public void error(Throwable throwable) {
        this.log("ERROR " + String.valueOf(throwable));
    }

    @Override
    public void error(Object object, Exception exception) {
        this.logWithStacktrace("ERROR " + String.valueOf(object), exception);
    }

    @Override
    public void fatal(Object object) {
        this.log("FATAL " + String.valueOf(object));
    }

    @Override
    public void fatal(Object object, Throwable throwable) {
        this.logWithStacktrace("FATAL " + String.valueOf(object), throwable);
    }

    @Override
    public void debug(Object object) {
        if (this.isDebugEnabled()) {
            this.log("DEBUG " + String.valueOf(object));
        }
    }

    @Override
    public void debug(Object object, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.logWithStacktrace("DEBUG " + String.valueOf(object), throwable);
        }
    }

    @Override
    public void trace(Object object) {
        if (this.logLevel == LogLevel.ALL) {
            this.log("TRACE " + String.valueOf(object));
        }
    }

    @Override
    public void trace(Object object, Throwable throwable) {
        if (this.logLevel == LogLevel.ALL) {
            this.logWithStacktrace("TRACE " + String.valueOf(object), throwable);
        }
    }

    @Override
    public void setLogdateigroesseInKB(int n) {
    }

    @Override
    public Modulnummer getModulnummer() {
        return Modulnummer.HAUPTLOG;
    }

    @Override
    public void registriereBugreport(IBugreport iBugreport) {
    }

    @Override
    public void showErrorMessageBox(Component component, String string, String string2) {
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logLevel == LogLevel.DEBUG || this.logLevel == LogLevel.ALL;
    }

    public void log(Object object) {
        System.out.println(object);
    }

    public void logWithStacktrace(Object object, Throwable throwable) {
        if (throwable != null) {
            this.log(throwable);
            throwable.printStackTrace();
        }
        this.log(object);
    }
}

