/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.guidesigner;

import com.formdev.flatlaf.FlatDarculaLaf;
import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatIntelliJLaf;
import com.formdev.flatlaf.FlatLightLaf;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.IGuiDesigner;
import de.planetensuche.konfigurator.impl.KonfiguratorFabrik;
import java.awt.Font;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public final class GuiDesigner
implements IGuiDesigner {
    private static final String DEFAULT_THEME = "Nimbus";
    private int schriftgroesseInPixel = 12;
    private Font fontNormal;
    private Font fontUeberschrift;
    private List<JComponent> komponentenUeberschriften;
    private List<JComponent> komponentenEinfach;

    public GuiDesigner() {
        this.setFont();
        this.setTheme();
        this.komponentenUeberschriften = new ArrayList<JComponent>();
        this.komponentenEinfach = new ArrayList<JComponent>();
    }

    private void setFont() {
        this.fontUeberschrift = new Font("Arial", 1, this.schriftgroesseInPixel + 1);
        this.fontNormal = new Font("Arial", 0, this.schriftgroesseInPixel);
    }

    private void setTheme() {
        try {
            String string = null;
            try {
                string = KonfiguratorFabrik.getKonfigurator().read().getGuiTheme();
            }
            catch (FileNotFoundException fileNotFoundException) {
                LoggingFactory.getLoggerForClass(this.getClass()).debug(fileNotFoundException);
            }
            if (string == null) {
                string = DEFAULT_THEME;
            }
            this.applyTheme(string);
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            LoggingFactory.getLoggerForClass(this.getClass()).error(exception);
        }
    }

    @Override
    public void applyTheme(String string) throws UnsupportedLookAndFeelException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (lookAndFeel != null && lookAndFeel.getName().equals(string)) {
            return;
        }
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : UIManager.getInstalledLookAndFeels()) {
            if (!string.equals(lookAndFeelInfo.getName())) continue;
            UIManager.setLookAndFeel(lookAndFeelInfo.getClassName());
            return;
        }
        if ("FlatLaf Light".equals(string)) {
            UIManager.setLookAndFeel(new FlatLightLaf());
        } else if ("FlatLaf Darcula".equals(string)) {
            UIManager.setLookAndFeel(new FlatDarculaLaf());
        } else if ("FlatLaf Dark".equals(string)) {
            UIManager.setLookAndFeel(new FlatDarkLaf());
        } else if ("FlatLaf IntelliJ".equals(string)) {
            UIManager.setLookAndFeel(new FlatIntelliJLaf());
        }
    }

    @Override
    public List<String> getAvailableThemeNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("FlatLaf Light");
        arrayList.add("FlatLaf Darcula");
        arrayList.add("FlatLaf Dark");
        arrayList.add("FlatLaf IntelliJ");
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : UIManager.getInstalledLookAndFeels()) {
            arrayList.add(lookAndFeelInfo.getName());
        }
        return arrayList;
    }

    @Override
    public void updateComponents() {
        for (JComponent jComponent : this.komponentenEinfach) {
            this.updateComponent(jComponent, false);
        }
        for (JComponent jComponent : this.komponentenUeberschriften) {
            this.updateComponent(jComponent, true);
        }
    }

    private void updateComponent(JComponent jComponent, boolean bl) {
        if (jComponent != null) {
            if (bl) {
                jComponent.setFont(this.fontUeberschrift);
            } else {
                jComponent.setFont(this.fontNormal);
            }
        }
    }

    @Override
    public void setComponents(List<JComponent> list, boolean bl) {
        if (bl) {
            this.komponentenUeberschriften = list;
        } else {
            this.komponentenEinfach = list;
        }
        this.updateComponents();
    }

    @Override
    public void addComponents(List<JComponent> list, boolean bl) {
        if (bl) {
            this.komponentenUeberschriften.addAll(list);
        } else {
            this.komponentenEinfach.addAll(list);
        }
        for (JComponent jComponent : list) {
            this.updateComponent(jComponent, bl);
        }
    }

    @Override
    public void addComponent(JComponent jComponent, boolean bl) {
        if (bl) {
            this.komponentenUeberschriften.add(jComponent);
        } else {
            this.komponentenEinfach.add(jComponent);
        }
        this.updateComponent(jComponent, bl);
    }

    @Override
    public void removeComponent(JComponent jComponent, boolean bl) {
        if (bl) {
            this.komponentenUeberschriften.remove(jComponent);
        } else {
            this.komponentenEinfach.remove(jComponent);
        }
    }

    @Override
    public void removeAllComponents(boolean bl) {
        if (bl) {
            this.komponentenUeberschriften.clear();
        } else {
            this.komponentenEinfach.clear();
        }
    }

    @Override
    public int getSchriftgroesse() {
        return this.schriftgroesseInPixel;
    }

    public void setSchriftgroesse(int n) {
        if (n <= 11 || n >= 17) {
            throw new IllegalArgumentException("bad letter size: " + n);
        }
        this.schriftgroesseInPixel = n;
        this.setFont();
    }

    @Override
    public Font getFont(boolean bl) {
        if (bl) {
            return this.fontUeberschrift;
        }
        return this.fontNormal;
    }
}

