/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.guidesigner.statusfenster;

import de.planetensuche.guidesigner.statusfenster.AsyncLoadingScreenCallback;
import de.planetensuche.guidesigner.statusfenster.Statusthread;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import javax.swing.JFrame;

public final class AsyncLoadingScreenCallbackExecutor {
    private final ISprachcontainer sprache = SprachcontainerFabrik.getSprachcontainer();
    private Statusthread statusthread;
    private Integer timeoutInMs;

    public AsyncLoadingScreenCallbackExecutor() {
    }

    public AsyncLoadingScreenCallbackExecutor(int n) {
        this.timeoutInMs = n;
    }

    public void execute(JFrame jFrame, AsyncLoadingScreenCallback asyncLoadingScreenCallback) {
        Executor executor = new Executor(jFrame, asyncLoadingScreenCallback);
        executor.start();
    }

    public void disableWaitingDialog() {
        if (this.statusthread != null) {
            this.statusthread.closeGUI();
        }
    }

    public void setProgress(int n) {
        if (this.statusthread != null) {
            this.statusthread.setProgress(n);
        }
    }

    private class Executor
    extends Thread {
        private final JFrame dialog;
        private final AsyncLoadingScreenCallback asyncLoadingScreenCallback;

        Executor(JFrame jFrame, AsyncLoadingScreenCallback asyncLoadingScreenCallback) {
            this.dialog = jFrame;
            this.asyncLoadingScreenCallback = asyncLoadingScreenCallback;
        }

        @Override
        public void run() {
            AsyncLoadingScreenCallbackExecutor.this.statusthread = AsyncLoadingScreenCallbackExecutor.this.timeoutInMs != null ? new Statusthread(this.dialog, AsyncLoadingScreenCallbackExecutor.this.sprache.getString("bitte_warten"), AsyncLoadingScreenCallbackExecutor.this.timeoutInMs) : new Statusthread(this.dialog, AsyncLoadingScreenCallbackExecutor.this.sprache.getString("bitte_warten"));
            AsyncLoadingScreenCallbackExecutor.this.statusthread.start();
            try {
                this.asyncLoadingScreenCallback.run();
            }
            catch (Exception exception) {
                AsyncLoadingScreenCallbackExecutor.this.statusthread.closeGUI();
                throw exception;
            }
            AsyncLoadingScreenCallbackExecutor.this.statusthread.closeGUI();
        }
    }
}

