/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.konfigurator.impl;

import com.google.common.io.Files;
import de.planetensuche.konfigurator.api.IFinsternisseKonfiguration;
import de.planetensuche.konfigurator.api.IMindestKonfiguration;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.GregorianCalendar;
import java.util.List;

public final class FinsternisseKonfiguration
implements IMindestKonfiguration,
IFinsternisseKonfiguration {
    private static final String NOT_SUPPORTED_YET = "Not supported yet.";
    private final File finsternisseConfig;
    private final GregorianCalendar gregorianCalendar = new GregorianCalendar();
    private final boolean spracheDeutsch;
    private String naechsteMondfinsternis;
    private String naechsteSonnenfinsternis;

    public FinsternisseKonfiguration(File file, boolean bl) {
        this.spracheDeutsch = bl;
        this.finsternisseConfig = file;
    }

    @Override
    public void lesen() throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        List<String> list = Files.readLines(this.finsternisseConfig, Charset.forName("UTF-8"));
        for (String string : list) {
            String[] stringArray = string.split(":");
            String string2 = stringArray[1] + ":" + stringArray[2];
            if (!this.spracheDeutsch) {
                string2 = stringArray[3] + ":" + stringArray[4];
            }
            String string3 = stringArray[1].substring(0, 10);
            if ("m".equals(stringArray[0])) {
                if (bl || !this.vergleicheDatum(string3)) continue;
                this.naechsteMondfinsternis = string2;
                bl = true;
                continue;
            }
            if (bl2 || !this.vergleicheDatum(string3)) continue;
            this.naechsteSonnenfinsternis = string2;
            bl2 = true;
        }
    }

    private boolean vergleicheDatum(String string) {
        int n;
        int n2 = Integer.parseInt(string.substring(0, 2));
        int n3 = this.gregorianCalendar.get(5);
        int n4 = Integer.parseInt(string.substring(3, 5));
        int n5 = this.gregorianCalendar.get(2) + 1;
        int n6 = Integer.parseInt(string.substring(6, 10));
        if (n6 > (n = this.gregorianCalendar.get(1))) {
            return true;
        }
        if (n6 == n) {
            return this.monatOderTagGleichOderNachher(n4, n5, n2, n3);
        }
        return false;
    }

    private boolean monatOderTagGleichOderNachher(int n, int n2, int n3, int n4) {
        return n > n2 || n == n2 && n3 >= n4;
    }

    @Override
    public void schreiben() throws IOException {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }

    @Override
    public String getNaechsteMondfinsternis() {
        return this.naechsteMondfinsternis;
    }

    @Override
    public String getNaechsteSonnenfinsternis() {
        return this.naechsteSonnenfinsternis;
    }

    @Override
    public void ladeStandardKonfiguration() {
        throw new UnsupportedOperationException(NOT_SUPPORTED_YET);
    }
}

