/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.konfigurator.impl;

import de.planetensuche.core.Check;
import de.planetensuche.datamodel.api.KoordinatenFormat;
import de.planetensuche.datamodel.api.SternbildSprache;
import de.planetensuche.datamodel.impl.Koordinate;
import de.planetensuche.errorlogger.api.LogLevel;
import de.planetensuche.konfigurator.api.HauptkonfigurationDaten;
import de.planetensuche.konfigurator.api.IKonfigurator;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import de.planetensuche.konfigurator.api.KonfigurationKeys;
import de.planetensuche.konfigurator.api.Land;
import de.planetensuche.konfigurator.impl.Hauptkonfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public final class Konfigurator
implements IKonfigurator {
    public static final String DEFAULT_HOMEPAGE_HOSTNAME = "planetensuche.de";
    public static final int DEFAULT_PORT = 9443;
    private static final String DEFAULT_THEME = "Nimbus";
    private final String konfigDatei;

    private Konfigurator() {
        this("");
    }

    protected Konfigurator(String string) {
        this.konfigDatei = string;
    }

    @Override
    public KonfigurationDTO read() throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(this.konfigDatei);){
            Properties properties = new Properties();
            properties.loadFromXML(fileInputStream);
            KonfigurationDTO konfigurationDTO = new KonfigurationDTO();
            String string = properties.getProperty(KonfigurationKeys.BEOBACHTUNGSSTANDORT_KOORDINATE.name());
            Koordinate koordinate = new Koordinate(string);
            konfigurationDTO.setBeobachtungsortKoordinate(koordinate);
            konfigurationDTO.setBeobachtungsortLand(Land.valueOf(properties.getProperty(KonfigurationKeys.BEOBACHTUNGSSTANDORT_LAND.name())));
            konfigurationDTO.setBeobachtungsortStadt(properties.getProperty(KonfigurationKeys.BEOBACHTUNGSSTANDORT_STADT.name()));
            konfigurationDTO.setBildZoomAlgorithmus(properties.getProperty(KonfigurationKeys.BILD_ZOOM_ALGORITHMUS.name()));
            konfigurationDTO.setBrowserpfad(properties.getProperty(KonfigurationKeys.BROWSER_PFAD.name()));
            konfigurationDTO.setDatenbankName(properties.getProperty(KonfigurationKeys.DATENBANK_NAME.name()));
            konfigurationDTO.setDatenbankUpdateDatum(Long.parseLong(properties.getProperty(KonfigurationKeys.DATENBANK_UPDATE_DATUM.name())));
            konfigurationDTO.setErgebnisseRunden(Boolean.parseBoolean(properties.getProperty(KonfigurationKeys.ERGEBNISSE_RUNDEN.name())));
            konfigurationDTO.setFilmFensterZeigen(Boolean.parseBoolean(properties.getProperty(KonfigurationKeys.FILM_FENSTER_ZEIGEN.name())));
            konfigurationDTO.setIntroZeigen(Boolean.parseBoolean(properties.getProperty(KonfigurationKeys.INTRO_ZEIGEN.name())));
            String string2 = properties.getProperty(KonfigurationKeys.KOORDINATEN_FORMAT.name());
            konfigurationDTO.setKoordinatenFormat(KoordinatenFormat.valueOf(string2));
            konfigurationDTO.setLogFileInKb(Integer.parseInt(properties.getProperty(KonfigurationKeys.LOGFILE_GROESSE.name())));
            konfigurationDTO.setLogLevel(LogLevel.valueOf(properties.getProperty(KonfigurationKeys.LOG_LEVEL.name())));
            konfigurationDTO.setNachUpdatesSuchen(Boolean.parseBoolean(properties.getProperty(KonfigurationKeys.UPDATE_BENACHRICHTIGUNG.name())));
            String string3 = properties.getProperty(KonfigurationKeys.ANONYME_BENUTZERSTATISTIK.name());
            if (string3 == null) {
                konfigurationDTO.setAnonymeBenutzerstatistikSenden(true);
            } else {
                konfigurationDTO.setAnonymeBenutzerstatistikSenden(Boolean.parseBoolean(string3));
            }
            String string4 = properties.getProperty(KonfigurationKeys.SEND_WINDOW_ACCESS.name());
            if (string4 == null) {
                konfigurationDTO.setSendWindowAccess(true);
            } else {
                konfigurationDTO.setSendWindowAccess(Boolean.parseBoolean(string4));
            }
            konfigurationDTO.setSchriftgroesseInPixel(Integer.parseInt(properties.getProperty(KonfigurationKeys.SCHRIFTGROESSE_IN_PIXEL.name())));
            konfigurationDTO.setSprache(properties.getProperty(KonfigurationKeys.SPRACHE.name()));
            konfigurationDTO.setSternbildSprache(SternbildSprache.valueOf(properties.getProperty(KonfigurationKeys.STERNBILD_SPRACHE.name())));
            konfigurationDTO.setVersion(properties.getProperty(KonfigurationKeys.VERSION.name()));
            konfigurationDTO.setXmxInMB(Integer.parseInt(properties.getProperty(KonfigurationKeys.XMX_IN_MB.name())));
            konfigurationDTO.setZeitzoneFuerBeobachtungsort(properties.getProperty(KonfigurationKeys.ZEITZONE.name()));
            konfigurationDTO.setZuletztAktualisiertDatum(properties.getProperty(KonfigurationKeys.ZULETZT_AKTUALISIERT.name()));
            String string5 = properties.getProperty(KonfigurationKeys.UPDATE_URL.name());
            if (Check.isEmpty(string5) || string5.contains("marfir.de")) {
                konfigurationDTO.setUpdateUrl("https://www.planetensuche.de/ps/update.txt");
            } else {
                konfigurationDTO.setUpdateUrl(string5);
            }
            String string6 = properties.getProperty(KonfigurationKeys.HOMEPAGE_HOSTNAME.name());
            if (Check.isEmpty(string6)) {
                konfigurationDTO.setHomepageHostname(DEFAULT_HOMEPAGE_HOSTNAME);
            } else {
                konfigurationDTO.setHomepageHostname(string6);
            }
            String string7 = properties.getProperty(KonfigurationKeys.PORT.name());
            if (string7 != null) {
                konfigurationDTO.setPort(Integer.parseInt(string7));
            } else {
                konfigurationDTO.setPort(9443);
            }
            String string8 = properties.getProperty(KonfigurationKeys.VOTING_ACTIVE.name());
            if (string8 == null || string8.isEmpty()) {
                konfigurationDTO.setVotingActive(true);
            } else {
                konfigurationDTO.setVotingActive(Boolean.parseBoolean(string8));
            }
            konfigurationDTO.setGuiTheme(properties.getProperty(KonfigurationKeys.GUI_THEME.name()));
            if (konfigurationDTO.getGuiTheme() == null) {
                konfigurationDTO.setGuiTheme(DEFAULT_THEME);
            }
            String string9 = properties.getProperty(KonfigurationKeys.USE_FLICKR.name(), "false");
            konfigurationDTO.setUseFlickr(Boolean.parseBoolean(string9));
            konfigurationDTO.setPhtUsername(properties.getProperty(KonfigurationKeys.PHT_USERNAME.name(), ""));
            KonfigurationDTO konfigurationDTO2 = konfigurationDTO;
            return konfigurationDTO2;
        }
    }

    @Override
    public void write(KonfigurationDTO konfigurationDTO) throws IOException {
        Properties properties = new Properties();
        properties.put(KonfigurationKeys.BEOBACHTUNGSSTANDORT_KOORDINATE.name(), konfigurationDTO.getBeobachtungsortKoordinate().toString());
        properties.put(KonfigurationKeys.BEOBACHTUNGSSTANDORT_LAND.name(), konfigurationDTO.getBeobachtungsortLand().name());
        properties.put(KonfigurationKeys.BEOBACHTUNGSSTANDORT_STADT.name(), konfigurationDTO.getBeobachtungsortStadt());
        properties.put(KonfigurationKeys.BILD_ZOOM_ALGORITHMUS.name(), konfigurationDTO.getBildZoomAlgorithmus());
        if (konfigurationDTO.getBrowserpfad() == null) {
            properties.put(KonfigurationKeys.BROWSER_PFAD.name(), "null");
        } else {
            properties.put(KonfigurationKeys.BROWSER_PFAD.name(), konfigurationDTO.getBrowserpfad());
        }
        properties.put(KonfigurationKeys.DATENBANK_NAME.name(), konfigurationDTO.getDatenbankName());
        properties.put(KonfigurationKeys.DATENBANK_UPDATE_DATUM.name(), Long.toString(konfigurationDTO.getDatenbankUpdateDatum()));
        properties.put(KonfigurationKeys.ERGEBNISSE_RUNDEN.name(), Boolean.toString(konfigurationDTO.isErgebnisseRunden()));
        properties.put(KonfigurationKeys.FILM_FENSTER_ZEIGEN.name(), Boolean.toString(konfigurationDTO.isFilmFensterZeigen()));
        properties.put(KonfigurationKeys.INTRO_ZEIGEN.name(), Boolean.toString(konfigurationDTO.isIntroZeigen()));
        properties.put(KonfigurationKeys.KOORDINATEN_FORMAT.name(), konfigurationDTO.getKoordinatenFormat().name());
        properties.put(KonfigurationKeys.LOGFILE_GROESSE.name(), Integer.toString(konfigurationDTO.getLogFileInKb()));
        properties.put(KonfigurationKeys.LOG_LEVEL.name(), konfigurationDTO.getLogLevel().name());
        properties.put(KonfigurationKeys.SCHRIFTGROESSE_IN_PIXEL.name(), Integer.toString(konfigurationDTO.getSchriftgroesseInPixel()));
        properties.put(KonfigurationKeys.SPRACHE.name(), konfigurationDTO.getSprache());
        properties.put(KonfigurationKeys.STERNBILD_SPRACHE.name(), konfigurationDTO.getSternbildSprache().name());
        properties.put(KonfigurationKeys.UPDATE_BENACHRICHTIGUNG.name(), Boolean.toString(konfigurationDTO.isNachUpdatesSuchen()));
        properties.put(KonfigurationKeys.ANONYME_BENUTZERSTATISTIK.name(), Boolean.toString(konfigurationDTO.isAnonymeBenutzerstatistikSenden()));
        properties.put(KonfigurationKeys.SEND_WINDOW_ACCESS.name(), Boolean.toString(konfigurationDTO.isSendWindowAccess()));
        if (konfigurationDTO.getVersion() == null) {
            throw new IllegalStateException("property Planetensuche version is null");
        }
        properties.put(KonfigurationKeys.VERSION.name(), konfigurationDTO.getVersion());
        properties.put(KonfigurationKeys.XMX_IN_MB.name(), Integer.toString(konfigurationDTO.getXmxInMB()));
        properties.put(KonfigurationKeys.ZEITZONE.name(), konfigurationDTO.getZeitzoneFuerBeobachtungsort());
        properties.put(KonfigurationKeys.ZULETZT_AKTUALISIERT.name(), konfigurationDTO.getZuletztAktualisiertDatum());
        properties.put(KonfigurationKeys.UPDATE_URL.name(), konfigurationDTO.getUpdateUrl());
        if (Check.isEmpty(konfigurationDTO.getHomepageHostname())) {
            konfigurationDTO.setHomepageHostname(DEFAULT_HOMEPAGE_HOSTNAME);
        }
        properties.put(KonfigurationKeys.HOMEPAGE_HOSTNAME.name(), konfigurationDTO.getHomepageHostname());
        if (konfigurationDTO.getPort() == 0) {
            konfigurationDTO.setPort(9443);
        }
        properties.put(KonfigurationKeys.PORT.name(), Integer.toString(konfigurationDTO.getPort()));
        properties.put(KonfigurationKeys.VOTING_ACTIVE.name(), "" + konfigurationDTO.isVotingActive());
        if (konfigurationDTO.getGuiTheme() == null) {
            properties.put(KonfigurationKeys.GUI_THEME.name(), DEFAULT_THEME);
        } else {
            properties.put(KonfigurationKeys.GUI_THEME.name(), konfigurationDTO.getGuiTheme());
        }
        properties.put(KonfigurationKeys.USE_FLICKR.name(), "" + konfigurationDTO.isUseFlickr());
        if (konfigurationDTO.getPhtUsername() == null) {
            konfigurationDTO.setPhtUsername("");
        }
        properties.put(KonfigurationKeys.PHT_USERNAME.name(), konfigurationDTO.getPhtUsername());
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.konfigDatei);){
            properties.storeToXML(fileOutputStream, "Planetensuche Konfigurationsdatei");
        }
    }

    @Override
    public boolean updateConfigurationFromOldConfFile() throws IOException {
        Hauptkonfiguration hauptkonfiguration = new Hauptkonfiguration();
        boolean bl = hauptkonfiguration.existsPlanetensucheNew();
        if (bl) {
            hauptkonfiguration.aktualisiereKonfigDateiMitNewDatei();
        }
        hauptkonfiguration.lesen();
        HauptkonfigurationDaten hauptkonfigurationDaten = hauptkonfiguration.getDaten();
        boolean bl2 = new File(this.konfigDatei).exists();
        if (bl2) {
            if (bl) {
                KonfigurationDTO konfigurationDTO = this.read();
                konfigurationDTO.setVersion(hauptkonfigurationDaten.getVersion());
                konfigurationDTO.setZuletztAktualisiertDatum(hauptkonfigurationDaten.getZuletztAktualisiert());
                this.write(konfigurationDTO);
            }
        } else {
            KonfigurationDTO konfigurationDTO = this.getDefault();
            konfigurationDTO.setVersion(hauptkonfigurationDaten.getVersion());
            konfigurationDTO.setZuletztAktualisiertDatum(hauptkonfigurationDaten.getZuletztAktualisiert());
            this.write(konfigurationDTO);
        }
        return bl;
    }

    @Override
    public KonfigurationDTO getDefault() {
        KonfigurationDTO konfigurationDTO = new KonfigurationDTO();
        konfigurationDTO.setBeobachtungsortKoordinate(new Koordinate(12, 22, 26.0));
        konfigurationDTO.setBeobachtungsortLand(Land.DEUTSCHLAND);
        konfigurationDTO.setBeobachtungsortStadt("Leipzig");
        konfigurationDTO.setBildZoomAlgorithmus("standard");
        konfigurationDTO.setBrowserpfad(null);
        konfigurationDTO.setDatenbankName("database");
        konfigurationDTO.setDatenbankUpdateDatum(System.currentTimeMillis());
        konfigurationDTO.setErgebnisseRunden(false);
        konfigurationDTO.setFilmFensterZeigen(true);
        konfigurationDTO.setIntroZeigen(true);
        konfigurationDTO.setKoordinatenFormat(KoordinatenFormat.STUNDEN_DEZIMAL);
        konfigurationDTO.setLogFileInKb(512);
        konfigurationDTO.setLogLevel(LogLevel.INFO);
        konfigurationDTO.setNachUpdatesSuchen(true);
        konfigurationDTO.setAnonymeBenutzerstatistikSenden(true);
        konfigurationDTO.setSendWindowAccess(true);
        konfigurationDTO.setSchriftgroesseInPixel(12);
        konfigurationDTO.setSprache("deutsch");
        konfigurationDTO.setSternbildSprache(SternbildSprache.LATEINISCH);
        konfigurationDTO.setXmxInMB(2560);
        konfigurationDTO.setZeitzoneFuerBeobachtungsort("GMT +01:00h");
        konfigurationDTO.setZuletztAktualisiertDatum("20.12.2010");
        konfigurationDTO.setUpdateUrl("https://www.planetensuche.de/ps/update.txt");
        konfigurationDTO.setHomepageHostname(DEFAULT_HOMEPAGE_HOSTNAME);
        konfigurationDTO.setPort(9443);
        konfigurationDTO.setVotingActive(true);
        konfigurationDTO.setGuiTheme(DEFAULT_THEME);
        konfigurationDTO.setUseFlickr(false);
        konfigurationDTO.setPhtUsername("");
        return konfigurationDTO;
    }
}

