/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.sprachcontainer.impl;

import com.google.common.io.Files;
import de.planetensuche.core.Check;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.konfigurator.api.IKonfigurator;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import de.planetensuche.konfigurator.impl.KonfiguratorFabrik;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.api.UnsupportedLanguageException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JOptionPane;

public final class Sprachcontainer
implements ISprachcontainer {
    public static final String PATH = new File("").getAbsolutePath() + "/sprachen";
    private Map<String, String> woerterListe;
    private String aktuellVerwendeteSprache;
    private List<String> verfuegbareSprachen;
    private Map<String, String> german2English;
    private Map<String, String> english2German;
    private int anzahlPskeys;
    private boolean roundNumbers;

    @Override
    public String getUebersetzungFuerAktuelleSprache(String string) {
        if (this.isAktuelleSpracheDeutsch()) {
            String string2 = this.english2German.get(string);
            if (string2 == null) {
                return string;
            }
            return string2;
        }
        String string3 = this.german2English.get(string);
        if (string3 == null) {
            return string;
        }
        return string3;
    }

    @Override
    public String getUebersetzungEnglischInDeutsch(String string) {
        return this.english2German.get(string);
    }

    @Override
    public void reload() throws IOException {
        this.init();
        this.readSupportedLanguages();
        this.readConfiguredLanguage();
        this.readDictionaryForConfiguredLanguage();
        this.readTranslatorDictionary();
        this.readConfiguredNumberRounding();
    }

    @Override
    public String toLocalisedDate(String string) {
        if (string == null || string.isEmpty()) {
            return "";
        }
        if (string.startsWith("00.00.")) {
            String string2 = string.substring(6);
            return string2;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
            simpleDateFormat.applyPattern("dd.MM.yyyy");
            Date date = simpleDateFormat.parse(string);
            if (this.isAktuelleSpracheDeutsch()) {
                DateFormat dateFormat = DateFormat.getDateInstance(2, Locale.GERMAN);
                return dateFormat.format(date);
            }
            DateFormat dateFormat = DateFormat.getDateInstance(2, Locale.UK);
            return dateFormat.format(date);
        }
        catch (ParseException parseException) {
            return string;
        }
    }

    private FileFilter createFileFilter() {
        return file -> {
            boolean bl = file.getName().toLowerCase().endsWith(".dat");
            boolean bl2 = !file.getName().startsWith("lizenz");
            boolean bl3 = !file.getName().startsWith("simbad");
            return file.isFile() && bl && bl2 && bl3;
        };
    }

    private void init() {
        this.anzahlPskeys = 0;
        this.verfuegbareSprachen = new ArrayList<String>(2);
        this.woerterListe = new HashMap<String, String>(2000);
        this.german2English = new HashMap<String, String>();
        this.english2German = new HashMap<String, String>();
    }

    protected Sprachcontainer() throws IOException {
        this.reload();
    }

    private void readConfiguredNumberRounding() throws IOException {
        IKonfigurator iKonfigurator = KonfiguratorFabrik.getKonfigurator();
        try {
            KonfigurationDTO konfigurationDTO = iKonfigurator.read();
            this.roundNumbers = konfigurationDTO.isErgebnisseRunden();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.roundNumbers = false;
        }
    }

    private void readConfiguredLanguage() throws IOException {
        IKonfigurator iKonfigurator = KonfiguratorFabrik.getKonfigurator();
        try {
            KonfigurationDTO konfigurationDTO = iKonfigurator.read();
            this.aktuellVerwendeteSprache = konfigurationDTO.getSprache();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.aktuellVerwendeteSprache = "deutsch";
        }
    }

    private void readSupportedLanguages() {
        File file = new File(PATH + File.separator);
        File[] fileArray = file.listFiles(this.createFileFilter());
        if (fileArray != null) {
            this.verfuegbareSprachen.clear();
            for (File file2 : fileArray) {
                String string = file2.getName();
                this.verfuegbareSprachen.add(string.substring(0, string.length() - 4));
            }
        }
    }

    private boolean readDictionaryForConfiguredLanguage() throws IOException {
        this.overrideDefaultLocale();
        HashMap<String, String> hashMap = new HashMap<String, String>(1000);
        int n = 0;
        List<String> list = this.readLinesFromMessageFile(this.aktuellVerwendeteSprache);
        for (String string : list) {
            int n2;
            if (string.startsWith("//") || string.length() <= 0 || (n2 = string.indexOf(61)) <= 0) continue;
            String string2 = string.substring(0, n2);
            Object object = string.substring(n2 + 1, string.length());
            if (string.indexOf("<br>") > -1) {
                object = "<html>" + ((String)object).trim() + "</html>";
            }
            hashMap.put(string2.trim(), ((String)object).trim());
            if (!string.startsWith("ps_")) continue;
            ++n;
        }
        this.woerterListe = hashMap;
        this.anzahlPskeys = n;
        return true;
    }

    private void overrideDefaultLocale() {
        if (this.isAktuelleSpracheDeutsch()) {
            Locale.setDefault(Locale.GERMAN);
        } else {
            Locale.setDefault(Locale.UK);
        }
    }

    private void readTranslatorDictionary() throws IOException {
        String[][] stringArray = new String[this.verfuegbareSprachen.size() + 1][this.anzahlPskeys];
        int n = 0;
        for (String string : this.verfuegbareSprachen) {
            int n2 = 0;
            List<String> list = this.readLinesFromMessageFile(string);
            for (String string2 : list) {
                if (!string2.startsWith("ps_")) continue;
                if (n == 0) {
                    stringArray[n][n2] = string2.substring(0, string2.indexOf("ps_"));
                }
                stringArray[n + 1][n2] = string2.substring(string2.indexOf(61) + 1, string2.length());
                ++n2;
            }
            ++n;
        }
        for (int i = 0; i < stringArray[1].length; ++i) {
            this.german2English.put(stringArray[1][i], stringArray[2][i]);
            this.english2German.put(stringArray[2][i], stringArray[1][i]);
        }
    }

    private List<String> readLinesFromMessageFile(String string) throws IOException {
        List<String> list = Files.readLines(new File(PATH + File.separator + string + ".dat"), Charset.forName("UTF-8"));
        return list;
    }

    @Override
    public void setAktuelleSprache(String string) throws IOException {
        if (!this.verfuegbareSprachen.contains(string)) {
            throw new UnsupportedLanguageException(string);
        }
        this.aktuellVerwendeteSprache = string;
        this.readDictionaryForConfiguredLanguage();
    }

    @Override
    public String getAktuelleSprache() {
        return this.aktuellVerwendeteSprache;
    }

    @Override
    public List<String> getUnterstuetzteSprachen() {
        return Collections.unmodifiableList(this.verfuegbareSprachen);
    }

    @Override
    public String getString(String string) {
        if (string.contains("{}") || string.contains("{0}")) {
            throw new UnsupportedOperationException("Method without args called, but message with key '" + string + "' contains a placeholder!");
        }
        String string2 = this.woerterListe.get(string);
        if (string2 != null) {
            return string2;
        }
        return "???missing translation for key '" + string + "'???";
    }

    @Override
    public String getString(String string, Object ... objectArray) {
        if (Check.isEmpty(objectArray) || Check.isEmpty(objectArray[0])) {
            throw new IllegalArgumentException("missing parameter(s) for i18n key " + string + "!");
        }
        String string2 = this.getString(string);
        Locale locale = this.getConfiguredLocale();
        MessageFormat messageFormat = new MessageFormat(string2, locale);
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] instanceof Double || objectArray[i] instanceof BigDecimal) {
                messageFormat.setFormatByArgumentIndex(i, this.createFractionDigitFormatter());
                continue;
            }
            if (objectArray[i] instanceof Integer || objectArray[i] instanceof Long) {
                messageFormat.setFormatByArgumentIndex(i, this.createNonFractionDigitFormatter());
                continue;
            }
            if (!(objectArray[i] instanceof Date) && !(objectArray[i] instanceof Timestamp) && !(objectArray[i] instanceof Instant)) continue;
            messageFormat.setFormatByArgumentIndex(i, this.createDateTimeFormatter());
        }
        Object[] objectArray2 = (Object[])objectArray.clone();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!objectArray[i].getClass().isAssignableFrom(Instant.class)) continue;
            objectArray2[i] = Date.from((Instant)objectArray[i]);
        }
        return messageFormat.format(objectArray2);
    }

    @Override
    public List<String> getPlanetensucheObjektKategorien() {
        ArrayList<String> arrayList = new ArrayList<String>(12);
        if (!this.woerterListe.isEmpty()) {
            arrayList.add(this.woerterListe.get("ps_asteroiden"));
            arrayList.add(this.woerterListe.get("ps_br_zwerge"));
            arrayList.add(this.woerterListe.get("ps_glx_neb"));
            arrayList.add(this.woerterListe.get("ps_glxhaufen"));
            arrayList.add(this.woerterListe.get("ps_kometen"));
            arrayList.add(this.woerterListe.get("ps_meteor"));
            arrayList.add(this.woerterListe.get("ps_monde"));
            arrayList.add(this.woerterListe.get("ps_planeten"));
            arrayList.add(this.woerterListe.get("ps_sonstiges"));
            arrayList.add(this.woerterListe.get("ps_sternbilder"));
            arrayList.add(this.woerterListe.get("ps_sterne"));
            arrayList.add(this.woerterListe.get("ps_sternhaufen"));
        }
        return arrayList;
    }

    @Override
    public double parseDouble(String string) {
        if (string.trim().isEmpty()) {
            JOptionPane.showMessageDialog(null, this.getString("um_f2"), this.getString("db_f56_titel"), 0);
            return 0.0;
        }
        try {
            String string2 = string;
            if (this.isAktuelleSpracheDeutsch()) {
                if (string.indexOf(44) > -1 && string.indexOf(46) > -1) {
                    string2 = string2.replaceAll("\\.", "");
                }
                string2 = string2.replaceAll(",", ".");
            } else {
                string2 = string.replaceAll(",", "");
            }
            string2 = string2.trim();
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(null, this.getString("fs_f1"), this.getString("ungueltige_eingabe"), 0);
            return 0.0;
        }
    }

    @Override
    public String toLocalisedInt(Integer n) {
        if (n == null) {
            return "";
        }
        return this.createNonFractionDigitFormatter().format(n);
    }

    @Override
    public String toLocalisedDouble(Double d) {
        if (d == null) {
            return "";
        }
        return this.createFractionDigitFormatter().format(d);
    }

    @Override
    public String toLocalisedNumber(Number number) {
        if (number == null) {
            return "";
        }
        if (number instanceof Double || number instanceof BigDecimal) {
            return this.createFractionDigitFormatter().format(number);
        }
        return this.createNonFractionDigitFormatter().format(number);
    }

    private NumberFormat createFractionDigitFormatter() {
        NumberFormat numberFormat = this.createNumberFormatter();
        numberFormat.setMinimumFractionDigits(1);
        return numberFormat;
    }

    private NumberFormat createNonFractionDigitFormatter() {
        NumberFormat numberFormat = this.createNumberFormatter();
        numberFormat.setMinimumFractionDigits(0);
        return numberFormat;
    }

    private NumberFormat createNumberFormatter() {
        Locale locale = this.getConfiguredLocale();
        NumberFormat numberFormat = DecimalFormat.getInstance(locale);
        numberFormat.setRoundingMode(RoundingMode.HALF_UP);
        numberFormat.setMinimumFractionDigits(1);
        numberFormat.setMaximumFractionDigits(this.roundNumbers ? 4 : 12);
        numberFormat.setGroupingUsed(true);
        return numberFormat;
    }

    @Override
    public boolean isAktuelleSpracheDeutsch() {
        return "deutsch".equals(this.aktuellVerwendeteSprache);
    }

    @Override
    public String getLokalisiertenLizenzText() throws IOException {
        StringBuilder stringBuilder = new StringBuilder(100);
        String string = this.isAktuelleSpracheDeutsch() ? "lizenz_de.dat" : "lizenz_en.dat";
        List<String> list = Files.readLines(new File(PATH + File.separator + string), Charset.forName("UTF-8"));
        for (String string2 : list) {
            stringBuilder.append(string2);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public String getLinkZumHandbuch() {
        String string = this.isAktuelleSpracheDeutsch() ? "de" : "en";
        return "handbuch" + File.separator + string + File.separator + "index.html";
    }

    @Override
    public String getDebugInfo() {
        return "Insgesamt " + this.woerterListe.size() + " Keys fuer die Sprache '" + this.aktuellVerwendeteSprache + "' geladen!";
    }

    @Override
    public String getHtmlString(String string) {
        return "<html>" + this.getString(string) + "</html>";
    }

    void addEntry(String string, String string2) {
        this.woerterListe.put(string, string2);
    }

    @Override
    public String toLocalisedDate(Date date, int n) {
        if (date == null) {
            return "";
        }
        Locale locale = this.getConfiguredLocale();
        DateFormat dateFormat = DateFormat.getDateInstance(n, locale);
        return dateFormat.format(date);
    }

    @Override
    public String toLocalisedDateTime(Timestamp timestamp) {
        if (timestamp == null) {
            return "";
        }
        Locale locale = this.getConfiguredLocale();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.MEDIUM).withLocale(locale);
        return dateTimeFormatter.format(timestamp.toLocalDateTime());
    }

    private ZoneId getZoneIdFromConfiguredLocale() {
        ZoneId zoneId;
        try {
            KonfigurationDTO konfigurationDTO = KonfiguratorFabrik.getKonfigurator().read();
            if (konfigurationDTO != null && Check.isFilled(konfigurationDTO.getZeitzoneFuerBeobachtungsort())) {
                String string = konfigurationDTO.getZeitzoneFuerBeobachtungsort();
                String string2 = string.replace(" ", "").replace("h", "").trim();
                zoneId = ZoneId.of(string2);
            } else {
                zoneId = ZoneId.systemDefault();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            LoggingFactory.getLoggerForClass(this.getClass()).debug(fileNotFoundException);
            zoneId = ZoneId.systemDefault();
        }
        catch (IOException iOException) {
            LoggingFactory.getLoggerForClass(this.getClass()).error(iOException);
            zoneId = ZoneId.systemDefault();
        }
        return zoneId;
    }

    private DateFormat createDateTimeFormatter() {
        Locale locale = this.getConfiguredLocale();
        return DateFormat.getDateTimeInstance(2, 2, locale);
    }

    @Override
    public Locale getConfiguredLocale() {
        return this.isAktuelleSpracheDeutsch() ? Locale.GERMAN : Locale.UK;
    }

    @Override
    public void setRoundNumbers(boolean bl) {
        this.roundNumbers = bl;
    }
}

