/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.updater.jre;

import de.planetensuche.core.Check;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.updater.IUpdateDialog;
import de.planetensuche.updater.jre.JreUpdateDto;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class JreDownloadService {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(JreDownloadService.class);
    private URL updateIndexDateiURL;
    private String baseUrl;
    private final IUpdateDialog gui;
    private final ISprachcontainer i18n;

    public JreDownloadService(KonfigurationDTO konfigurationDTO, IUpdateDialog iUpdateDialog, ISprachcontainer iSprachcontainer) {
        this.gui = iUpdateDialog;
        this.i18n = iSprachcontainer;
        try {
            this.baseUrl = "https://www." + konfigurationDTO.getHomepageHostname() + "/jre/";
            this.updateIndexDateiURL = new URL(this.baseUrl + "update.txt");
        }
        catch (MalformedURLException malformedURLException) {
            LOGGER.error(malformedURLException);
            throw new IllegalArgumentException(malformedURLException);
        }
    }

    public File downloadSource(JreUpdateDto jreUpdateDto) throws MalformedURLException, IOException {
        File file = new File("temp" + File.separator + jreUpdateDto.getFileName());
        URL uRL = new URL(this.baseUrl + jreUpdateDto.getFileName());
        long l = Math.round(jreUpdateDto.getSizeInMb() * 1024.0 * 1024.0);
        try (InputStream inputStream = uRL.openStream();
             FileOutputStream fileOutputStream = new FileOutputStream(file);){
            int n;
            byte[] byArray = new byte[65535];
            long l2 = 0L;
            int n2 = 0;
            int n3 = 0;
            while ((n = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
                ++n2;
                int n4 = (int)Math.round((double)(l2 += (long)n) * 100.0 / (double)l);
                if (n3 >= n4) continue;
                n3 = n4;
                LOGGER.info(n3 + "% downloaded...");
                this.gui.appendOutput(this.i18n.getString("up_m32", n3));
            }
        }
        LOGGER.info("jre update download complete");
        this.gui.appendOutput(this.i18n.getString("up_m21"));
        return file;
    }

    public List<JreUpdateDto> findInstallableUpdates() throws IOException {
        ArrayList<JreUpdateDto> arrayList = new ArrayList<JreUpdateDto>();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.updateIndexDateiURL.openStream()));){
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray;
                if (!Check.isFilled(string) || (stringArray = string.split(";")).length < 4) continue;
                JreUpdateDto jreUpdateDto = new JreUpdateDto();
                jreUpdateDto.setJreMajorVersion(Integer.parseInt(stringArray[0]));
                jreUpdateDto.setJreMinorVersion(Integer.parseInt(stringArray[1]));
                jreUpdateDto.setRequiredOperatingSystem(stringArray[2]);
                jreUpdateDto.setFileName(stringArray[3]);
                jreUpdateDto.setSizeInMb(Double.parseDouble(stringArray[4]));
                arrayList.add(jreUpdateDto);
            }
        }
        return arrayList;
    }
}

