/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.bugreport.main;

import com.google.common.io.Files;
import de.planetensuche.bugreport.main.AktualisierenThread;
import de.planetensuche.bugreport.main.DebuggingInformation;
import de.planetensuche.bugreport.main.IStart;
import de.planetensuche.bugreport.main.SendenThread;
import de.planetensuche.bugreport.main.VoransichtDialog;
import de.planetensuche.errorlogger.api.IBugreport;
import de.planetensuche.guidesigner.components.Basisdialog;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import de.planetensuche.konfigurator.impl.KonfiguratorFabrik;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public final class BugreportDialog
extends Basisdialog
implements IStart,
IBugreport {
    private final ISprachcontainer sprache = SprachcontainerFabrik.getSprachcontainer();
    private File semaphor;
    private int zeilenBereitsGelesen;
    private JTextArea logfileOutputs;
    private final KonfigurationDTO globaleKonfig;
    private JButton abbrechenButton;
    private JTextField emailTextField;
    private JTextArea fehlerbeschreibungTextField;
    private JButton infoButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JScrollPane jScrollPane1;
    private JTextField nameTextField;
    private JButton sendenButton;
    private JButton voransichtButton;

    public BugreportDialog(KonfigurationDTO konfigurationDTO) {
        super(BasisdialogId.BUGREPORT);
        this.globaleKonfig = konfigurationDTO;
    }

    @Override
    public void zeigeSendenErfolgreich() {
        JOptionPane.showMessageDialog(this, this.i18n.getString("bug_m12"), this.i18n.getString("bug_m12_titel"), 1);
    }

    private void beschrifteGUI() {
        this.setTitle("Planetensuche Bug Report");
        this.jLabel1.setText(this.sprache.getString("bug_gui1"));
        this.jLabel2.setText(this.sprache.getString("bug_gui2"));
        this.jLabel3.setText(this.sprache.getString("bug_gui3"));
        this.jLabel4.setText(this.sprache.getString("bug_gui4"));
        this.jLabel5.setText(this.sprache.getString("bug_gui9"));
        this.voransichtButton.setText(this.sprache.getString("bug_gui5"));
        this.sendenButton.setText(this.sprache.getString("bug_gui6"));
        this.infoButton.setText(this.sprache.getString("bug_gui7"));
        this.abbrechenButton.setText(this.sprache.getString("bug_gui8"));
    }

    private void starteArbeit(String string) {
        AktualisierenThread aktualisierenThread;
        Timer timer;
        if (string.endsWith(".log")) {
            this.leseLogDatei(new File(string));
        }
        this.logfileOutputs.append("\n\n");
        File file = new File("logs" + File.separator + "planetensuche.log");
        if (file.exists() && !this.leseLogDatei(file)) {
            this.beendeBugReport();
        }
        if (string.endsWith(".log")) {
            timer = new Timer();
            aktualisierenThread = new AktualisierenThread(this, string, this.sprache);
            timer.schedule((TimerTask)aktualisierenThread, 3000L, 3000L);
        }
        if (file.exists()) {
            timer = new Timer();
            aktualisierenThread = new AktualisierenThread(this, file.getAbsolutePath(), this.sprache);
            timer.schedule((TimerTask)aktualisierenThread, 3000L, 3000L);
        }
    }

    @Override
    public int getZeilenBereitsEingelesen() {
        return this.zeilenBereitsGelesen;
    }

    @Override
    public void setZeilenBereitsEingelesen(int n) {
        this.zeilenBereitsGelesen = n;
    }

    @Override
    public int getLines() {
        return this.logfileOutputs.getLineCount();
    }

    @Override
    public void appendText(JTextArea jTextArea) {
        this.logfileOutputs.append(jTextArea.getText());
    }

    private boolean sperreAktiv() {
        try {
            if (!this.semaphor.exists()) {
                return false;
            }
            String string = Files.readFirstLine(this.semaphor, Charset.forName("UTF-8"));
            return Boolean.valueOf(string);
        }
        catch (IOException iOException) {
            this.getLogger().error(iOException);
            return false;
        }
    }

    @Override
    public void entsperreSendenButton() {
        this.sendenButton.setEnabled(true);
    }

    @Override
    public void beendeBugReport() {
        this.getLogger().debug("beende bugreport...");
        this.dispose();
    }

    @Override
    public boolean sperreTool(boolean bl) {
        boolean bl2;
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.semaphor, false), Charset.forName("UTF-8"));
        try {
            outputStreamWriter.write(Boolean.toString(bl));
            bl2 = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStreamWriter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                this.getLogger().error("sperreTool(" + bl + ")", iOException);
                JOptionPane.showMessageDialog(this, this.sprache.getString("db_f16") + "\n" + iOException.toString(), this.sprache.getString("db_f4_titel"), 0);
                return false;
            }
        }
        outputStreamWriter.close();
        return bl2;
    }

    private boolean leseLogDatei(File file) {
        try {
            List<String> list = Files.readLines(file, Charset.forName("UTF-8"));
            int n = 0;
            for (String string : list) {
                this.logfileOutputs.append(string + "\n");
                ++n;
            }
            if (!"planetensuche.log".equals(file.getName())) {
                this.setZeilenBereitsEingelesen(n);
            }
            return true;
        }
        catch (IOException iOException) {
            this.getLogger().error("leseLogDatei(" + file.getName() + ")", iOException);
            JOptionPane.showMessageDialog(this, this.sprache.getString("bug_f1") + file.getName() + this.sprache.getString("bug_f2") + "\n" + this.sprache.getString("bug_f3"), this.sprache.getString("db_f4_titel"), 0);
            return false;
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.fehlerbeschreibungTextField = new JTextArea();
        this.jLabel4 = new JLabel();
        this.emailTextField = new JTextField();
        this.sendenButton = new JButton();
        this.infoButton = new JButton();
        this.abbrechenButton = new JButton();
        this.jLabel5 = new JLabel();
        this.nameTextField = new JTextField();
        this.voransichtButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Planetensuche Bug Report v1.2");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                BugreportDialog.this.formWindowClosing(windowEvent);
            }
        });
        this.getContentPane().setLayout(null);
        this.jLabel1.setText("<html>Es trat leider ein Fehler beim Verwenden von Planetensuche auf. Sie haben jetzt die Moeglichkeit<br>diesen Fehler zu melden, um dass dieser behoben werden kann.</html>");
        this.getContentPane().add(this.jLabel1);
        this.jLabel1.setBounds(10, 8, 570, 50);
        this.jLabel2.setText("Es werden nur die im folgenden aufgefuehrten Daten anonym und verschluesselt an den Autor versendet!");
        this.getContentPane().add(this.jLabel2);
        this.jLabel2.setBounds(10, 60, 570, 30);
        this.jLabel3.setText("Fehlerbeschreibung (geht an den Autor):");
        this.getContentPane().add(this.jLabel3);
        this.jLabel3.setBounds(10, 100, 380, 14);
        this.fehlerbeschreibungTextField.setColumns(20);
        this.fehlerbeschreibungTextField.setRows(5);
        this.fehlerbeschreibungTextField.setToolTipText("");
        this.fehlerbeschreibungTextField.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.fehlerbeschreibungTextField);
        this.getContentPane().add(this.jScrollPane1);
        this.jScrollPane1.setBounds(10, 120, 570, 120);
        this.jLabel4.setText("Ihre E-Mail-Adresse (falls Sie eine Antwort wuenschen):");
        this.getContentPane().add(this.jLabel4);
        this.jLabel4.setBounds(10, 250, 400, 14);
        this.emailTextField.setToolTipText("z. B. max.mustermann@web.de");
        this.getContentPane().add(this.emailTextField);
        this.emailTextField.setBounds(10, 270, 250, 24);
        this.sendenButton.setText("Senden");
        this.sendenButton.setToolTipText("");
        this.sendenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BugreportDialog.this.sendenButtonActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.sendenButton);
        this.sendenButton.setBounds(470, 250, 110, 24);
        this.infoButton.setText("Info");
        this.infoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BugreportDialog.this.infoButtonActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.infoButton);
        this.infoButton.setBounds(470, 310, 110, 24);
        this.abbrechenButton.setText("Abbrechen");
        this.abbrechenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BugreportDialog.this.abbrechenButtonActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.abbrechenButton);
        this.abbrechenButton.setBounds(470, 340, 110, 24);
        this.jLabel5.setText("Ihr Name (falls Sie eine Antwort wuenschen):");
        this.getContentPane().add(this.jLabel5);
        this.jLabel5.setBounds(10, 300, 300, 14);
        this.getContentPane().add(this.nameTextField);
        this.nameTextField.setBounds(10, 320, 250, 24);
        this.voransichtButton.setText("Voransicht");
        this.voransichtButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BugreportDialog.this.voransichtButtonActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.voransichtButton);
        this.voransichtButton.setBounds(470, 280, 110, 24);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((dimension.width - 603) / 2, (dimension.height - 402) / 2, 603, 402);
    }

    private void sendenButtonActionPerformed(ActionEvent actionEvent) {
        if (this.logfileOutputs.getText().length() < 20 || !this.logfileOutputs.getText().contains("Exception")) {
            JOptionPane.showMessageDialog(this, this.sprache.getString("bug_f4"), this.sprache.getString("bug_f4_titel"), 0);
        } else {
            this.emailTextField.setText(this.emailTextField.getText().trim());
            this.nameTextField.setText(this.nameTextField.getText().trim());
            boolean bl = true;
            if (this.emailTextField.getText().isEmpty()) {
                this.fehlerbeschreibungTextField.append("\n" + this.sprache.getString("bug_m4"));
            } else {
                if (this.nameTextField.getText().isEmpty()) {
                    JOptionPane.showMessageDialog(this, this.sprache.getString("bug_f9"), this.sprache.getString("bug_f9_titel"), 2);
                    return;
                }
                int n = this.emailTextField.getText().indexOf(64);
                if (n == -1) {
                    bl = false;
                }
                boolean bl2 = bl = bl && this.istInternetadresseImRichtigenFormat(n);
                if (bl) {
                    this.fehlerbeschreibungTextField.append("\n" + this.sprache.getString("bug_m5") + " '" + this.nameTextField.getText() + " (" + this.emailTextField.getText() + ")'");
                }
            }
            if (bl) {
                String string = this.createErrorReportText();
                SendenThread sendenThread = new SendenThread(this, this.emailTextField.getText(), string, this.sprache, this.globaleKonfig);
                try {
                    sendenThread.start();
                }
                catch (RuntimeException runtimeException) {
                    JOptionPane.showMessageDialog(this, this.sprache.getString("bug_f6") + "\n'" + runtimeException.getCause().getLocalizedMessage() + "'\n" + this.sprache.getString("bug_f7") + "\n" + this.sprache.getString("bug_f8"), this.sprache.getString("db_f4_titel"), 0);
                }
                this.sendenButton.setEnabled(false);
            } else {
                JOptionPane.showMessageDialog(this, this.sprache.getString("bug_f5"), this.sprache.getString("bug_f5_titel"), 0);
            }
        }
    }

    public String createErrorReportText() {
        return this.logfileOutputs.getText() + "\n\n" + this.fehlerbeschreibungTextField.getText() + "\n\n" + DebuggingInformation.getSystemEnvironment() + "\n\n" + DebuggingInformation.getKonfig(KonfiguratorFabrik.getKonfigurator());
    }

    private boolean istInternetadresseImRichtigenFormat(int n) {
        try {
            boolean bl;
            InetAddress inetAddress = InetAddress.getByName(this.emailTextField.getText().substring(n + 1, this.emailTextField.getText().length()));
            try (Socket socket = new Socket(inetAddress, 80);){
                bl = socket.isConnected();
            }
            return bl;
        }
        catch (IOException iOException) {
            this.getLogger().error("k=" + n + ", email='" + this.emailTextField.getText() + "'", iOException);
            return false;
        }
    }

    private void formWindowClosing(WindowEvent windowEvent) {
        this.sperreTool(false);
        this.beendeBugReport();
    }

    private void abbrechenButtonActionPerformed(ActionEvent actionEvent) {
        this.sperreTool(false);
        this.beendeBugReport();
    }

    private void infoButtonActionPerformed(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this, this.sprache.getString("bug_m7"), this.sprache.getString("db_menu_25"), 1);
    }

    private void voransichtButtonActionPerformed(ActionEvent actionEvent) {
        VoransichtDialog voransichtDialog = new VoransichtDialog();
        voransichtDialog.setTitle(this.voransichtButton.getText());
        JScrollPane jScrollPane = new JScrollPane();
        JTextArea jTextArea = new JTextArea();
        jTextArea.setText(this.createErrorReportText());
        this.getGuiDesigner().addComponent(jTextArea, false);
        jScrollPane.add(jTextArea);
        jScrollPane.setViewportView(jTextArea);
        voransichtDialog.add(jScrollPane);
        voransichtDialog.setSize(600, 400);
        voransichtDialog.setVisible(true);
    }

    @Override
    public void open(int n) {
        this.initComponents();
        this.fehlerbeschreibungTextField.setToolTipText(null);
        this.logfileOutputs = new JTextArea();
        this.logfileOutputs.setEditable(false);
        try {
            this.semaphor = new File("looked");
            if (this.sperreAktiv()) {
                this.getLogger().warn("sperre aktiv!");
                this.beendeBugReport();
            } else {
                this.sperreTool(true);
            }
            this.zeilenBereitsGelesen = 0;
            this.getLogger().info(this.sprache.getString("bug_m1") + " " + new GregorianCalendar().getTime().toString() + " " + this.sprache.getString("bug_m2"));
            this.beschrifteGUI();
            this.getGuiDesigner().addComponent(this.fehlerbeschreibungTextField, false);
            for (int i = 0; i < this.getContentPane().getComponentCount(); ++i) {
                this.getGuiDesigner().addComponent((JComponent)this.getContentPane().getComponent(i), false);
            }
        }
        catch (Exception exception) {
            this.getLogger().error(exception);
            this.beendeBugReport();
        }
        String string = "logs" + File.separator;
        switch (n) {
            case 6: {
                string = string + "update.log";
                break;
            }
            case 7: {
                string = string + "install.log";
                break;
            }
            default: {
                this.getLogger().info("es wird nur das hauptlog eingelesen...");
            }
        }
        this.setVisible(true);
        this.starteArbeit(string);
    }
}

