/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.core;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;

public final class Check {
    private Check() {
    }

    public static boolean isFilled(Object object) {
        return !Check.isEmpty(object);
    }

    public static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof String) {
            return ((String)object).trim().isEmpty();
        }
        if (object instanceof Optional) {
            return Check.isOptionalEmpty(object);
        }
        if (object instanceof Collection) {
            return Check.isCollectionEmpty(object);
        }
        if (object instanceof Map) {
            return Check.isMapEmpty(object);
        }
        if (object instanceof Object[]) {
            return Check.isArrayEmpty(object);
        }
        return false;
    }

    private static boolean isMapEmpty(Object object) {
        Map map = (Map)object;
        if (map.isEmpty()) {
            return true;
        }
        for (Object k : map.keySet()) {
            if (!Check.isFilled(k)) continue;
            return false;
        }
        return true;
    }

    private static boolean isArrayEmpty(Object object) {
        Object[] objectArray = (Object[])object;
        if (objectArray.length == 0) {
            return true;
        }
        for (Object object2 : objectArray) {
            if (!Check.isFilled(object2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isCollectionEmpty(Object object) {
        Collection collection = (Collection)object;
        if (collection.isEmpty()) {
            return true;
        }
        for (Object e : collection) {
            if (!Check.isFilled(e)) continue;
            return false;
        }
        return true;
    }

    private static boolean isOptionalEmpty(Object object) {
        Optional optional = (Optional)object;
        if (!optional.isPresent()) {
            return true;
        }
        return Check.isEmpty(optional.get());
    }
}

