/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.core;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.commons.io.FileUtils;

public final class JavaVersionHelperUtil {
    private static final int MIN_JRE_MAJOR_VERSION = 21;
    private static final String JAVA_URL = "https://www.azul.com/downloads/?version=java-21-lts&package=jre-fx#zulu";
    private static final String JRE_CONFIG_FILE = "jre_updates" + File.separator + "last.cfg";

    private JavaVersionHelperUtil() {
    }

    public static boolean isLocalJreAvailable() {
        boolean bl = new File("jre21_linux_x64").exists() || new File("jre21_windows").exists() || new File("jre21_mac").exists();
        return new File(JRE_CONFIG_FILE).exists() || bl;
    }

    public static String getWinJrePath() throws IOException {
        Optional<String> optional = JavaVersionHelperUtil.getJreUpdatePath();
        if (optional.isPresent()) {
            return optional.get();
        }
        return "jre21_windows\\bin\\";
    }

    public static String getLinuxJrePath() throws IOException {
        Optional<String> optional = JavaVersionHelperUtil.getJreUpdatePath();
        if (optional.isPresent()) {
            return optional.get();
        }
        return "jre21_linux_x64/bin/";
    }

    public static String getMacOsJrePath() throws IOException {
        Optional<String> optional = JavaVersionHelperUtil.getJreUpdatePath();
        if (optional.isPresent()) {
            return optional.get();
        }
        return "jre21_mac/bin/";
    }

    private static Optional<String> getJreUpdatePath() throws IOException {
        File file = new File(JRE_CONFIG_FILE);
        if (file.exists()) {
            String string = FileUtils.readFileToString(file, StandardCharsets.UTF_8);
            String[] stringArray = string.trim().split("::");
            return Optional.of(stringArray[1]);
        }
        return Optional.empty();
    }

    public static void setNewDefaultJre(String string, String string2) throws IOException {
        Object object;
        String string3 = string;
        Optional<String> optional = JavaVersionHelperUtil.readVersionFromJrePath(string2);
        if (optional.isPresent()) {
            string3 = optional.get();
        }
        if (!((String)(object = string2)).endsWith(File.separator + "bin" + File.separator)) {
            if (!((String)object).endsWith(File.separator)) {
                object = (String)object + File.separator;
            }
            object = (String)object + "bin" + File.separator;
        }
        FileUtils.write(new File(JRE_CONFIG_FILE), (CharSequence)(string3 + "::" + (String)object), StandardCharsets.UTF_8, false);
    }

    public static String getCurrentJavaPath() throws IOException {
        Object object;
        if (!JavaVersionHelperUtil.isLocalJreAvailable()) {
            return "java";
        }
        Optional<String> optional = JavaVersionHelperUtil.getJreUpdatePath();
        if (optional.isPresent()) {
            object = optional.get();
        } else {
            String string = System.getProperty("os.name").toLowerCase();
            if (string.startsWith("windows")) {
                object = JavaVersionHelperUtil.getWinJrePath();
            } else if (string.startsWith("linux")) {
                object = JavaVersionHelperUtil.getLinuxJrePath();
            } else if (string.startsWith("mac")) {
                object = JavaVersionHelperUtil.getMacOsJrePath();
            } else {
                throw new UnsupportedOperationException("unable to detect local java path for OS '" + string + "'");
            }
        }
        if (!(((String)object).endsWith("/") || ((String)object).endsWith("\\") || ((String)object).endsWith(File.separator))) {
            object = (String)object + File.separator;
        }
        return (String)object + "java";
    }

    public static int getInstalledJavaMajorVersion() throws IOException {
        return JavaVersionHelperUtil.getInstalledMajorMinorVersion()[0];
    }

    public static String getInstalledJavaVersion() throws IOException {
        File file = new File("jre_updates" + File.separator + "last.cfg");
        if (file.exists()) {
            String string = FileUtils.readFileToString(file, StandardCharsets.UTF_8);
            String[] stringArray = string.split("::");
            return stringArray[0];
        }
        return Runtime.version().toString();
    }

    static Optional<String> readVersionFromJrePath(String string) throws IOException {
        Object object = string.endsWith(File.separator) ? string : string + File.separator;
        File file = new File((String)object + "release");
        if (file.exists()) {
            List<String> list = FileUtils.readLines(file, StandardCharsets.UTF_8);
            for (String string2 : list) {
                String[] stringArray;
                if (!string2.startsWith("JAVA_VERSION") || (stringArray = string2.split("=")).length <= 0) continue;
                return Optional.of(stringArray[1].replaceAll("\"", "").trim());
            }
        }
        return Optional.empty();
    }

    public static boolean isVersionCompatible(int n, String string) throws IOException {
        Integer[] integerArray = JavaVersionHelperUtil.getInstalledMajorMinorVersion(string);
        return JavaVersionHelperUtil.isVersionCompatible(n, integerArray);
    }

    public static boolean isVersionCompatible(int n) throws IOException {
        Integer[] integerArray = JavaVersionHelperUtil.getInstalledMajorMinorVersion();
        return JavaVersionHelperUtil.isVersionCompatible(n, integerArray);
    }

    public static boolean isVersionCompatible(int n, Integer[] integerArray) throws IOException {
        try {
            int n2 = integerArray[0];
            int n3 = integerArray[1];
            if (n2 == 1) {
                return n3 >= n;
            }
            if (n == 8) {
                return n2 == 9 || n2 == 8;
            }
            return n2 == n;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalStateException("Vergleich der Java Versionen fehlgeschlagen '" + n + "'", numberFormatException);
        }
    }

    public static boolean isVersionNewer(int n, int n2) throws IOException {
        Integer[] integerArray = JavaVersionHelperUtil.getInstalledMajorMinorVersion();
        int n3 = integerArray[0];
        int n4 = integerArray[1];
        if (n3 < n) {
            return true;
        }
        return n4 < n2;
    }

    public static boolean isRequiredVersionAlreadyInstalled() throws IOException {
        Integer[] integerArray = JavaVersionHelperUtil.getInstalledMajorMinorVersion();
        int n = integerArray[0];
        return n == 21;
    }

    public static boolean isVersionNewerAndUntested() throws IOException {
        Integer[] integerArray = JavaVersionHelperUtil.getInstalledMajorMinorVersion();
        int n = integerArray[0];
        return n > 21;
    }

    public static boolean isVersionNewerAndUntested(String string) throws IOException {
        Integer[] integerArray = JavaVersionHelperUtil.getInstalledMajorMinorVersion(string);
        int n = integerArray[0];
        return n > 21;
    }

    static Integer[] getInstalledMajorMinorVersion(String string) throws IOException {
        try {
            if (string.length() == 2) {
                return new Integer[]{Integer.parseInt(string), 0};
            }
            String[] stringArray = string.indexOf(".") > 0 ? string.split("\\.") : string.split("\\+");
            Integer[] integerArray = new Integer[2];
            integerArray[0] = Integer.parseInt(stringArray[0]);
            if (integerArray[0] == 1) {
                integerArray[0] = Integer.parseInt(stringArray[1]);
                integerArray[1] = 0;
                return integerArray;
            }
            integerArray[1] = stringArray[1].contains("-") ? Integer.valueOf(Integer.parseInt(stringArray[1].substring(0, stringArray[1].indexOf("-")))) : (stringArray.length > 2 && stringArray[2].contains("+") ? Integer.valueOf(Integer.parseInt(stringArray[2].substring(0, stringArray[2].indexOf("+")))) : (stringArray.length >= 3 ? Integer.valueOf(Integer.parseInt(stringArray[2])) : Integer.valueOf(Integer.parseInt(stringArray[1]))));
            return integerArray;
        }
        catch (IndexOutOfBoundsException | NullPointerException | NumberFormatException runtimeException) {
            throw new IllegalStateException("installierte Java Version nicht erkannt aus '" + string + "'", runtimeException);
        }
    }

    static Integer[] getInstalledMajorMinorVersion() throws IOException {
        return JavaVersionHelperUtil.getInstalledMajorMinorVersion(JavaVersionHelperUtil.getInstalledJavaVersion());
    }

    public static void showJavaUpdateRequiredMessage(JFrame jFrame, String string, String string2) throws IOException, URISyntaxException {
        JOptionPane.showMessageDialog(jFrame, string, string2, 0);
        if (Desktop.isDesktopSupported()) {
            URI uRI = new URL(JAVA_URL).toURI();
            Desktop.getDesktop().browse(uRI);
        }
    }
}

