/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datamodel.api;

import java.util.ArrayList;
import java.util.List;

public final class CatalogNames {
    public static final List<String> DOUBLE_STAR_SYSTEM_CHARS = List.of("A", "B", "AB");
    public static final List<String> MULTIPLE_STAR_SYSTEM_CHARS = List.of("C", "AC", "ABC", "BC", "AD", "BD", "CD", "D", "E", "F", "G", "H", "I", "J");
    public static final List<String> PYSICAL_DOUBLE_STAR_CATALOGS = List.of("CABS ", "CCABS ", "Koenigstuhl ", "LDS ", "SBC7 ", "SBC9 ", "TDSC ", "WNC ");
    public static final List<String> VISUAL_DOUBLE_STAR_CATALOGS = List.of("IDS ");
    public static final List<String> MIXED_DOUBLE_STAR_CATALOGS = List.of("WDS ", "STF ", "ADS ", "CCDM ", "CSI", "BDS ", "KR ", "LDS ");
    public static final List<String> CATALOGS_INCL_DOUBLE_STARS = List.of("HIP ", "HD ", "GJ ", "Gl ", "BD+", "BD-", "CD-", "HATS ", "2MASS ", "DMPP-", "KELT-", "Kepler-", "K2-", "NGTS-", "OGLE-", "LTT ", "ROXs ", "TOI-", "WASP-");
    public static final List<String> VARIABLE_STAR_CATALOGS = List.of("NSV ", "CSV ", "GCVS ", "GCVS2 ", "NSVS ", "HCV ", "AAVSO", "VSX ", "ZTF ", "ZTFJ", "ASASSN-V", "DHK");

    private CatalogNames() {
    }

    public static List<String> getAnyDoubleStarCatalog() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(PYSICAL_DOUBLE_STAR_CATALOGS);
        arrayList.addAll(VISUAL_DOUBLE_STAR_CATALOGS);
        arrayList.addAll(MIXED_DOUBLE_STAR_CATALOGS);
        return arrayList;
    }

    public static boolean isAnyDoubleStarCatalog(String string) {
        return CatalogNames.isStarInCatalogList(string, PYSICAL_DOUBLE_STAR_CATALOGS) || CatalogNames.isStarInCatalogList(string, VISUAL_DOUBLE_STAR_CATALOGS) || CatalogNames.isStarInCatalogList(string, MIXED_DOUBLE_STAR_CATALOGS);
    }

    public static boolean isMixedDoubleStarCatalog(String string) {
        return CatalogNames.isStarInCatalogList(string, MIXED_DOUBLE_STAR_CATALOGS);
    }

    public static boolean isVisualDoubleStarCatalog(String string) {
        return CatalogNames.isStarInCatalogList(string, VISUAL_DOUBLE_STAR_CATALOGS);
    }

    public static boolean isPysicalDoubleStarCatalog(String string) {
        return CatalogNames.isStarInCatalogList(string, PYSICAL_DOUBLE_STAR_CATALOGS);
    }

    public static boolean isStarCatalogInclDoubleStars(String string) {
        return CatalogNames.isStarInCatalogList(string, CATALOGS_INCL_DOUBLE_STARS);
    }

    public static boolean isVariableStarCatalog(String string) {
        return CatalogNames.isStarInCatalogList(string, VARIABLE_STAR_CATALOGS);
    }

    private static boolean isStarInCatalogList(String string, List<String> list) {
        for (String string2 : list) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDoubleComponent(String string) {
        for (String string2 : DOUBLE_STAR_SYSTEM_CHARS) {
            if (!string.endsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMultipleComponent(String string) {
        for (String string2 : MULTIPLE_STAR_SYSTEM_CHARS) {
            if (!string.endsWith(string2)) continue;
            return true;
        }
        return false;
    }
}

