/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datamodel.cleanarch.bo.api.types;

import de.planetensuche.datamodel.cleanarch.bo.api.types.InvalidMassException;

public final class MassType {
    private final Double mass;

    private MassType(Double d) {
        this.mass = d;
    }

    public static MassType parse(String string) throws InvalidMassException {
        if (string == null || string.isEmpty()) {
            return new MassType(null);
        }
        try {
            double d = Double.parseDouble(string);
            return MassType.parse(d);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidMassException("mass '" + string + "' is not from type double");
        }
    }

    public static MassType parse(Double d) throws InvalidMassException {
        if (d == null) {
            return new MassType(null);
        }
        if (d <= 0.0) {
            throw new InvalidMassException("mass must be positive");
        }
        return new MassType((double)d);
    }

    public double getMass() {
        return this.mass;
    }
}

