/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datamodel.formeln;

import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.api.ObjektKategorie;
import java.util.Optional;

public final class DensityCalculator {
    private DensityCalculator() {
    }

    public static Optional<Double> calcDensityInGcmCubic(IPlanetensucheObjekt iPlanetensucheObjekt) {
        if (!iPlanetensucheObjekt.isDurchmesserUnbekannt() && !iPlanetensucheObjekt.isMasseUnbekannt()) {
            double d;
            double d2;
            double d3;
            double d4;
            double d5 = DensityCalculator.getMasseInKg(iPlanetensucheObjekt.getCategory(), iPlanetensucheObjekt.getMasse());
            double d6 = DensityCalculator.getDurchmesserInMeter(iPlanetensucheObjekt.getCategory(), iPlanetensucheObjekt.getDurchmesser());
            if (d5 > 0.0 && d6 > 0.0 && (d4 = (d3 = d5 * 1000.0) / (d2 = 0.5235987755982988 * Math.pow(d = d6 * 100.0, 3.0))) > 0.0) {
                d4 = (double)Math.round(d4 * 10000.0) / 10000.0;
                return Optional.of(d4);
            }
        }
        return Optional.empty();
    }

    private static double getDurchmesserInMeter(ObjektKategorie objektKategorie, double d) {
        switch (objektKategorie) {
            case STERNE: {
                return d * 696392.0 * 2.0 * 1000.0;
            }
            case PLANETEN: 
            case BR_ZWERGE: {
                return d * 142984.0 * 1000.0;
            }
            case ASTEROIDEN: 
            case MONDE: {
                return d * 1000.0;
            }
        }
        return 0.0;
    }

    private static double getMasseInKg(ObjektKategorie objektKategorie, double d) {
        switch (objektKategorie) {
            case STERNE: {
                return d * 1.991E30;
            }
            case PLANETEN: 
            case BR_ZWERGE: {
                return d * 1.898E27;
            }
            case ASTEROIDEN: 
            case MONDE: {
                return d;
            }
        }
        return 0.0;
    }
}

