/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datamodel.formeln;

import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.formeln.IHabitateZone;
import de.planetensuche.datamodel.formeln.Konstanten;
import de.planetensuche.datamodel.formeln.SternleuchtkraftTemperatur;

public final class HabitateZoneKasting1993Simple
extends Konstanten
implements IHabitateZone {
    private double zoneInnen;
    private double zoneAussen;

    public void berechne(double d, double d2) {
        double d3 = 4.1900000000000003E-7 * Math.pow(d, 2.0) - 0.002139 * d + 1.296;
        double d4 = 6.19E-8 * Math.pow(d, 2.0) - 1.319E-4 * d + 0.2341;
        Double d5 = Math.pow(d2 / d3, 0.5);
        Double d6 = Math.pow(d2 / d4, 0.5);
        if (d5.isNaN()) {
            d5 = d6;
        }
        this.zoneInnen = d5;
        this.zoneAussen = d6;
    }

    @Override
    public boolean berechne(IPlanetensucheObjekt iPlanetensucheObjekt) {
        if (iPlanetensucheObjekt.isTemperaturUnbekannt() || iPlanetensucheObjekt.isDurchmesserUnbekannt()) {
            return false;
        }
        SternleuchtkraftTemperatur sternleuchtkraftTemperatur = new SternleuchtkraftTemperatur();
        double d = sternleuchtkraftTemperatur.getErgebnis(iPlanetensucheObjekt.getDurchmesser(), iPlanetensucheObjekt.getTemperatur());
        this.berechne(iPlanetensucheObjekt.getTemperatur(), d);
        return this.zoneInnen > 0.0 && this.zoneAussen > 0.0;
    }

    @Override
    public double getAeussereHZ() {
        return this.zoneAussen;
    }

    @Override
    public double getInnereHZ() {
        return this.zoneInnen;
    }
}

