/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datamodel.formeln;

import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.formeln.IHabitateZone;
import de.planetensuche.datamodel.formeln.Konstanten;
import de.planetensuche.datamodel.formeln.SternleuchtkraftTemperatur;
import java.util.List;

public final class HabitateZoneKasting1993Sptyp
extends Konstanten
implements IHabitateZone {
    private final List<Character> supportedSpTypes = List.of(Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('K'), Character.valueOf('M'));
    private final SternleuchtkraftTemperatur sternleuchtkraft = new SternleuchtkraftTemperatur();
    private double innereHZ;
    private double aeussereHZ;

    @Override
    public boolean berechne(IPlanetensucheObjekt iPlanetensucheObjekt) {
        if (iPlanetensucheObjekt.isTemperaturUnbekannt() || iPlanetensucheObjekt.isDurchmesserUnbekannt() || iPlanetensucheObjekt.isSpektralklasseUnbekannt()) {
            return false;
        }
        if (!this.supportedSpTypes.contains(Character.valueOf(iPlanetensucheObjekt.getSpektralklasse().charAt(0)))) {
            return false;
        }
        return this.berechne(iPlanetensucheObjekt.getTemperatur(), iPlanetensucheObjekt.getDurchmesser(), iPlanetensucheObjekt.getSpektralklasse().charAt(0));
    }

    public boolean berechne(double d, double d2, char c) {
        double d3 = this.sternleuchtkraft.getErgebnis(d2, d);
        double d4 = this.getKennzahlInnereHZ(c);
        double d5 = this.getKennzahlAeussereHZ(c);
        if (d4 == 0.0 || d5 == 0.0) {
            return false;
        }
        this.innereHZ = Math.pow(d3 / d4, 0.5);
        this.aeussereHZ = Math.pow(d3 / d5, 0.5);
        return this.innereHZ > 0.0 && this.aeussereHZ > 0.0;
    }

    @Override
    public double getAeussereHZ() {
        return this.aeussereHZ;
    }

    @Override
    public double getInnereHZ() {
        return this.innereHZ;
    }

    private double getKennzahlInnereHZ(char c) {
        switch (c) {
            case 'F': {
                return 1.9;
            }
            case 'G': {
                return 1.41;
            }
            case 'K': 
            case 'M': {
                return 1.05;
            }
        }
        return 0.0;
    }

    private double getKennzahlAeussereHZ(char c) {
        switch (c) {
            case 'F': {
                return 0.46;
            }
            case 'G': {
                return 0.36;
            }
            case 'K': 
            case 'M': {
                return 0.27;
            }
        }
        return 0.0;
    }
}

