/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datamodel.helfer;

import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datamodel.formeln.HabitateZoneKasting1993Simple;
import de.planetensuche.datamodel.formeln.HabitateZoneKasting1993Sptyp;
import de.planetensuche.datamodel.formeln.HabitateZoneKopparapu2013;
import de.planetensuche.datamodel.formeln.HabitateZoneSimple;
import de.planetensuche.datamodel.formeln.HabitateZoneSimpleStarMass;
import de.planetensuche.datamodel.formeln.IHabitateZone;
import java.util.ArrayList;
import java.util.List;

public final class HabitateZoneRechner {
    private final List<IHabitateZone> formeln = new ArrayList<IHabitateZone>();
    private double innereHZ;
    private double aussereHZ;

    public HabitateZoneRechner() {
        this.formeln.add(new HabitateZoneKopparapu2013());
        this.formeln.add(new HabitateZoneKasting1993Sptyp());
        this.formeln.add(new HabitateZoneKasting1993Simple());
        this.formeln.add(new HabitateZoneSimple());
        this.formeln.add(new HabitateZoneSimpleStarMass());
    }

    public boolean isPlanetInHz(double d, double d2, Double d3, Double d4) {
        if (d == 0.0 || d2 == 0.0) {
            return false;
        }
        if (d > d2) {
            throw new IllegalArgumentException("inner HZ " + d + " is greater then outer HZ " + d2);
        }
        if (d3 != null && d3 > 0.0) {
            return d < d3 && d2 > d3;
        }
        if (d4 != null && d4 > 0.0) {
            double d5 = this.calcDistanceInAUFromPeriod(d4);
            return d < d5 && d2 > d5;
        }
        return false;
    }

    double calcDistanceInAUFromPeriod(double d) {
        return Math.pow(Math.pow(d / 365.25, 2.0), 0.3333333333333333);
    }

    public boolean berechne(IPlanetensucheObjekt iPlanetensucheObjekt) {
        if (!ObjektKategorie.STERNE.equals((Object)iPlanetensucheObjekt.getCategory())) {
            return false;
        }
        for (IHabitateZone iHabitateZone : this.formeln) {
            if (!iHabitateZone.berechne(iPlanetensucheObjekt)) continue;
            this.innereHZ = iHabitateZone.getInnereHZ();
            this.aussereHZ = iHabitateZone.getAeussereHZ();
            if (!(this.innereHZ < this.aussereHZ) || !(this.innereHZ > 0.0)) continue;
            return true;
        }
        return false;
    }

    public double getInnereHZ() {
        return this.innereHZ;
    }

    public double getAussereHZ() {
        return this.aussereHZ;
    }
}

