/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datamodel.impl;

import de.planetensuche.core.Check;
import de.planetensuche.datamodel.api.CatalogNames;
import de.planetensuche.datamodel.api.GaiaNonSingleStar;
import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.api.IPsObjektService;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datamodel.api.StarObjectType;
import de.planetensuche.datamodel.impl.EntdeckermappingService;
import de.planetensuche.datamodel.impl.SternbildFinder;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class PsObjektService
implements IPsObjektService {
    private final boolean erzwungen;
    private SternbildFinder sternbildFinder;
    private final EntdeckermappingService entdeckermappingService;

    public PsObjektService(boolean bl) throws IOException {
        this.erzwungen = bl;
        this.entdeckermappingService = new EntdeckermappingService();
    }

    @Override
    public void starteBerechnung(IPlanetensucheObjekt iPlanetensucheObjekt) throws SQLException, IOException {
        boolean bl;
        if (iPlanetensucheObjekt == null) {
            throw new IllegalArgumentException("PsObjekt = NULL");
        }
        this.berechneSternbildFuerObjekt(iPlanetensucheObjekt);
        boolean bl2 = iPlanetensucheObjekt.getCategory().equals((Object)ObjektKategorie.PLANETEN);
        if (bl2) {
            this.korrigiereObjekttypVonPlaneten(iPlanetensucheObjekt);
            this.entdeckermappingService.ermittleUndSetzeEntdecker(iPlanetensucheObjekt);
        }
        boolean bl3 = iPlanetensucheObjekt.getCategory().equals((Object)ObjektKategorie.STERNE);
        boolean bl4 = iPlanetensucheObjekt.getCategory().equals((Object)ObjektKategorie.BR_ZWERGE);
        boolean bl5 = "Brauner Zwerg ohne Stern".equals(iPlanetensucheObjekt.getObjekttyp());
        boolean bl6 = iPlanetensucheObjekt.getCategory().equals((Object)ObjektKategorie.GALAXIE_NEBEL);
        boolean bl7 = iPlanetensucheObjekt.getCategory().equals((Object)ObjektKategorie.STERNHAUFEN);
        boolean bl8 = bl = bl6 && "Galaxie".equals(iPlanetensucheObjekt.getObjekttyp()) || bl7 && "Kugelsternhaufen".equals(iPlanetensucheObjekt.getObjekttyp());
        if (bl3 || bl || bl4 && bl5) {
            this.berechneAbsoluteHelligkeit(iPlanetensucheObjekt);
        }
        if (bl3) {
            this.pruefeObBraunerZwerg(iPlanetensucheObjekt);
            bl3 = iPlanetensucheObjekt.getCategory().equals((Object)ObjektKategorie.STERNE);
            bl4 = iPlanetensucheObjekt.getCategory().equals((Object)ObjektKategorie.BR_ZWERGE);
        }
        if (bl3) {
            this.setzteSternhaufenZugehoerigkeit(iPlanetensucheObjekt);
            this.berechneEntfernungInLy(iPlanetensucheObjekt);
            this.berechneSternDurchmesser(iPlanetensucheObjekt);
            this.korrigiereObjekttypDoppelOderMehrfachstern(iPlanetensucheObjekt);
            this.korrigiereObjekttypVeraenderlicherStern(iPlanetensucheObjekt);
        }
        if (bl4 || bl5) {
            this.entdeckermappingService.ermittleUndSetzeEntdecker(iPlanetensucheObjekt);
        }
        boolean bl9 = iPlanetensucheObjekt.getCategory().equals((Object)ObjektKategorie.MONDE);
        boolean bl10 = iPlanetensucheObjekt.getCategory().equals((Object)ObjektKategorie.ASTEROIDEN);
        boolean bl11 = iPlanetensucheObjekt.getCategory().equals((Object)ObjektKategorie.KOMETEN);
        if (bl2 || bl9 || bl10 || bl11 || bl4 && "Brauner Zwerg".equals(iPlanetensucheObjekt.getObjekttyp())) {
            this.berechneBahngeschwindigkeit(iPlanetensucheObjekt);
        }
    }

    private void berechneSternbildFuerObjekt(IPlanetensucheObjekt iPlanetensucheObjekt) throws IOException {
        boolean bl;
        boolean bl2 = !iPlanetensucheObjekt.isKoordinatenUnbekannt() && iPlanetensucheObjekt.isSternbildUnbekannt();
        boolean bl3 = bl = !iPlanetensucheObjekt.isKoordinatenUnbekannt() && iPlanetensucheObjekt.isGeaendert();
        if (bl2 || bl) {
            if (this.sternbildFinder == null) {
                this.sternbildFinder = new SternbildFinder();
            }
            String string = this.sternbildFinder.getSternbildCodeFuerKoordinate(iPlanetensucheObjekt.getRA(), iPlanetensucheObjekt.getDECL());
            iPlanetensucheObjekt.setSternbildCode(string);
        }
    }

    private void korrigiereObjekttypVonPlaneten(IPlanetensucheObjekt iPlanetensucheObjekt) throws SQLException {
        if (!iPlanetensucheObjekt.isMasseUnbekannt()) {
            if (iPlanetensucheObjekt.getMasse() >= 0.0314) {
                iPlanetensucheObjekt.setObjekttyp("Gasriese");
            } else if (iPlanetensucheObjekt.getMasse() <= 0.0034540000000000005) {
                iPlanetensucheObjekt.setObjekttyp("erdaehnlich");
            } else {
                iPlanetensucheObjekt.setObjekttyp("Planet");
            }
        }
    }

    private void berechneEntfernungInLy(IPlanetensucheObjekt iPlanetensucheObjekt) {
        if ((this.erzwungen || iPlanetensucheObjekt.isEntfernungUnbekannt()) && !iPlanetensucheObjekt.isAbsoluteHelligkeitUnbekannt() && !iPlanetensucheObjekt.isScheinbareHelligkeitUnbekannt()) {
            double d = 10.0 * Math.pow(10.0, 0.2 * (iPlanetensucheObjekt.getScheinbareHelligkeit() - iPlanetensucheObjekt.getAbsoluteHelligkeit()));
            BigDecimal bigDecimal = BigDecimal.valueOf(d *= 3.2616);
            bigDecimal = bigDecimal.setScale(2, RoundingMode.HALF_UP);
            iPlanetensucheObjekt.setEntfernung(bigDecimal.doubleValue());
        }
    }

    private void berechneAbsoluteHelligkeit(IPlanetensucheObjekt iPlanetensucheObjekt) {
        if ((this.erzwungen || iPlanetensucheObjekt.isAbsoluteHelligkeitUnbekannt()) && !iPlanetensucheObjekt.isEntfernungUnbekannt() && !iPlanetensucheObjekt.isScheinbareHelligkeitUnbekannt()) {
            double d = iPlanetensucheObjekt.getEntfernung() / 3.2616;
            double d2 = (5.0 * Math.log10(d) - 5.0 - iPlanetensucheObjekt.getScheinbareHelligkeit()) * -1.0;
            BigDecimal bigDecimal = BigDecimal.valueOf(d2);
            bigDecimal = bigDecimal.setScale(3, RoundingMode.HALF_UP);
            iPlanetensucheObjekt.setAbsoluteHelligkeit(bigDecimal.doubleValue());
        }
    }

    private void korrigiereObjekttypVeraenderlicherStern(IPlanetensucheObjekt iPlanetensucheObjekt) throws SQLException {
        if (!StarObjectType.SINGLE_STAR.getTypeName().equals(iPlanetensucheObjekt.getObjekttyp())) {
            return;
        }
        for (String string : iPlanetensucheObjekt.getObjektNamen()) {
            if (!CatalogNames.isVariableStarCatalog(string)) continue;
            iPlanetensucheObjekt.setObjekttyp(StarObjectType.VARIABLE_UNKNOWN_TYPE.getTypeName());
            return;
        }
    }

    private void korrigiereObjekttypDoppelOderMehrfachstern(IPlanetensucheObjekt iPlanetensucheObjekt) throws SQLException {
        if (!iPlanetensucheObjekt.isGaiaNonSingleUnbekannt()) {
            if (iPlanetensucheObjekt.getGaiaNonSingle().equals((Object)GaiaNonSingleStar.ASTROMETRIC_BINARY) || iPlanetensucheObjekt.getGaiaNonSingle().equals((Object)GaiaNonSingleStar.SPECTROSCOPIC_BINARY)) {
                iPlanetensucheObjekt.setObjekttyp(StarObjectType.DOUBLE_STAR_REAL.getTypeName());
                return;
            }
            if (iPlanetensucheObjekt.getGaiaNonSingle().equals((Object)GaiaNonSingleStar.ECLIPSING_BINARY)) {
                iPlanetensucheObjekt.setObjekttyp(StarObjectType.ECLIPSING_BINARY.getTypeName());
                return;
            }
        }
        if (StarObjectType.SINGLE_STAR.getTypeName().equals(iPlanetensucheObjekt.getObjekttyp()) || StarObjectType.DOUBLE_STAR_OPTICAL.getTypeName().equals(iPlanetensucheObjekt.getObjekttyp())) {
            this.adjustObjectTypeByGaiaData(iPlanetensucheObjekt);
        }
        if (StarObjectType.SINGLE_STAR.getTypeName().equals(iPlanetensucheObjekt.getObjekttyp()) || StarObjectType.DOUBLE_STAR_OPTICAL.getTypeName().equals(iPlanetensucheObjekt.getObjekttyp())) {
            this.adjustObjectTypeByDoubleStarCatalogName(iPlanetensucheObjekt);
        }
    }

    private void adjustObjectTypeByGaiaData(IPlanetensucheObjekt iPlanetensucheObjekt) throws SQLException {
        if (!iPlanetensucheObjekt.isGaiaRuweUnbekannt() && iPlanetensucheObjekt.getGaiaRuwe() > 1.4) {
            for (String string : iPlanetensucheObjekt.getObjektNamen()) {
                if (!CatalogNames.isMixedDoubleStarCatalog(string)) continue;
                if (CatalogNames.isMultipleComponent(string)) {
                    iPlanetensucheObjekt.setObjekttyp(StarObjectType.MULTI_STAR_SYSTEM.getTypeName());
                } else {
                    iPlanetensucheObjekt.setObjekttyp(StarObjectType.DOUBLE_STAR_REAL.getTypeName());
                }
                return;
            }
        }
        if (!iPlanetensucheObjekt.isGaiaAstroExNoiseSigUnbekannt() && iPlanetensucheObjekt.getGaiaAstroExNoiseSig() >= 2.0) {
            for (String string : iPlanetensucheObjekt.getObjektNamen()) {
                if (!CatalogNames.isMixedDoubleStarCatalog(string)) continue;
                if (CatalogNames.isMultipleComponent(string)) {
                    iPlanetensucheObjekt.setObjekttyp(StarObjectType.MULTI_STAR_SYSTEM.getTypeName());
                } else {
                    iPlanetensucheObjekt.setObjekttyp(StarObjectType.DOUBLE_STAR_REAL.getTypeName());
                }
                return;
            }
        }
    }

    private void adjustObjectTypeByDoubleStarCatalogName(IPlanetensucheObjekt iPlanetensucheObjekt) throws SQLException {
        for (String string : iPlanetensucheObjekt.getObjektNamen()) {
            if (CatalogNames.isPysicalDoubleStarCatalog(string)) {
                if (CatalogNames.isMultipleComponent(string)) {
                    iPlanetensucheObjekt.setObjekttyp(StarObjectType.MULTI_STAR_SYSTEM.getTypeName());
                } else {
                    iPlanetensucheObjekt.setObjekttyp(StarObjectType.DOUBLE_STAR_REAL.getTypeName());
                }
                return;
            }
            if (!CatalogNames.isStarCatalogInclDoubleStars(string)) continue;
            if (CatalogNames.isMultipleComponent(string)) {
                iPlanetensucheObjekt.setObjekttyp(StarObjectType.MULTI_STAR_SYSTEM.getTypeName());
                return;
            }
            if (!CatalogNames.isDoubleComponent(string)) continue;
            iPlanetensucheObjekt.setObjekttyp(StarObjectType.DOUBLE_STAR_REAL.getTypeName());
            return;
        }
        for (String string : iPlanetensucheObjekt.getObjektNamen()) {
            if (!CatalogNames.isVisualDoubleStarCatalog(string)) continue;
            iPlanetensucheObjekt.setObjekttyp(StarObjectType.DOUBLE_STAR_OPTICAL.getTypeName());
            return;
        }
    }

    private void berechneSternDurchmesser(IPlanetensucheObjekt iPlanetensucheObjekt) {
        boolean bl;
        boolean bl2 = this.erzwungen || iPlanetensucheObjekt.isDurchmesserUnbekannt();
        boolean bl3 = "V".equals(iPlanetensucheObjekt.getLeuchtkraftklasse()) || "VI".equals(iPlanetensucheObjekt.getLeuchtkraftklasse());
        boolean bl4 = bl = !iPlanetensucheObjekt.isTemperaturUnbekannt() && !iPlanetensucheObjekt.isAbsoluteHelligkeitUnbekannt();
        if (bl2 && bl3 && bl) {
            double d = iPlanetensucheObjekt.getTemperatur();
            double d2 = iPlanetensucheObjekt.getAbsoluteHelligkeit();
            double d3 = Math.sqrt(Math.pow(10.0, -0.4 * (d2 - 4.82))) / Math.pow(d / 5778.0, 2.0);
            BigDecimal bigDecimal = BigDecimal.valueOf(d3);
            bigDecimal = bigDecimal.setScale(3, RoundingMode.HALF_UP);
            iPlanetensucheObjekt.setDurchmesser(bigDecimal.doubleValue());
        }
    }

    private void berechneBahngeschwindigkeit(IPlanetensucheObjekt iPlanetensucheObjekt) {
        boolean bl;
        boolean bl2 = this.erzwungen || iPlanetensucheObjekt.isGeschwindigkeitUnbekannt();
        boolean bl3 = bl = !iPlanetensucheObjekt.isEntfernungUnbekannt() && !iPlanetensucheObjekt.isUmlaufszeitUnbekannt();
        if (bl2 && bl) {
            double d = iPlanetensucheObjekt.getCategory().equals((Object)ObjektKategorie.MONDE) ? iPlanetensucheObjekt.getEntfernung() : iPlanetensucheObjekt.getEntfernung() * 1.4959787E8;
            double d2 = iPlanetensucheObjekt.getUmlaufszeit() * 86400.0;
            double d3 = Math.PI * 2 * d / d2;
            BigDecimal bigDecimal = BigDecimal.valueOf(d3);
            bigDecimal = bigDecimal.setScale(2, RoundingMode.HALF_UP);
            iPlanetensucheObjekt.setGeschwindigkeit(bigDecimal.doubleValue());
        }
    }

    public static List<String> getWirdUmkreistVonNamen(int n, List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list == null) {
            return arrayList;
        }
        int n2 = n;
        Collections.sort(list);
        if (n2 == 0) {
            n2 = 400;
        }
        n2 /= 5;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (stringBuilder.length() >= n2) {
                arrayList.add(stringBuilder.toString());
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append(list.get(i));
            if (i >= list.size() - 1) continue;
            stringBuilder.append(", ");
        }
        arrayList.add(stringBuilder.toString());
        return arrayList;
    }

    public static List<String> getNamenFormatiert(int n, List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = n;
        if (n2 == 0) {
            n2 = 400;
        }
        n2 /= 5;
        Object object = "";
        for (int i = 0; i < list.size(); ++i) {
            if (((String)object).length() >= n2) {
                arrayList.add((String)object);
                object = "";
            }
            object = (String)object + list.get(i);
            if (i >= list.size() - 1) continue;
            object = (String)object + ", ";
        }
        arrayList.add((String)object);
        return arrayList;
    }

    private void setzteSternhaufenZugehoerigkeit(IPlanetensucheObjekt iPlanetensucheObjekt) {
        if (iPlanetensucheObjekt.getUmkreistDatenId() != null || Check.isFilled(iPlanetensucheObjekt.getUmkreistObjekt())) {
            return;
        }
        List<String> list = iPlanetensucheObjekt.getObjektNamen();
        for (String string : list) {
            String string2;
            String[] stringArray;
            String string3 = string.toUpperCase().trim();
            if (string3.startsWith("NGC ") || string3.startsWith("IC ")) {
                stringArray = string3.split(" ");
                if (stringArray.length < 3) break;
                string2 = stringArray[0] + " " + stringArray[1];
                this.setzeSternhaufen(iPlanetensucheObjekt, string2, string);
                continue;
            }
            if (!string3.startsWith("MEL ") && !string3.startsWith("CR ") && !string3.startsWith("TR ")) continue;
            stringArray = string.split(" ");
            if (stringArray.length < 3) break;
            string2 = stringArray[0] + " " + stringArray[1];
            this.setzeSternhaufen(iPlanetensucheObjekt, string2, string);
        }
    }

    private void setzeSternhaufen(IPlanetensucheObjekt iPlanetensucheObjekt, String string, String string2) {
        try {
            boolean bl = iPlanetensucheObjekt.setUmkreistObjekt(string);
            if (!bl) {
                LoggingFactory.getLoggerForClass(this.getClass()).warn("nicht m\u00f6glich Stern '" + string2 + "' mit '" + string + "' zu verbinden");
            }
        }
        catch (SQLException sQLException) {
            LoggingFactory.getLoggerForClass(this.getClass()).error("Stern " + string2 + " befindet sich in " + string + "?", sQLException);
        }
    }

    private void pruefeObBraunerZwerg(IPlanetensucheObjekt iPlanetensucheObjekt) throws SQLException {
        int n = 0;
        if (!iPlanetensucheObjekt.isSpektralklasseUnbekannt() && Arrays.asList("L", "T", "Y").contains(iPlanetensucheObjekt.getSpektralklasse())) {
            ++n;
        }
        if (!iPlanetensucheObjekt.isMasseUnbekannt() && iPlanetensucheObjekt.getMasse() < 0.08) {
            ++n;
        }
        if (!iPlanetensucheObjekt.isTemperaturUnbekannt() && iPlanetensucheObjekt.getTemperatur() < 1900.0) {
            ++n;
        }
        if (n >= 2) {
            iPlanetensucheObjekt.setCategory(ObjektKategorie.BR_ZWERGE);
            iPlanetensucheObjekt.setObjekttyp("Brauner Zwerg");
        }
    }
}

