/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.errorlogger.impl;

import de.planetensuche.errorlogger.api.IBugreport;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LogLevel;
import de.planetensuche.errorlogger.api.Modulnummer;
import de.planetensuche.errorlogger.impl.ErrorPrintStream;
import de.planetensuche.errorlogger.impl.GlobalerThrowableBehandler;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessControlException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public final class DateiLogging
implements ILogging {
    private IBugreport bugreport;
    private Logger logger;
    private int logdateiInKB;
    private final Modulnummer bugreportnumber;
    private int anzahlBisherigerErrorAufrufe;
    private static final int MAX_ERROR_AUFRUFE = 10;
    private String errorMessage;
    private boolean bereit;
    private GlobalerThrowableBehandler globalerThrowableBehandler;

    public DateiLogging(Modulnummer modulnummer) throws Exception {
        Object object;
        this.bugreportnumber = modulnummer;
        this.errorMessage = "";
        this.anzahlBisherigerErrorAufrufe = 0;
        this.logdateiInKB = 1024;
        try {
            object = new File("logs");
            if (!((File)object).exists() && !((File)object).mkdir()) {
                throw new AccessControlException("can't create log folder");
            }
            this.createSpecificLogger();
            this.bereit = true;
        }
        catch (Exception exception) {
            this.errorMessage = "Fehler beim Erstellen der Logdatei '" + this.bugreportnumber.getLogfilename() + "'!\nCan't create the logfile '" + this.bugreportnumber.getLogfilename() + "'!\n" + exception.toString();
            throw exception;
        }
        this.globalerThrowableBehandler = new GlobalerThrowableBehandler(this);
        object = Toolkit.getDefaultToolkit().getSystemEventQueue();
        ((EventQueue)object).push(this.globalerThrowableBehandler);
        try {
            System.setErr(new ErrorPrintStream(this));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.error(fileNotFoundException);
        }
    }

    private void createSpecificLogger() {
        String string;
        String string2;
        if (this.bugreportnumber == Modulnummer.HAUPTLOG) {
            string2 = "de.planetensuche";
            string = "planetensuche";
        } else if (this.bugreportnumber == Modulnummer.INSTALLER) {
            string2 = "de.planetensuche.installer";
            string = "install";
        } else {
            string2 = "de.planetensuche.updater";
            string = "update";
        }
        try {
            FileHandler fileHandler = new FileHandler("logs/" + string + ".log", this.logdateiInKB * 1024, 1, true);
            fileHandler.setFormatter(new Formatter(){

                @Override
                public String format(LogRecord logRecord) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.s");
                    GregorianCalendar gregorianCalendar = new GregorianCalendar();
                    gregorianCalendar.setTimeInMillis(logRecord.getMillis());
                    String string = DateiLogging.this.getSourceClassAndMethod();
                    String string2 = simpleDateFormat.format(gregorianCalendar.getTime()) + " " + String.valueOf(logRecord.getLevel()) + " || " + string + "() : " + logRecord.getMessage() + System.lineSeparator();
                    Object object = "";
                    Throwable throwable = logRecord.getThrown();
                    if (throwable != null) {
                        StringWriter stringWriter = new StringWriter();
                        throwable.printStackTrace(new PrintWriter(stringWriter));
                        object = stringWriter.toString() + System.lineSeparator();
                    }
                    return string2 + (String)object;
                }
            });
            this.logger = Logger.getLogger(string2);
            this.logger.addHandler(fileHandler);
            this.logger.setLevel(Level.INFO);
            this.logger.setUseParentHandlers(false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(iOException);
        }
    }

    private String getSourceClassAndMethod() {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        for (int i = 6; i < stackTraceElementArray.length; ++i) {
            String string = stackTraceElementArray[i].getClassName();
            if (!string.startsWith("de.planetensuche") || string.equals(this.getClass().getName()) || string.equals(ErrorPrintStream.class.getName())) continue;
            String string2 = string + "." + stackTraceElementArray[i].getMethodName() + "." + stackTraceElementArray[i].getLineNumber();
            return string2;
        }
        return "?";
    }

    @Override
    public void showErrorMessageBox(Component component, String string, String string2) {
        this.showErrorMessageBoxIntern(component, string, string2);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE) || this.logger.isLoggable(Level.FINER) || this.logger.isLoggable(Level.FINEST) || this.logger.isLoggable(Level.ALL);
    }

    @Override
    public Modulnummer getModulnummer() {
        return this.bugreportnumber;
    }

    @Override
    public void setLogdateigroesseInKB(int n) {
        this.logdateiInKB = n;
        this.createSpecificLogger();
        this.logger.info("new log file size applied: " + this.logdateiInKB + " KB");
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public boolean isBereit() {
        return this.bereit;
    }

    @Override
    public void setErrorZaehlerAufNull() {
        this.anzahlBisherigerErrorAufrufe = 0;
    }

    @Override
    public boolean isErrorZaehlerAufMax() {
        return this.anzahlBisherigerErrorAufrufe >= 10;
    }

    @Override
    public LogLevel getLevel() {
        Level level = this.logger.getLevel();
        if (level == null) {
            return LogLevel.INFO;
        }
        if (level.equals(Level.ALL) || level.equals(Level.FINER) || level.equals(Level.FINEST)) {
            return LogLevel.ALL;
        }
        if (level.equals(Level.OFF)) {
            return LogLevel.OFF;
        }
        if (level.equals(Level.FINE)) {
            return LogLevel.DEBUG;
        }
        return LogLevel.INFO;
    }

    @Override
    public void setLevel(LogLevel logLevel) {
        if (null == logLevel) {
            this.logger.setLevel(Level.INFO);
            return;
        }
        switch (logLevel) {
            case ALL: {
                this.logger.setLevel(Level.ALL);
                break;
            }
            case OFF: {
                this.logger.setLevel(Level.OFF);
                break;
            }
            case DEBUG: {
                this.logger.setLevel(Level.FINE);
                break;
            }
            case INFO: {
                this.logger.setLevel(Level.INFO);
                break;
            }
            default: {
                this.logger.setLevel(Level.WARNING);
            }
        }
    }

    @Override
    public void showErrorMessageBox(Frame frame, String string, String string2) {
        this.showErrorMessageBoxIntern(frame, string, string2);
    }

    @Override
    public void showErrorMessageBox(JFrame jFrame, String string, String string2) {
        this.showErrorMessageBoxIntern(jFrame, string, string2);
    }

    private synchronized void showErrorMessageBoxIntern(Component component, String string, String string2) {
        if (this.anzahlBisherigerErrorAufrufe < 10) {
            JOptionPane.showMessageDialog(component, string, string2, 0);
        }
    }

    @Override
    public void info(Object object) {
        this.logger.info(object.toString());
    }

    @Override
    public void info(Object object, Throwable throwable) {
        this.logger.log(Level.INFO, object.toString(), throwable);
    }

    @Override
    public void warn(Object object) {
        this.logger.warning(object.toString());
    }

    @Override
    public void warn(Object object, Throwable throwable) {
        this.logger.log(Level.WARNING, object.toString(), throwable);
    }

    private synchronized void starteBugReport() {
        if (this.anzahlBisherigerErrorAufrufe < 10 && this.bugreport != null) {
            ++this.anzahlBisherigerErrorAufrufe;
            this.bugreport.open(this.bugreportnumber.getModulNummer());
        }
    }

    @Override
    public void error(Throwable throwable) {
        this.logger.log(Level.SEVERE, throwable.getMessage(), throwable);
        this.starteBugReport();
    }

    @Override
    public void error(Object object, Exception exception) {
        this.logger.log(Level.SEVERE, object.toString(), exception);
        this.starteBugReport();
    }

    @Override
    public void fatal(Object object) {
        this.logger.log(Level.SEVERE, object.toString());
        this.starteBugReport();
    }

    @Override
    public void fatal(Object object, Throwable throwable) {
        this.logger.log(Level.SEVERE, object.toString(), throwable);
        this.starteBugReport();
    }

    @Override
    public void debug(Object object) {
        if (this.getLevel().equals((Object)LogLevel.DEBUG)) {
            this.logger.fine(object.toString());
        }
    }

    @Override
    public void debug(Object object, Throwable throwable) {
        if (this.getLevel().equals((Object)LogLevel.DEBUG)) {
            this.logger.log(Level.FINE, object.toString(), throwable);
        }
    }

    @Override
    public void trace(Object object) {
        if (this.getLevel().equals((Object)LogLevel.ALL)) {
            this.logger.finer(object.toString());
        }
    }

    @Override
    public void trace(Object object, Throwable throwable) {
        if (this.getLevel().equals((Object)LogLevel.ALL)) {
            this.logger.log(Level.FINER, object.toString(), throwable);
        }
    }

    @Override
    public void registriereBugreport(IBugreport iBugreport) {
        this.bugreport = iBugreport;
    }
}

