/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.guidesigner.components.jtable;

import de.planetensuche.guidesigner.components.jtable.IconRenderer;
import de.planetensuche.guidesigner.components.jtable.TextWithIcon;
import de.planetensuche.guidesigner.icons.IconPoolOther;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public final class JTableExtended
extends JTable {
    private ImageIcon sortIcon;
    private boolean isCellEditable;
    private final AtomicBoolean mutex = new AtomicBoolean();

    public JTableExtended() {
        this.init();
    }

    public JTableExtended(TableModel tableModel) {
        super(tableModel);
        this.init();
    }

    public JTableExtended(List<List<Object>> list, List<String> list2, boolean bl) {
        this.setTableContentWithIcon(list, list2);
        this.init();
    }

    public JTableExtended(List<List<String>> list, List<String> list2) {
        this.setTableContent(list, list2);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTableContentWithIcon(List<List<Object>> list, List<String> list2) {
        AtomicBoolean atomicBoolean = this.mutex;
        synchronized (atomicBoolean) {
            Vector<Vector<Object>> vector = new Vector<Vector<Object>>();
            for (List<Object> object2 : list) {
                Vector<Object> vector2 = new Vector<Object>(object2);
                vector.add(vector2);
            }
            Vector vector2 = new Vector();
            for (String string : list2) {
                vector2.add(string);
            }
            DefaultTableModel defaultTableModel = new DefaultTableModel(vector, vector2);
            super.setModel(defaultTableModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTableContent(List<List<String>> list, List<String> list2) {
        AtomicBoolean atomicBoolean = this.mutex;
        synchronized (atomicBoolean) {
            Vector<Vector<String>> vector = new Vector<Vector<String>>();
            for (List<String> object2 : list) {
                Vector<String> vector2 = new Vector<String>(object2);
                vector.add(vector2);
            }
            Vector vector2 = new Vector();
            for (String string : list2) {
                vector2.add(string);
            }
            DefaultTableModel defaultTableModel = new DefaultTableModel(vector, vector2);
            super.setModel(defaultTableModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeColumnWidth() {
        AtomicBoolean atomicBoolean = this.mutex;
        synchronized (atomicBoolean) {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                int n = this.getColumnName(i).length() * 8;
                for (int j = 0; j < this.getRowCount(); ++j) {
                    TableCellRenderer tableCellRenderer = this.getCellRenderer(j, i);
                    Component component = this.prepareRenderer(tableCellRenderer, j, i);
                    n = Math.max(component.getPreferredSize().width + 1, n);
                }
                if (n > 300 && i < this.getColumnCount() - 1) {
                    n = 300;
                }
                this.columnModel.getColumn(i).setPreferredWidth(n);
            }
        }
    }

    private void init() {
        this.isCellEditable = true;
        this.sortIcon = IconPoolOther.SORTING_UP_DOWN.getImageIcon();
    }

    public void disableEditMode() {
        this.isCellEditable = false;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return this.isCellEditable;
    }

    public void disableDragColumns() {
        this.getTableHeader().addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                JTableExtended.this.getTableHeader().setDraggedColumn(null);
            }
        });
    }

    @Override
    public TableCellRenderer getDefaultRenderer(Class<?> clazz) {
        return new IconRenderer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColumnHeaderNamesWithSortIcon(List<String> list) {
        if (this.dataModel.getColumnCount() != list.size()) {
            throw new IllegalArgumentException("Die jtable hat " + this.dataModel.getColumnCount() + " Spalten, es sollen aber " + list.size() + " Spalten befuellt werden!");
        }
        AtomicBoolean atomicBoolean = this.mutex;
        synchronized (atomicBoolean) {
            for (int i = 0; i < list.size(); ++i) {
                TableColumn tableColumn = this.getTableHeader().getColumnModel().getColumn(i);
                tableColumn.setHeaderRenderer(new IconRenderer());
                String string = list.get(i);
                tableColumn.setHeaderValue(new TextWithIcon(string, this.sortIcon));
            }
        }
    }
}

