/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.guidesigner.components.search;

import de.planetensuche.core.db.SearchableDataSource;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.components.search.JComboBoxWithSearch;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.SwingUtilities;

public final class SearchTask
implements Callable<Void> {
    private final ILogging logger = LoggingFactory.getLoggerForClass(SearchTask.class);
    private final String searchText;
    private final SearchableDataSource dataSource;
    private final JComboBoxWithSearch jBox;

    public SearchTask(String string, SearchableDataSource searchableDataSource, JComboBoxWithSearch jComboBoxWithSearch) {
        this.searchText = string;
        this.dataSource = searchableDataSource;
        this.jBox = jComboBoxWithSearch;
    }

    @Override
    public Void call() throws Exception {
        this.jBox.setSelectionDisabled(true);
        try {
            List<String> list = this.dataSource.search(this.searchText);
            if (list.size() > 25) {
                list.removeAll(list.subList(0, 25));
            }
            SwingUtilities.invokeLater(() -> {
                this.jBox.setPopupVisible(false);
                String string = this.jBox.getText();
                this.jBox.removeAllItems();
                for (String string2 : list) {
                    this.jBox.addItem(string2);
                }
                this.jBox.setSelectedItem(string);
                if (!this.jBox.isShowing()) {
                    return;
                }
                this.jBox.setPopupVisible(true);
                this.jBox.setSelectionDisabled(false);
            });
        }
        catch (RuntimeException runtimeException) {
            this.logger.error(runtimeException);
            this.jBox.setSelectionDisabled(false);
        }
        return null;
    }
}

