/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.konfigurator.impl;

import de.planetensuche.konfigurator.api.IBeobachtungsortkonfiguration;
import de.planetensuche.konfigurator.api.IDatenbankkonfiguration;
import de.planetensuche.konfigurator.api.IFinsternisseKonfiguration;
import de.planetensuche.konfigurator.api.IHauptkonfiguration;
import de.planetensuche.konfigurator.api.IKonfigurator;
import de.planetensuche.konfigurator.impl.Beobachtungsortkonfiguration;
import de.planetensuche.konfigurator.impl.Datenbankkonfiguration;
import de.planetensuche.konfigurator.impl.FinsternisseKonfiguration;
import de.planetensuche.konfigurator.impl.Hauptkonfiguration;
import de.planetensuche.konfigurator.impl.Konfigurator;
import java.io.File;

public final class KonfiguratorFabrik {
    public static final String KONFIG_DATEI_GLOBAL = "conf" + File.separator + "globalConfig.xml";
    private static String eigeneKonfigDatei;
    private static FinsternisseKonfiguration finsternisseKonfiguration;

    private KonfiguratorFabrik() {
    }

    public static void init(String string) {
        eigeneKonfigDatei = string;
    }

    public static IKonfigurator getKonfigurator(String string) {
        return new Konfigurator(string);
    }

    public static IKonfigurator getKonfigurator() {
        if (eigeneKonfigDatei != null) {
            return new Konfigurator(eigeneKonfigDatei);
        }
        return new Konfigurator(KONFIG_DATEI_GLOBAL);
    }

    public static IHauptkonfiguration getHauptkonfiguration() {
        return new Hauptkonfiguration();
    }

    public static IHauptkonfiguration getHauptkonfiguration(File file) {
        return new Hauptkonfiguration(file);
    }

    public static IDatenbankkonfiguration getDatenbankkonfiguration() {
        return new Datenbankkonfiguration();
    }

    public static IDatenbankkonfiguration getDatenbankkonfiguration(File file) {
        return new Datenbankkonfiguration(file);
    }

    public static synchronized IFinsternisseKonfiguration getFinsternisseKonfiguration(boolean bl) {
        if (finsternisseKonfiguration == null) {
            finsternisseKonfiguration = new FinsternisseKonfiguration(new File("conf" + File.separator + "finsternisse.conf"), bl);
        }
        return finsternisseKonfiguration;
    }

    public static synchronized IFinsternisseKonfiguration getFinsternisseKonfiguration(File file, boolean bl) {
        if (finsternisseKonfiguration == null) {
            finsternisseKonfiguration = new FinsternisseKonfiguration(file, bl);
        }
        return finsternisseKonfiguration;
    }

    public static IBeobachtungsortkonfiguration getBeobachtungskonfiguration() {
        return new Beobachtungsortkonfiguration();
    }
}

