/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.mutex;

import de.planetensuche.mutex.IMutex;
import de.planetensuche.mutex.ProcessTypes;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public final class Mutex
implements IMutex {
    private final File processesLog;
    private final String key;
    private boolean bereit;

    public Mutex(ProcessTypes processTypes) throws IOException {
        this.key = processTypes.getKey();
        this.bereit = false;
        this.processesLog = new File("temp" + File.separator + "processes.log");
        if (this.key.isEmpty()) {
            throw new IllegalArgumentException("key is empty!");
        }
        if (this.processesLog.exists()) {
            this.bereit = true;
        } else if (this.processesLog.createNewFile()) {
            this.bereit = true;
        }
    }

    @Override
    public boolean isBereit() {
        return this.bereit;
    }

    @Override
    public void prozessBeendet() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.processesLog));){
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.equals(this.key)) continue;
                arrayList.add(string);
            }
            try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.processesLog));){
                for (String string2 : arrayList) {
                    bufferedWriter.write(string2);
                    bufferedWriter.newLine();
                }
            }
        }
    }

    @Override
    public void prozessGestartet() throws IOException {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.processesLog, true));){
            bufferedWriter.write(this.key);
            bufferedWriter.newLine();
        }
    }

    @Override
    public boolean istBereitsGestartet() throws IOException {
        boolean bl = false;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.processesLog));){
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                if (!string.equals(this.key)) continue;
                bl = true;
                break;
            }
            boolean bl2 = bl;
            return bl2;
        }
    }

    @Override
    public void alleProzesseBeenden() throws IOException {
        this.processesLog.delete();
        this.processesLog.createNewFile();
    }
}

