/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.updater;

import de.planetensuche.core.JavaVersionHelperUtil;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import de.planetensuche.quiz.StartGui;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.updater.IUpdateDialog;
import de.planetensuche.updater.jre.JreUpdateService;
import de.planetensuche.updater.ps.DatenbankUpdater;
import de.planetensuche.updater.ps.PlanetensucheDownloadService;
import de.planetensuche.updater.ps.PlanetensucheUpdateDto;
import de.planetensuche.updater.ps.ZipDownloader;
import de.planetensuche.updater.ps.ZipExtractorService;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.tuple.Pair;

public class UpdateThread
extends Thread {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(UpdateThread.class);
    private int versionAktuell = 512;
    private final int datenbankRamInMb;
    private boolean quizZeigen = true;
    private final KonfigurationDTO konfiguration;
    private final ISprachcontainer i18n;
    private final IUpdateDialog gui;
    private final ZipDownloader zipDownloader;
    private final PlanetensucheDownloadService planetensucheDownloadService;
    private final ZipExtractorService zipExtractorService;
    private boolean showConfirmIncrementalUpdate;

    public UpdateThread(String string, IUpdateDialog iUpdateDialog, ISprachcontainer iSprachcontainer, boolean bl, int n, KonfigurationDTO konfigurationDTO) {
        this.i18n = iSprachcontainer;
        this.datenbankRamInMb = n;
        this.konfiguration = konfigurationDTO;
        switch (string.length()) {
            case 5: {
                this.versionAktuell = Integer.parseInt(string.substring(0, 1) + string.substring(2, 3) + string.substring(4, 5));
                break;
            }
            case 4: {
                this.versionAktuell = Integer.parseInt(string.substring(0, 1) + string.substring(2, 4));
                break;
            }
            case 3: {
                this.versionAktuell = Integer.parseInt(string.substring(0, 1) + "0" + string.substring(2, 3));
                break;
            }
            default: {
                throw new IllegalArgumentException("Die Version '" + string + "' hat nicht die richtige Laenge!");
            }
        }
        LOGGER.info("planetensuche-version: " + this.versionAktuell);
        this.gui = iUpdateDialog;
        this.zipDownloader = new ZipDownloader(this, iSprachcontainer, iUpdateDialog, bl, konfigurationDTO);
        this.planetensucheDownloadService = new PlanetensucheDownloadService(bl, konfigurationDTO);
        this.zipExtractorService = new ZipExtractorService(this.i18n, this.gui);
    }

    boolean isShowConfirmIncrementalUpdate() {
        return this.showConfirmIncrementalUpdate;
    }

    public int getVersionAktuell() {
        return this.versionAktuell;
    }

    @Override
    public void run() {
        this.updateJre();
        this.updatePlanetensuche();
        this.gui.updateDone();
    }

    void updatePlanetensuche() {
        try {
            boolean bl = false;
            this.gui.appendOutput("\n\n" + this.i18n.getString("up_m9"));
            Pair<List<String>, List<Long>> pair = this.planetensucheDownloadService.readZipFilesAndCrcHashs();
            this.gui.appendOutput(this.i18n.getString("up_m10") + "\n");
            List<PlanetensucheUpdateDto> list = this.planetensucheDownloadService.findInstallableUpdates(this.versionAktuell);
            if (list.size() > 3) {
                this.showConfirmIncrementalUpdate = true;
                String string = this.i18n.getString("up_m30", list.size());
                int n = JOptionPane.showConfirmDialog(this.gui.getDialog(), string, this.i18n.getString("up_m30_titel"), 0);
                if (n == 1) {
                    this.gui.appendOutput(this.i18n.getString("up_m8"));
                    return;
                }
            }
            for (PlanetensucheUpdateDto planetensucheUpdateDto : list) {
                Object object;
                if (!JavaVersionHelperUtil.isVersionCompatible(planetensucheUpdateDto.getRequireJavaVersion())) {
                    if (JavaVersionHelperUtil.isLocalJreAvailable()) {
                        this.gui.appendOutput(this.i18n.getString("up_m40", planetensucheUpdateDto.getRequireJavaVersion()));
                        this.upgradeJre(planetensucheUpdateDto.getRequireJavaVersion());
                    } else {
                        object = this.i18n.getString("up_m27", planetensucheUpdateDto.getRequireJavaVersion());
                        JavaVersionHelperUtil.showJavaUpdateRequiredMessage((JFrame)this.gui.getDialog(), (String)object, this.i18n.getString("up_m27_titel"));
                        System.exit(0);
                    }
                }
                if (!(bl = this.downloadAndInstallSingleUpdate(planetensucheUpdateDto, pair))) break;
                object = new File("updater.new");
                if (!((File)object).exists()) continue;
                this.starteHauptprogramm(true);
            }
            if (this.isInterrupted()) {
                this.gui.appendOutput(this.i18n.getString("up_m8"));
            } else {
                this.gui.appendOutput(this.i18n.getString("up_m18"));
                if (bl) {
                    this.starteHauptprogramm(false);
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            String string = this.i18n.getString("up_m39") + "\n" + unknownHostException.getLocalizedMessage();
            JOptionPane.showMessageDialog(this.gui.getDialog(), string, this.i18n.getString("up_m8"), 0);
        }
        catch (IOException | InterruptedException | RuntimeException | URISyntaxException exception) {
            this.gui.appendOutput("\n" + this.i18n.getString("db_f16") + " " + exception.getLocalizedMessage());
            LOGGER.error(exception);
        }
    }

    void updateJre() {
        try {
            if (JavaVersionHelperUtil.isLocalJreAvailable()) {
                LOGGER.info("search for Java updates and install them...");
                this.gui.appendOutput("\n\n");
                JreUpdateService jreUpdateService = new JreUpdateService(this.konfiguration, this.gui, this.i18n);
                jreUpdateService.searchAndInstallUpdates(JavaVersionHelperUtil.getInstalledJavaMajorVersion());
                LOGGER.info("finished Java updates");
            } else {
                LOGGER.info("no local JRE found, skip JRE update process");
            }
        }
        catch (IOException | RuntimeException exception) {
            LOGGER.error(exception);
        }
    }

    void upgradeJre(int n) {
        try {
            if (JavaVersionHelperUtil.isLocalJreAvailable()) {
                LOGGER.info("search for the required Java " + n + " upgrade and install them...");
                this.gui.appendOutput("\n\n");
                JreUpdateService jreUpdateService = new JreUpdateService(this.konfiguration, this.gui, this.i18n);
                jreUpdateService.searchAndInstallUpdates(n);
                LOGGER.info("finished Java " + n + " upgrade");
            } else {
                LOGGER.info("no local JRE found, skip JRE upgrade process");
            }
        }
        catch (RuntimeException runtimeException) {
            LOGGER.error(runtimeException);
            LOGGER.info("Java " + n + " upgrade failed; exit Planetensuche Update");
            System.exit(-2);
        }
    }

    private void starteHauptprogramm(boolean bl) {
        try {
            if (bl) {
                JOptionPane.showMessageDialog(null, this.i18n.getString("up_m29"), this.i18n.getString("up_m29_titel"), 1);
            } else if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().open(new File(this.i18n.getLinkZumHandbuch()));
            }
            Runtime.getRuntime().exec(JavaVersionHelperUtil.getCurrentJavaPath() + " -Xmx" + this.datenbankRamInMb + "m -XX:+UseStringDeduplication -jar planetensuche.jar");
            System.exit(0);
        }
        catch (IOException iOException) {
            LOGGER.error(iOException);
            JOptionPane.showMessageDialog(null, this.i18n.getString("start_hilfe-starten_ioException") + "\n" + iOException.toString(), this.i18n.getString("start_hilfe-starten_error_titel"), 0);
        }
    }

    private boolean downloadAndInstallSingleUpdate(PlanetensucheUpdateDto planetensucheUpdateDto, Pair<List<String>, List<Long>> pair) throws IOException, InterruptedException {
        int n = JOptionPane.showConfirmDialog(null, this.i18n.getString("up_m25") + " " + planetensucheUpdateDto.getSizeInMb() + this.i18n.getString("up_m25_2"), this.i18n.getString("up_gui2"), 0);
        if (n == 1) {
            return false;
        }
        if (this.quizZeigen) {
            this.zeigeQuiz();
            this.quizZeigen = false;
        }
        this.gui.appendOutput(this.i18n.getString("up_m11") + " '" + planetensucheUpdateDto.getFileName() + "' " + this.i18n.getString("up_m12"));
        boolean bl = this.zipDownloader.download(planetensucheUpdateDto.getFileName(), planetensucheUpdateDto.getFileName(), planetensucheUpdateDto.getSizeInMb(), pair.getLeft(), pair.getRight());
        this.gui.appendOutput(this.i18n.getString("up_m13") + " " + bl);
        if (bl && !this.isInterrupted()) {
            Object object;
            this.gui.appendOutput(this.i18n.getString("up_m14"));
            boolean bl2 = this.zipExtractorService.entpackeZipDatei(planetensucheUpdateDto.getFileName());
            if (bl2) {
                this.gui.enableUpdateCancelButton(false);
                object = new DatenbankUpdater(this.datenbankRamInMb, this.gui);
                ((DatenbankUpdater)object).starteUpdate();
                this.gui.appendOutput("");
                this.gui.enableUpdateCancelButton(true);
                this.zipExtractorService.archiviereAktuelleUpdateZip(planetensucheUpdateDto);
            }
            object = new File(planetensucheUpdateDto.getFileName());
            ((File)object).deleteOnExit();
            this.gui.appendOutput(this.i18n.getString("up_m16") + " " + bl2 + "\n");
            if (bl2) {
                this.gui.appendOutput(this.i18n.getString("up_m17"));
                return true;
            }
            this.gui.appendOutput(this.i18n.getString("up_m8"));
        } else {
            this.gui.appendOutput(this.i18n.getString("up_m8"));
        }
        return false;
    }

    private void zeigeQuiz() throws IOException {
        int n = JOptionPane.showConfirmDialog(null, this.i18n.getString("up_m26"), this.i18n.getString("up_m26_titel"), 0);
        if (n == 0) {
            StartGui startGui = new StartGui();
            startGui.showDialog();
        }
    }
}

