/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.updater.ps;

import de.planetensuche.core.JavaVersionHelperUtil;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.errorlogger.api.Modulnummer;
import de.planetensuche.updater.IUpdateDialog;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.commons.io.FileUtils;

public final class DatenbankUpdater {
    private final ILogging logging = LoggingFactory.getLoggerForModule(Modulnummer.UPDATE);
    private final int datenbankRamInMb;
    private final IUpdateDialog gui;

    public DatenbankUpdater(int n, IUpdateDialog iUpdateDialog) {
        this.datenbankRamInMb = n;
        this.gui = iUpdateDialog;
    }

    public void starteUpdate() throws IOException, InterruptedException {
        File file;
        File file2 = new File("update.sql");
        if (file2.exists()) {
            this.updateDatenbankTabellen();
        }
        if ((file = new File("update.xml")).exists()) {
            this.erzeugeXMLSchema();
            this.importiereXMLDatei();
            FileUtils.copyFile(file, new File("database" + File.separator + file.getName()));
            if (!file.delete()) {
                this.logging.warn("konnte " + file.getName() + " nicht loeschen");
            }
        }
    }

    private void updateDatenbankTabellen() throws IOException, InterruptedException {
        this.starteDatenbank("sql", "update.sql", true);
    }

    private void erzeugeXMLSchema() throws IOException, InterruptedException {
        Process process = this.starteDatenbank("s", "", false);
        this.logging.info("XML-Schema geschrieben: " + process.exitValue());
    }

    private void importiereXMLDatei() throws IOException, InterruptedException {
        this.starteDatenbank("import", "update.xml", true);
    }

    private Process starteDatenbank(String string, String string2, boolean bl) throws IOException, InterruptedException {
        Process process = Runtime.getRuntime().exec(JavaVersionHelperUtil.getCurrentJavaPath() + " -Xmx" + this.datenbankRamInMb + "m -XX:+UseStringDeduplication -jar planetensuche.jar -" + string + " " + string2);
        if (bl) {
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String string3;
                while ((string3 = bufferedReader.readLine()) != null) {
                    this.gui.appendOutput(string3);
                }
            }
        } else {
            process.waitFor();
        }
        return process;
    }
}

