/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.updater.ps;

import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import de.planetensuche.updater.ps.PlanetensucheUpdateDto;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class PlanetensucheDownloadService {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(PlanetensucheDownloadService.class);
    private final URL updateIndexDateiURL;
    private final URL crcIndexDateiURL;
    private final String baseURL;

    public PlanetensucheDownloadService(boolean bl, KonfigurationDTO konfigurationDTO) {
        try {
            if (bl) {
                LOGGER.info("use test URL");
                this.baseURL = "https://www." + konfigurationDTO.getHomepageHostname() + "/pstest/";
                this.updateIndexDateiURL = new URL(this.baseURL + "update.txt");
                this.crcIndexDateiURL = new URL(this.baseURL + "chksum.txt");
            } else {
                LOGGER.info("use live URL");
                this.baseURL = "https://www." + konfigurationDTO.getHomepageHostname() + "/ps/";
                this.updateIndexDateiURL = new URL(konfigurationDTO.getUpdateUrl());
                this.crcIndexDateiURL = new URL(this.baseURL + "chksum.txt");
            }
        }
        catch (MalformedURLException malformedURLException) {
            LOGGER.error(malformedURLException);
            throw new IllegalArgumentException(malformedURLException);
        }
    }

    public List<PlanetensucheUpdateDto> findInstallableUpdates(int n) throws IOException {
        ArrayList<PlanetensucheUpdateDto> arrayList = new ArrayList<PlanetensucheUpdateDto>();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.updateIndexDateiURL.openStream()));){
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                int n2;
                String[] stringArray;
                if (string.isEmpty() || (stringArray = string.split(";")).length <= 1 || (n2 = Integer.parseInt(stringArray[0])) <= n) continue;
                PlanetensucheUpdateDto planetensucheUpdateDto = new PlanetensucheUpdateDto();
                planetensucheUpdateDto.setPlanetensucheVersion(n2);
                planetensucheUpdateDto.setFileName(stringArray[1]);
                planetensucheUpdateDto.setSizeInMb(Double.parseDouble(stringArray[2]));
                planetensucheUpdateDto.setRequireJavaVersion(Integer.parseInt(stringArray[3]));
                arrayList.add(planetensucheUpdateDto);
            }
        }
        return arrayList;
    }

    public Pair<List<String>, List<Long>> readZipFilesAndCrcHashs() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.crcIndexDateiURL.openStream()));){
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray;
                if (string.isEmpty() || (stringArray = string.split(";")).length != 2) continue;
                arrayList.add(stringArray[0]);
                arrayList2.add(Long.parseLong(stringArray[1]));
            }
        }
        return Pair.of(arrayList, arrayList2);
    }
}

