/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.updater.ps;

import de.planetensuche.dateihelfer.IZipBeobachter;
import de.planetensuche.dateihelfer.Zip;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.updater.IUpdateDialog;
import de.planetensuche.updater.ps.PlanetensucheUpdateDto;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipException;
import org.apache.commons.io.FileUtils;

public class ZipExtractorService
implements IZipBeobachter {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(ZipExtractorService.class);
    private final ISprachcontainer i18n;
    private final IUpdateDialog gui;

    public ZipExtractorService(ISprachcontainer iSprachcontainer, IUpdateDialog iUpdateDialog) {
        this.i18n = iSprachcontainer;
        this.gui = iUpdateDialog;
    }

    public boolean entpackeZipDatei(String string) {
        try {
            this.gui.appendOutput(string);
            Zip.unzip(new File(string), this, this.i18n.getString("up_m22"), this.i18n.getString("up_m23"));
            return true;
        }
        catch (ZipException zipException) {
            LOGGER.error("entpackeZipDatei(" + string + ")", zipException);
            return false;
        }
        catch (IOException iOException) {
            LOGGER.error("entpackeZipDatei(" + string + ")", iOException);
            return false;
        }
    }

    public void archiviereAktuelleUpdateZip(PlanetensucheUpdateDto planetensucheUpdateDto) throws IOException {
        File file = new File("updates");
        if (file.exists() || file.mkdir()) {
            FileUtils.copyFile(new File(planetensucheUpdateDto.getFileName()), new File("updates" + File.separator + planetensucheUpdateDto.getFileName()));
        } else {
            LOGGER.warn("updates Verzeichnis fehlt");
        }
    }

    @Override
    public void setInfoText(String string) {
        this.gui.appendOutput(string);
    }

    @Override
    public void setWarningText(String string, Exception exception) {
        LOGGER.warn(string, exception);
    }
}

