/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datamodel.formeln;

import de.planetensuche.datamodel.formeln.EscapeVelocityCalculator;
import de.planetensuche.datamodel.formeln.Konstanten;
import java.util.Optional;

public class EarthSimilarityIndexSolSystemCalculator {
    private static final double WI_RADIUS = 0.57;
    private static final double WI_DENSITY = 1.07;
    private static final double WI_VELOCITY = 0.7;
    private static final double WI_TEMPERATURE = 5.58;

    public Optional<Double> calcESI(double d, double d2, double d3) {
        if (d == 0.0 || d2 == 0.0 || d3 <= 0.0) {
            return Optional.empty();
        }
        Optional<Double> optional = new EscapeVelocityCalculator().calculateSecondCosmicVelocity(d2, d);
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        double d4 = d / 2.0 * 142984.0;
        double d5 = d2 * 1.898E27;
        double d6 = 4.1887902047863905 * Math.pow(d4, 3.0);
        double d7 = d5 / d6;
        double d8 = Konstanten.ERDMASSE_IN_KG / (4.1887902047863905 * Math.pow(6371.0, 3.0));
        double d9 = (d4 - 6371.0) / (d4 + 6371.0);
        d9 = d9 < 0.0 ? d9 * -1.0 : d9;
        d9 = 1.0 - d9;
        d9 = Math.pow(d9, 0.57);
        double d10 = (d7 - d8) / (d7 + d8);
        d10 = d10 < 0.0 ? d10 * -1.0 : d10;
        d10 = 1.0 - d10;
        d10 = Math.pow(d10, 1.07);
        double d11 = (optional.get() - 11.186) / (optional.get() + 11.186);
        d11 = d11 < 0.0 ? d11 * -1.0 : d11;
        d11 = 1.0 - d11;
        d11 = Math.pow(d11, 0.7);
        double d12 = (d3 - 288.15) / (d3 + 288.15);
        d12 = d12 < 0.0 ? d12 * -1.0 : d12;
        d12 = 1.0 - d12;
        d12 = Math.pow(d12, 5.58);
        double d13 = Math.sqrt(d9 * d10);
        double d14 = Math.sqrt(d11 * d12);
        double d15 = Math.sqrt(d13 * d14);
        return Optional.of(d15);
    }
}

