/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datamodel.helfer;

import de.planetensuche.datamodel.api.PlanetensucheObjektPrueferDAO;
import de.planetensuche.datamodel.api.SternbildSprache;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DAOhighMock
implements PlanetensucheObjektPrueferDAO {
    private List<String> objektNamenInDB = new ArrayList<String>();
    private List<String> kategorien;
    private List<String> objekttypen;
    private List<String> sptyp;
    private List<Double> sptypUnterteilung;
    private List<String> leuchtkraftklassen;
    private List<String> galaxienformen;
    private List<String> galaxienarten;
    private List<String> sternhaufenformenOffen;
    private List<String> sternhaufenformenKugel;
    private List<String> nebelformPlanetarisch;
    private List<String> nebelformNebel;
    private List<String> entdeckungsmethoden;
    private List<String> sternbilderNamen;

    public DAOhighMock() {
        this.objektNamenInDB.add("BD+60 1800A");
        this.objektNamenInDB.add("BD+60 1800B");
        this.objektNamenInDB.add("BD+60 1800C");
        this.kategorien = new ArrayList<String>();
        this.kategorien.add("Planeten");
        this.kategorien.add("Sterne");
        this.kategorien.add("Galaxien und Nebel");
        this.objekttypen = new ArrayList<String>();
        this.objekttypen.add("Einzelstern");
        this.objekttypen.add("Veraenderlicher unbekannten Typs");
        this.objekttypen.add("Doppelstern physisch");
        this.objekttypen.add("Mehrfachsternensystem");
        this.objekttypen.add("Gasriese");
        this.objekttypen.add("erdaehnlich");
        this.objekttypen.add("Planet");
        this.sptyp = new ArrayList<String>();
        this.sptyp.add("O");
        this.sptyp.add("B");
        this.sptyp.add("A");
        this.sptyp.add("F");
        this.sptyp.add("G");
        this.sptyp.add("K");
        this.sptyp.add("M");
        this.sptyp.add("DA");
        this.sptyp.add("DB");
        this.sptyp.add("DQ");
        this.sptyp.add("DZ");
        this.sptyp.add("DC");
        this.sptyp.add("DX");
        this.sptyp.add("DO");
        this.sptyp.add("WC");
        this.sptyp.add("WN");
        this.sptyp.add("WR");
        this.sptyp.add("S");
        this.sptyp.add("L");
        this.sptyp.add("T");
        this.sptyp.add("Y");
        this.sptyp.add("unbekannt");
        this.sptypUnterteilung = new ArrayList<Double>();
        for (double d = 0.5; d < 13.5; d += 0.5) {
            this.sptypUnterteilung.add(d);
        }
        this.leuchtkraftklassen = new ArrayList<String>();
        this.leuchtkraftklassen.add("Ia");
        this.leuchtkraftklassen.add("Ib");
        this.leuchtkraftklassen.add("II");
        this.leuchtkraftklassen.add("III");
        this.leuchtkraftklassen.add("IV");
        this.leuchtkraftklassen.add("V");
        this.leuchtkraftklassen.add("VI");
        this.leuchtkraftklassen.add("VII");
        this.leuchtkraftklassen.add("unbekannt");
        this.galaxienformen = new ArrayList<String>();
        this.galaxienformen.add("Sc");
        this.galaxienformen.add("SBc");
        this.galaxienarten = new ArrayList<String>();
        this.galaxienarten.add("Riesengalaxie");
        this.sternhaufenformenOffen = new ArrayList<String>();
        this.sternhaufenformenOffen.add("sternenarm");
        this.sternhaufenformenKugel = new ArrayList<String>();
        this.sternhaufenformenKugel.add("V");
        this.nebelformNebel = new ArrayList<String>();
        this.nebelformNebel.add("Emissionsnebel");
        this.nebelformPlanetarisch = new ArrayList<String>();
        this.nebelformPlanetarisch.add("Ring");
        this.entdeckungsmethoden = new ArrayList<String>();
        this.entdeckungsmethoden.add("Timing");
        this.sternbilderNamen = new ArrayList<String>();
        this.sternbilderNamen.add("And");
        this.sternbilderNamen.add("Aql");
        this.sternbilderNamen.add("Aqr");
        this.sternbilderNamen.add("Ara");
        this.sternbilderNamen.add("Ari");
        this.sternbilderNamen.add("Boo");
        this.sternbilderNamen.add("Cas");
        this.sternbilderNamen.add("Cen");
        this.sternbilderNamen.add("Cnc");
        this.sternbilderNamen.add("CrB");
        this.sternbilderNamen.add("Del");
        this.sternbilderNamen.add("For");
        this.sternbilderNamen.add("Gem");
        this.sternbilderNamen.add("Her");
        this.sternbilderNamen.add("Leo");
        this.sternbilderNamen.add("Lyn");
        this.sternbilderNamen.add("Oph");
        this.sternbilderNamen.add("Pic");
        this.sternbilderNamen.add("Ser");
        this.sternbilderNamen.add("Vir");
    }

    @Override
    public List<String> getGalaxienformen() {
        return this.galaxienformen;
    }

    @Override
    public List<String> getGalaxienarten() {
        return this.galaxienarten;
    }

    @Override
    public List<String> getSternhaufenformen(String string) {
        if ("Offener Sternhaufen".equals(string)) {
            return this.sternhaufenformenOffen;
        }
        if ("Kugelsternhaufen".equals(string)) {
            return this.sternhaufenformenKugel;
        }
        if ("".equals(string)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.addAll(this.sternhaufenformenKugel);
            arrayList.addAll(this.sternhaufenformenOffen);
            return arrayList;
        }
        throw new IllegalArgumentException(string + " =?");
    }

    @Override
    public List<String> getNebelformen(String string) {
        if ("".equals(string)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.addAll(this.nebelformNebel);
            arrayList.addAll(this.nebelformPlanetarisch);
            return arrayList;
        }
        throw new IllegalArgumentException(string + " =?");
    }

    @Override
    public List<String> getSpektraltypen(String string) {
        if (string.isEmpty() || "Sterne".equals(string)) {
            return this.sptyp;
        }
        throw new IllegalArgumentException(string + " =?");
    }

    @Override
    public List<Double> getSpektraltypen2(boolean bl) {
        if (!bl) {
            return this.sptypUnterteilung;
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.addAll(this.sptypUnterteilung);
        arrayList.add(12.5);
        return arrayList;
    }

    @Override
    public List<String> getLeuchtkraftklassen() {
        return this.leuchtkraftklassen;
    }

    @Override
    public int isObjektInDatenbank(List<String> list) {
        int n = 0;
        for (String string : list) {
            if (!this.objektNamenInDB.contains(string)) continue;
            ++n;
        }
        return n;
    }

    public void saveObjekt(String string) {
        this.objektNamenInDB.add(string);
    }

    @Override
    public List<String> getKategorien() {
        return this.kategorien;
    }

    @Override
    public List<String> getObjekttypen(String string) {
        return this.objekttypen;
    }

    @Override
    public List<String> getEntdeckungsmethoden() {
        return this.entdeckungsmethoden;
    }

    @Override
    public List<String> getSternbilderNamen(SternbildSprache sternbildSprache) {
        if (SternbildSprache.LATEINISCH_ABK.equals((Object)sternbildSprache)) {
            return this.sternbilderNamen;
        }
        return new ArrayList<String>(0);
    }

    @Override
    public String getSternbildGenitiv(String string) throws SQLException {
        return switch (string.toLowerCase()) {
            case "and" -> "Andromedae";
            case "aql" -> "Aquilae";
            case "aqr" -> "Aquarii";
            case "ara" -> "Arae";
            case "ari" -> "Arietis";
            case "boo" -> "Bootis";
            case "cas" -> "Cassiopeiae";
            case "cen" -> "Centauri";
            case "crb" -> "Coronae Borealis";
            case "del" -> "Delphini";
            case "dra" -> "Draconis";
            case "for" -> "Fornacis";
            case "gem" -> "Gemini";
            case "her" -> "Herculis";
            case "leo" -> "Leonis";
            case "lyn" -> "Lyncis";
            case "oph" -> "Ophiuchi";
            case "pic" -> "Pictoris";
            case "ser" -> "Serpentis";
            case "vir" -> "Virginis";
            default -> "Definition im Mock fehlt f\u00fcr '" + string.toLowerCase() + "'";
        };
    }

    @Override
    public boolean isObjectInDB(Integer n) throws SQLException {
        return true;
    }
}

