/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datamodel.impl;

import de.planetensuche.datamodel.api.IKoordinate;

public final class Koordinate
implements IKoordinate {
    private int stunden;
    private int minuten;
    private double sekunden;

    private Koordinate() {
    }

    public Koordinate(int n, int n2, double d) {
        this.stunden = n;
        this.minuten = n2;
        this.sekunden = d;
    }

    public Koordinate(double d) {
        double d2 = (int)d;
        double d3 = (d - d2) * 60.0;
        double d4 = d3 - (double)((int)d3);
        this.stunden = (int)d2;
        this.minuten = (int)d3;
        if (this.minuten < 0) {
            this.minuten *= -1;
        }
        this.sekunden = d4 * 60.0;
        if (this.sekunden < 0.0) {
            this.sekunden *= -1.0;
        }
    }

    public Koordinate(String string) {
        String[] stringArray = string.split(":");
        this.stunden = Integer.parseInt(stringArray[0]);
        this.minuten = Integer.parseInt(stringArray[1]);
        this.sekunden = Double.parseDouble(stringArray[2]);
    }

    @Override
    public int getStunden() {
        return this.stunden;
    }

    @Override
    public int getMinuten() {
        return this.minuten;
    }

    @Override
    public double getSekunden() {
        return this.sekunden;
    }

    @Override
    public String toString() {
        return this.stunden + ":" + this.minuten + ":" + this.sekunden;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Koordinate koordinate = (Koordinate)object;
        if (this.stunden != koordinate.stunden) {
            return false;
        }
        if (this.minuten != koordinate.minuten) {
            return false;
        }
        return Double.doubleToLongBits(this.sekunden) == Double.doubleToLongBits(koordinate.sekunden);
    }

    public int hashCode() {
        int n = 5;
        n = 67 * n + this.stunden;
        n = 67 * n + this.minuten;
        n = 67 * n + (int)(Double.doubleToLongBits(this.sekunden) ^ Double.doubleToLongBits(this.sekunden) >>> 32);
        return n;
    }
}

