/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.datamodel.impl;

import de.planetensuche.core.Check;
import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.api.IPlanetensucheObjektPruefer;
import de.planetensuche.datamodel.api.ObjektKategorie;
import de.planetensuche.datamodel.api.PlanetensucheObjektPrueferDAO;
import de.planetensuche.datamodel.impl.PlanetensucheObjekt;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class PlanetensucheObjektPruefer
extends PlanetensucheObjekt
implements IPlanetensucheObjektPruefer {
    public static final String FEHLERMELDUNG = "Der Wert entspricht nicht dem geforderten Datentyp: ";
    private final ILogging logging;
    private final PlanetensucheObjektPrueferDAO dao;

    public PlanetensucheObjektPruefer(PlanetensucheObjektPrueferDAO planetensucheObjektPrueferDAO) {
        this.dao = planetensucheObjektPrueferDAO;
        this.logging = LoggingFactory.getLoggerForClass(this.getClass());
    }

    public PlanetensucheObjektPruefer(PlanetensucheObjektPrueferDAO planetensucheObjektPrueferDAO, IPlanetensucheObjekt iPlanetensucheObjekt) throws SQLException {
        this.dao = planetensucheObjektPrueferDAO;
        this.logging = LoggingFactory.getLoggerForClass(this.getClass());
        this.setDatenVonDto(iPlanetensucheObjekt);
    }

    @Override
    public boolean setAlterInMrdJahre(double d) {
        if (d >= 0.0) {
            return super.setAlterInMrdJahre(d);
        }
        this.logging.warn("Der Wert entspricht nicht dem geforderten Datentyp: setAlter(" + d + ")");
        return false;
    }

    @Override
    public boolean setGalaxienform(String string) throws SQLException {
        if ("".equals(string) || this.dao.getGalaxienformen().contains(string)) {
            return super.setGalaxienform(string);
        }
        this.logging.warn("Der Wert entspricht nicht dem geforderten Datentyp: setGalaxienform(" + string + ")");
        return false;
    }

    @Override
    public boolean setGalaxienart(String string) throws SQLException {
        if ("".equals(string) || this.dao.getGalaxienarten().contains(string)) {
            return super.setGalaxienart(string);
        }
        this.logging.warn("Der Wert entspricht nicht dem geforderten Datentyp: setGalaxienart(" + string + ")");
        return false;
    }

    @Override
    public boolean setRotverschiebung(double d) {
        if (d <= 20.0 && d > -1.0 || d == -10.0) {
            return super.setRotverschiebung(d);
        }
        this.logging.warn("Der Wert entspricht nicht dem geforderten Datentyp: setRotverschiebung(" + d + ")");
        return false;
    }

    @Override
    public boolean setSternentstehung(int n) {
        if (n >= 0 && n <= 250) {
            return super.setSternentstehung(n);
        }
        this.logging.warn("Der Wert entspricht nicht dem geforderten Datentyp: setSternentstehung(" + n + ")");
        return false;
    }

    @Override
    public boolean setSternhaufenform(String string) throws SQLException {
        if ("".equals(string) || this.dao.getSternhaufenformen("").contains(string)) {
            return super.setSternhaufenform(string);
        }
        this.logging.warn("Der Wert entspricht nicht dem geforderten Datentyp: setSternhaufenform(" + string + ")");
        return false;
    }

    @Override
    public boolean setNebelform(String string) throws SQLException {
        if ("".equals(string) || this.dao.getNebelformen("").contains(string)) {
            return super.setNebelform(string);
        }
        this.logging.warn("Der Wert entspricht nicht dem geforderten Datentyp: setNebelform(" + string + ")");
        return false;
    }

    @Override
    public boolean setNotiz(String string) {
        if (string != null && string.endsWith(".txt")) {
            return super.setNotiz(string.substring(0, string.length() - 4));
        }
        return super.setNotiz(string);
    }

    @Override
    public boolean setEntdeckungsdatum(String string) {
        if ("".equals(string)) {
            return super.setEntdeckungsdatum(string);
        }
        try {
            if (string.length() == 8 || string.length() == 10) {
                String string2 = string.substring(0, 2);
                Integer.parseInt(string2);
                String string3 = string.substring(3, 5);
                Integer.parseInt(string3);
                Object object = string.substring(6, string.length());
                if (((String)object).length() == 2) {
                    object = "20" + (String)object;
                }
                Integer.parseInt((String)object);
                return super.setEntdeckungsdatum(string2 + "." + string3 + "." + (String)object);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.logging.error("Der Wert entspricht nicht dem geforderten Datentyp: setEntdeckungsdatum(" + string + ")", numberFormatException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.logging.error("Der Wert entspricht nicht dem geforderten Datentyp: setEntdeckungsdatum(" + string + ")", indexOutOfBoundsException);
        }
        this.logging.warn("Der Wert entspricht nicht dem geforderten Datentyp: setEntdeckungsdatum(" + string + ")");
        return false;
    }

    @Override
    public boolean setBV(double d) {
        if (d > -10.0 && d < 10.0 || d == -100.0) {
            return super.setBV(d);
        }
        this.logging.warn("Der Wert entspricht nicht dem geforderten Datentyp: setB-V(" + d + ")");
        return false;
    }

    @Override
    public boolean setMetallizitaet(double d) {
        if (d > -6.0 && d < 4.0 || d == -100.0) {
            return super.setMetallizitaet(d);
        }
        this.logging.warn("Der Wert entspricht nicht dem geforderten Datentyp: setMetallizitaet(" + d + ")");
        return false;
    }

    @Override
    public boolean setEntfernung(double d) {
        double d2 = 0.0;
        if (this.getCategory() == ObjektKategorie.STERNE) {
            d2 = 3.0;
        }
        if (d == 0.0 || d >= d2) {
            return super.setEntfernung(d);
        }
        this.logging.warn("Der Wert entspricht nicht dem geforderten Datentyp: setEntfernung(" + d + ")");
        return false;
    }

    @Override
    public boolean setDurchmesser(double d) {
        if (d >= 0.0) {
            return super.setDurchmesser(d);
        }
        this.logging.warn("Der Wert entspricht nicht dem geforderten Datentyp: setDurchmesser(" + d + ")");
        return false;
    }

    @Override
    public boolean setGalaxienDurchmesserInLy(double d) {
        if (d >= 0.0) {
            return super.setGalaxienDurchmesserInLy(d);
        }
        this.logging.warn("Der Wert entspricht nicht dem geforderten Datentyp: setDurchmesser2(" + d + ")");
        return false;
    }

    @Override
    public boolean setMasse(double d) {
        if (d >= 0.0) {
            return super.setMasse(d);
        }
        this.logging.warn("Der Wert entspricht nicht dem geforderten Datentyp: setMasse(" + d + ")");
        return false;
    }

    @Override
    public boolean setUmlaufszeit(double d) {
        if (d >= 0.0) {
            return super.setUmlaufszeit(d);
        }
        this.logging.warn("Der Wert entspricht nicht dem geforderten Datentyp: setUmlaufszeit(" + d + ")");
        return false;
    }

    @Override
    public boolean setExzentritaet(double d) {
        if (d >= 0.0 && d < 2.0) {
            return super.setExzentritaet(d);
        }
        this.logging.warn("Der Wert entspricht nicht dem geforderten Datentyp: setExzentritaet(" + d + ")");
        return false;
    }

    @Override
    public boolean setTemperatur(double d) {
        if (d >= -273.15) {
            if (ObjektKategorie.STERNE.getKategorienName().equals(super.getKategorie())) {
                if (d > 1200.0 || d == -273.15) {
                    return super.setTemperatur(d);
                }
                this.logging.warn("Der Wert entspricht nicht dem geforderten Datentyp: fuer Sterne>2000Kelvin, aber Wert=" + d);
            }
            return super.setTemperatur(d);
        }
        this.logging.warn("Der Wert entspricht nicht dem geforderten Datentyp: setTemperatur(" + d + ")");
        return false;
    }

    @Override
    public boolean setAlbedo(double d) {
        if (d >= 0.0 && d < 1.0) {
            return super.setAlbedo(d);
        }
        this.logging.warn("Der Wert entspricht nicht dem geforderten Datentyp: setAlbedo(" + d + ")");
        return false;
    }

    @Override
    public boolean setGeschwindigkeit(double d) {
        if (super.getGeschwindigkeit() != d) {
            return super.setGeschwindigkeit(d);
        }
        return true;
    }

    @Override
    public boolean setScheinbareHelligkeit(double d) {
        if (d > -30.0 && d < 50.0 || d == -100.0) {
            return super.setScheinbareHelligkeit(d);
        }
        this.logging.warn("Der Wert entspricht nicht dem geforderten Datentyp: setSH(" + d + ")");
        return false;
    }

    @Override
    public boolean setAbsoluteHelligkeit(double d) {
        if (d > -40.0 && d < 50.0 || d == -100.0) {
            return super.setAbsoluteHelligkeit(d);
        }
        this.logging.warn("Der Wert entspricht nicht dem geforderten Datentyp: setAH(" + d + ")");
        return false;
    }

    @Override
    public boolean setFlaechenhelligkeit(double d) {
        if (d == -100.0 || d > 4.0 && d < 50.0) {
            return super.setFlaechenhelligkeit(d);
        }
        this.logging.warn("Der Wert entspricht nicht dem geforderten Datentyp: setFlaechenhelligkeit(" + d + ")");
        return false;
    }

    @Override
    public boolean setRA(double d) {
        if (d >= 0.0 && d < 24.0) {
            return super.setRA(d);
        }
        this.logging.warn("Der Wert entspricht nicht dem geforderten Datentyp: setRA(" + d + ")");
        return false;
    }

    @Override
    public boolean setDECL(double d) {
        if (d > -90.0 && d < 90.0) {
            return super.setDECL(d);
        }
        this.logging.warn("Der Wert entspricht nicht dem geforderten Datentyp: setDECL(" + d + ")");
        return false;
    }

    @Override
    public boolean setSpektralklasse(String string) throws SQLException {
        if (Check.isEmpty(string) || "unbekannt".equals(string) || "unknown".equals(string)) {
            return super.setSpektralklasse("unbekannt");
        }
        String string2 = string.trim();
        if (this.dao.getSpektraltypen("").contains(string2)) {
            return super.setSpektralklasse(string2);
        }
        this.logging.warn("Der Wert entspricht nicht dem geforderten Datentyp: setSpektralklasse(" + string2 + ")");
        return false;
    }

    @Override
    public boolean setSpektralklasse2(double d) throws SQLException {
        if (this.dao.getSpektraltypen2(true).contains(d)) {
            return super.setSpektralklasse2(d);
        }
        this.logging.warn("Der Wert entspricht nicht dem geforderten Datentyp: setSpektralklasse2(" + d + ")");
        return false;
    }

    @Override
    public boolean setLeuchtkraftklasse(String string) throws SQLException {
        String string2 = string.trim();
        if ("".equals(string2) || "unbekannt".equals(string2) || "unknown".equals(string2)) {
            return super.setLeuchtkraftklasse("unbekannt");
        }
        List<String> list = this.dao.getLeuchtkraftklassen();
        if (list.contains(string2)) {
            return super.setLeuchtkraftklasse(string2);
        }
        if ((string2.toLowerCase().endsWith("a") || string2.toLowerCase().endsWith("b")) && list.contains(string2.substring(0, string2.length() - 1))) {
            super.setLeuchtkraftklasse(string2.substring(0, string2.length() - 1));
            this.logging.warn("Leuchtkraftklasse '" + string2 + "' in '" + this.getLeuchtkraftklasse() + "' korrigiert.");
            return true;
        }
        this.logging.warn("Der Wert entspricht nicht dem geforderten Datentyp: setLeuchtkraftklasse(" + string2 + ")");
        return false;
    }

    @Override
    public boolean setUmkreistObjekt(String string) throws SQLException {
        if ("".equals(string)) {
            return super.setUmkreistObjekt(string);
        }
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(string);
        if (this.dao.isObjektInDatenbank(arrayList) > 0) {
            return super.setUmkreistObjekt(string);
        }
        this.logging.debug("objekt " + string + " ist nicht in der DB gespeichert");
        this.logging.warn("Der Wert entspricht nicht dem geforderten Datentyp: setUmkreistObjekt(" + string + ")");
        return false;
    }

    @Override
    public boolean setUmkreistDatenId(Integer n) throws SQLException {
        if (n == null) {
            return super.setUmkreistDatenId(n);
        }
        if (this.dao.isObjectInDB(n)) {
            return super.setUmkreistDatenId(n);
        }
        this.logging.debug("objekt mit id " + n + " ist nicht in der DB gespeichert");
        this.logging.warn("Der Wert entspricht nicht dem geforderten Datentyp: setUmkreistDatenId(" + n + ")");
        return false;
    }

    @Override
    @Deprecated
    public boolean setKategorie(String string) throws SQLException {
        if (this.dao.getKategorien().contains(string)) {
            return super.setKategorie(string);
        }
        this.logging.warn("Der Wert entspricht nicht dem geforderten Datentyp: setKategorie(" + string + ")");
        return false;
    }

    @Override
    public boolean setObjekttyp(String string) throws SQLException {
        if (!"".equals(string) && this.dao.getObjekttypen("").contains(string)) {
            return super.setObjekttyp(string);
        }
        this.logging.warn("Der Wert entspricht nicht dem geforderten Datentyp: setObjekttyp(" + string + ")");
        return false;
    }

    @Override
    public boolean setEntdeckungsmethode(String string) throws SQLException {
        if ("".equals(string) || this.dao.getEntdeckungsmethoden().contains(string)) {
            return super.setEntdeckungsmethode(string);
        }
        this.logging.warn("Der Wert entspricht nicht dem geforderten Datentyp: setEntdeckungsmethode(" + string + ")");
        return false;
    }

    @Override
    public boolean setObjektNamen(Set<String> set) {
        if (set == null || set.isEmpty()) {
            this.logging.warn("Der Wert entspricht nicht dem geforderten Datentyp: keine Namen angegeben!");
            return false;
        }
        if (this.getObjektNamen().isEmpty()) {
            return super.setObjektNamen(set);
        }
        if (set.size() == this.getObjektNamen().size()) {
            for (String string : this.getObjektNamen()) {
                if (set.contains(string)) continue;
                return super.setObjektNamen(set);
            }
        } else {
            return super.setObjektNamen(set);
        }
        return true;
    }

    @Override
    public boolean setSternbildCode(String string) {
        if (string != null && string.trim().length() == 3) {
            return super.setSternbildCode(string);
        }
        return false;
    }

    public void setDatenVonDto(IPlanetensucheObjekt iPlanetensucheObjekt) throws SQLException {
        this.setAbsoluteHelligkeit(iPlanetensucheObjekt.getAbsoluteHelligkeit());
        this.setAlbedo(iPlanetensucheObjekt.getAlbedo());
        this.setAlterInMrdJahre(iPlanetensucheObjekt.getAlterInMrdJahre());
        this.setAutor(iPlanetensucheObjekt.getAutor());
        this.setBV(iPlanetensucheObjekt.getBV());
        this.setBilder(iPlanetensucheObjekt.getBilder());
        this.setDECL(iPlanetensucheObjekt.getDECL());
        this.setDatenid(iPlanetensucheObjekt.getDatenid());
        this.setDurchmesser(iPlanetensucheObjekt.getDurchmesser());
        this.setEntdeckerMitNachnamenFachgebiete(iPlanetensucheObjekt.getEntdeckerMitNachnamenFachgebiete());
        this.setEntdeckerMitNachnamenVornamen(iPlanetensucheObjekt.getEntdeckerMitNachnamenVornamen());
        this.setEntdeckungsdatum(iPlanetensucheObjekt.getEntdeckungsdatum());
        this.setEntdeckungsmethode(iPlanetensucheObjekt.getEntdeckungsmethode());
        this.setEntdeckungBestaetigt(iPlanetensucheObjekt.isEntdeckungBestaetigt());
        this.setEntfernung(iPlanetensucheObjekt.getEntfernung());
        this.setExzentritaet(iPlanetensucheObjekt.getExzentritaet());
        this.setFlaechenhelligkeit(iPlanetensucheObjekt.getFlaechenhelligkeit());
        this.setGalaxienDurchmesserInLy(iPlanetensucheObjekt.getGalaxienDurchmesserInLy());
        this.setGalaxienart(iPlanetensucheObjekt.getGalaxienart());
        this.setGalaxienform(iPlanetensucheObjekt.getGalaxienform());
        this.setGeschwindigkeit(iPlanetensucheObjekt.getGeschwindigkeit());
        if (!iPlanetensucheObjekt.isGaiaAstroExNoiseSigUnbekannt()) {
            this.setGaiaAstroExNoiseSig(iPlanetensucheObjekt.getGaiaAstroExNoiseSig());
        }
        this.setGaiaNonSingle(iPlanetensucheObjekt.getGaiaNonSingle());
        if (!iPlanetensucheObjekt.isGaiaRuweUnbekannt()) {
            this.setGaiaRuwe(iPlanetensucheObjekt.getGaiaRuwe());
        }
        if (!iPlanetensucheObjekt.isGaiaRvErrorUnbekannt()) {
            this.setGaiaRvError(iPlanetensucheObjekt.getGaiaRvError());
        }
        this.setCategory(iPlanetensucheObjekt.getCategory());
        this.setLeuchtkraftklasse(iPlanetensucheObjekt.getLeuchtkraftklasse());
        this.setMasse(iPlanetensucheObjekt.getMasse());
        this.setMetallizitaet(iPlanetensucheObjekt.getMetallizitaet());
        this.setNebelform(iPlanetensucheObjekt.getNebelform());
        this.setNotiz(iPlanetensucheObjekt.getNotiz());
        this.setObjektNamen(new HashSet<String>(iPlanetensucheObjekt.getObjektNamen()));
        this.setObjekttyp(iPlanetensucheObjekt.getObjekttyp());
        this.setRA(iPlanetensucheObjekt.getRA());
        this.setRotverschiebung(iPlanetensucheObjekt.getRotverschiebung());
        this.setScheinbareHelligkeit(iPlanetensucheObjekt.getScheinbareHelligkeit());
        this.setSpektralklasse(iPlanetensucheObjekt.getSpektralklasse());
        this.setSpektralklasse2(iPlanetensucheObjekt.getSpektralklasse2());
        this.setStamp(iPlanetensucheObjekt.getStamp());
        this.setSternbildCode(iPlanetensucheObjekt.getSternbildCode());
        this.setSternbildDTBezeichnung(iPlanetensucheObjekt.getSternbildDTBezeichnung());
        this.setSternbildENGBezeichnung(iPlanetensucheObjekt.getSternbildENGBezeichnung());
        this.setSternbildLATBezeichnung(iPlanetensucheObjekt.getSternbildLATBezeichnung());
        this.setSternentstehung(iPlanetensucheObjekt.getSternentstehung());
        this.setSternhaufenform(iPlanetensucheObjekt.getSternhaufenform());
        this.setTemperatur(iPlanetensucheObjekt.getTemperatur());
        this.setUmkreistObjekt(iPlanetensucheObjekt.getUmkreistObjekt());
        this.setUmkreistDatenId(iPlanetensucheObjekt.getUmkreistDatenId());
        this.setUmlaufszeit(iPlanetensucheObjekt.getUmlaufszeit());
        this.setWirdUmkreistVon(iPlanetensucheObjekt.getWirdUmkreistVonNamen());
        this.setWirdUmkreistVonIDs(iPlanetensucheObjekt.getWirdUmkreistVonIDs());
        this.nichtMehrGeaendert();
    }
}

