/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.guidesigner.components.search;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class AutoCompleteJComboBoxer
extends PlainDocument {
    private final JComboBox<String> comboBox;
    private final ComboBoxModel<String> model;
    private JTextComponent editor;

    public AutoCompleteJComboBoxer(JComboBox<String> jComboBox) {
        this.comboBox = jComboBox;
        jComboBox.setEditable(true);
        this.model = jComboBox.getModel();
        this.editor = (JTextComponent)jComboBox.getEditor().getEditorComponent();
        this.editor.setDocument(this);
        this.editor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                AutoCompleteJComboBoxer.this.highlightCompletedText(0);
            }
        });
        this.editor.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    AutoCompleteJComboBoxer.this.highlightCompletedText(0);
                } else if (keyEvent.getKeyCode() == 27) {
                    AutoCompleteJComboBoxer.this.comboBox.setSelectedIndex(0);
                    AutoCompleteJComboBoxer.this.editor.setText(AutoCompleteJComboBoxer.this.comboBox.getSelectedItem().toString());
                    AutoCompleteJComboBoxer.this.highlightCompletedText(0);
                }
            }
        });
        Object object = jComboBox.getSelectedItem();
        if (object != null) {
            this.editor.setText(object.toString());
        }
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        String string2;
        int n2 = n;
        String string3 = this.getText(0, this.getLength());
        String string4 = string3.substring(0, n2);
        String string5 = string4 + string + (string2 = string3.substring(n2, string3.length()));
        Object object = this.lookupItem(string5);
        if (object != null) {
            this.comboBox.setSelectedItem(object);
        } else {
            object = this.comboBox.getSelectedItem();
            n2 -= string.length();
            this.comboBox.getToolkit().beep();
        }
        super.remove(0, this.getLength());
        super.insertString(0, object.toString(), attributeSet);
        if (object.toString().equals(string) && n2 == 0) {
            this.highlightCompletedText(0);
        } else {
            this.highlightCompletedText(n2 + string.length());
            if (this.comboBox.isShowing()) {
                this.comboBox.setPopupVisible(true);
            }
        }
    }

    private void highlightCompletedText(int n) {
        this.editor.setCaretPosition(this.getLength());
        this.editor.moveCaretPosition(n);
    }

    private Object lookupItem(String string) {
        Object object = this.model.getSelectedItem();
        if (object != null && this.startsWithIgnoreCase(object.toString(), string)) {
            return object;
        }
        if (string != null) {
            for (int i = 0; i <= this.model.getSize(); ++i) {
                String string2 = (String)this.model.getElementAt(i);
                if (string2 == null || !this.startsWithIgnoreCase(string2, string)) continue;
                return string2;
            }
        }
        return null;
    }

    private boolean startsWithIgnoreCase(String string, String string2) {
        return string.toUpperCase().startsWith(string2.toUpperCase());
    }
}

