/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.guidesigner.eventbus;

import de.planetensuche.guidesigner.eventbus.Subscriber;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class EventBus<T> {
    private final Map<T, List<Subscriber<T>>> listener = new HashMap<T, List<Subscriber<T>>>();

    public void publish(T t, Object object) {
        List<Subscriber<T>> list = this.listener.get(t);
        if (list != null) {
            for (Subscriber<T> subscriber : list) {
                subscriber.onEvent(t, object);
            }
        }
    }

    public void subscribe(T t, Subscriber<T> subscriber) {
        List<Subscriber<T>> list = this.listener.get(t);
        if (list == null) {
            list = new ArrayList<Subscriber<T>>();
        }
        list.add(subscriber);
        this.listener.put(t, list);
    }

    public void unsubscribe(T t, Subscriber<T> subscriber) {
        List<Subscriber<T>> list = this.listener.get(t);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Subscriber<T> subscriber2 = list.get(i);
                if (subscriber2.getSubscriberId() != subscriber.getSubscriberId()) continue;
                list.remove(i);
                return;
            }
        }
    }
}

