/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.guidesigner.statusfenster;

import de.planetensuche.guidesigner.statusfenster.StatusGui;
import de.planetensuche.guidesigner.statusfenster.Statustask;
import de.planetensuche.guidesigner.statusfenster.WaitDialogFx;
import java.awt.Cursor;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JFrame;

public class Statusthread
extends Thread {
    private StatusGui statusGui;
    private Timer timer;
    private final JFrame dialog;
    private WaitDialogFx waitDialogFx;
    private final int timeoutInMs;

    Statusthread(JFrame jFrame, String string) {
        this.dialog = jFrame;
        this.timeoutInMs = 20000;
    }

    Statusthread(JFrame jFrame, String string, int n) {
        this.dialog = jFrame;
        this.timeoutInMs = n;
    }

    public void setProgress(int n) {
        if (this.waitDialogFx != null) {
            this.waitDialogFx.setProgress(n);
        }
    }

    public int getProgress() {
        return this.waitDialogFx != null ? this.waitDialogFx.getProgress() : -1;
    }

    @Override
    public synchronized void run() {
        if (this.dialog == null) {
            this.statusGui = new StatusGui();
            this.statusGui.setVisible(true);
            this.statusGui.setCursor(new Cursor(3));
            if (this.timer != null) {
                this.timer.cancel();
                this.timer.purge();
            }
            this.timer = new Timer();
            try {
                this.timer.schedule((TimerTask)new Statustask(this.statusGui), 100L, 500L);
            }
            catch (IllegalStateException illegalStateException) {
                this.timer.cancel();
                this.timer = null;
            }
        } else {
            this.waitDialogFx = new WaitDialogFx();
            this.dialog.setGlassPane(this.waitDialogFx);
            this.waitDialogFx.setVisible(true);
            this.dialog.setCursor(new Cursor(3));
            this.timer = new Timer();
            try {
                this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        Statusthread.this.closeGUI();
                    }
                }, this.timeoutInMs);
            }
            catch (IllegalStateException illegalStateException) {
                this.timer.cancel();
                this.timer = null;
            }
        }
    }

    synchronized void closeGUI() {
        if (this.dialog == null) {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer.purge();
                this.timer = null;
            }
            if (this.statusGui != null) {
                this.statusGui.setCursor(new Cursor(0));
                this.statusGui.setVisible(false);
                this.statusGui.dispose();
                this.statusGui = null;
            }
        } else {
            this.dialog.setCursor(new Cursor(0));
            if (this.timer != null) {
                this.timer.cancel();
                this.timer.purge();
                this.timer = null;
            }
            if (this.waitDialogFx != null) {
                this.waitDialogFx.setVisible(false);
                this.waitDialogFx = null;
            }
        }
        this.interrupt();
    }
}

