/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.konfigurator.impl;

import com.google.common.io.Files;
import de.planetensuche.datamodel.api.IKoordinate;
import de.planetensuche.datamodel.api.KoordinatenFormat;
import de.planetensuche.datamodel.impl.Koordinate;
import de.planetensuche.konfigurator.api.HauptkonfigurationDaten;
import de.planetensuche.konfigurator.api.IHauptkonfiguration;
import de.planetensuche.konfigurator.helfer.DateiSchreiber;
import de.planetensuche.konfigurator.helfer.KoordinatenUmwandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;

@Deprecated
public final class Hauptkonfiguration
implements IHauptkonfiguration {
    private static final String PLANETENSUCHE_CONF = "conf" + File.separator + "planetensuche.conf";
    private File planetensucheConfig;
    private HauptkonfigurationDaten daten;

    protected Hauptkonfiguration() {
        this.erzeugeMinimalhauptkonfiguration();
        this.planetensucheConfig = new File(PLANETENSUCHE_CONF);
    }

    private void erzeugeMinimalhauptkonfiguration() {
        this.daten = new HauptkonfigurationDaten();
        this.daten.setLand("Deutschland");
        this.daten.setSchriftgroesseInPixel(12);
        this.daten.setXmxInMB(512);
        this.daten.setFilmFensterAktiv(true);
        this.daten.setIntroAktiv(true);
        this.daten.setKoordinatenFormat(KoordinatenFormat.STUNDEN_DEZIMAL);
    }

    protected Hauptkonfiguration(File file) {
        if (file == null) {
            throw new IllegalArgumentException("config file is null!");
        }
        this.planetensucheConfig = file;
        this.erzeugeMinimalhauptkonfiguration();
    }

    @Override
    public HauptkonfigurationDaten getDaten() {
        return this.daten;
    }

    @Override
    public void setDaten(HauptkonfigurationDaten hauptkonfigurationDaten) {
        this.daten = hauptkonfigurationDaten;
    }

    public boolean existsPlanetensucheConf() {
        return this.planetensucheConfig.exists();
    }

    @Override
    public void lesen() throws IOException {
        if (!this.planetensucheConfig.exists()) {
            throw new FileNotFoundException(this.planetensucheConfig.getName() + " not found!");
        }
        List<String> list = Files.readLines(this.planetensucheConfig, Charset.forName("UTF-8"));
        for (String string : list) {
            String[] stringArray = string.split("=");
            if (stringArray.length != 2 || stringArray[1].isEmpty()) continue;
            this.setzeEinstellungen(stringArray);
        }
    }

    private void setzeEinstellungen(String[] stringArray) {
        if ("version".equals(stringArray[0])) {
            this.daten.setVersion(stringArray[1]);
        } else if ("zulaktu".equals(stringArray[0])) {
            this.daten.setZuletztAktualisiert(stringArray[1]);
        } else if ("sprache".equals(stringArray[0])) {
            this.daten.setProgrammsprache(stringArray[1]);
        } else if ("updates".equals(stringArray[0])) {
            this.daten.setUpdatesSuchen(Boolean.parseBoolean(stringArray[1]));
        } else if ("brpfad".equals(stringArray[0])) {
            this.daten.setBrowserpfad(stringArray[1]);
        } else if ("zz".equals(stringArray[0])) {
            this.daten.setZeitzone(stringArray[1]);
        } else if ("land".equals(stringArray[0])) {
            this.daten.setLand(stringArray[1]);
        } else if ("ort".equals(stringArray[0])) {
            this.daten.setOrt(stringArray[1]);
        } else if ("koordinate".equals(stringArray[0])) {
            IKoordinate iKoordinate = KoordinatenUmwandler.parseKoordinate(stringArray[1]);
            this.daten.setKoordinate(iKoordinate);
        } else if ("gl".equals(stringArray[0])) {
            int n = stringArray[1].indexOf(44);
            int n2 = stringArray[1].indexOf(40);
            this.daten.setLand(stringArray[1].substring(0, n));
            this.daten.setOrt(stringArray[1].substring(n + 2, n2 - 1));
            this.daten.setKoordinate(KoordinatenUmwandler.parseKoordinateFromOldFormat(stringArray[1]));
        } else if ("error".equals(stringArray[0])) {
            this.daten.setLogFileKb((int)Double.parseDouble(stringArray[1]));
        } else if ("runden".equals(stringArray[0])) {
            this.daten.setRunden(Boolean.parseBoolean(stringArray[1]));
        } else if ("schriftgroesse".equals(stringArray[0])) {
            this.daten.setSchriftgroesseInPixel(Integer.parseInt(stringArray[1]));
        } else if ("xmx".equals(stringArray[0])) {
            this.daten.setXmxInMB((int)Double.parseDouble(stringArray[1]));
        } else if ("film".equals(stringArray[0])) {
            this.daten.setFilmFensterAktiv(Boolean.parseBoolean(stringArray[1]));
        } else if ("intro".equals(stringArray[0])) {
            this.daten.setIntroAktiv(Boolean.parseBoolean(stringArray[1]));
        } else if ("koordinatenformat".equals(stringArray[0])) {
            this.daten.setKoordinatenFormat(KoordinatenFormat.valueOf(stringArray[1]));
        }
    }

    @Override
    public void schreiben() throws IOException {
        if (this.daten.isVersionNichtGesetzt() || this.daten.isZuletztAktualisiertNichtGesetzt() || this.daten.isProgrammspracheNichtGesetzt()) {
            throw new UnsupportedOperationException("an uncomplete configuration can't be saved");
        }
        DateiSchreiber dateiSchreiber = new DateiSchreiber(this.planetensucheConfig);
        dateiSchreiber.verketteUndSchreibeZeile("version", this.daten.getVersion());
        dateiSchreiber.verketteUndSchreibeZeile("zulaktu", this.daten.getZuletztAktualisiert());
        dateiSchreiber.verketteUndSchreibeZeile("sprache", this.daten.getProgrammsprache());
        dateiSchreiber.verketteUndSchreibeZeile("updates", Boolean.toString(this.daten.isUpdatesSuchen()));
        dateiSchreiber.verketteUndSchreibeZeile("brpfad", this.daten.getBrowserpfad());
        dateiSchreiber.verketteUndSchreibeZeile("zz", this.daten.getZeitzone());
        dateiSchreiber.verketteUndSchreibeZeile("land", this.daten.getLand());
        dateiSchreiber.verketteUndSchreibeZeile("ort", this.daten.getOrt());
        if (this.daten.getKoordinate() != null) {
            dateiSchreiber.verketteUndSchreibeZeile("koordinate", KoordinatenUmwandler.toString(this.daten.getKoordinate()));
        }
        dateiSchreiber.verketteUndSchreibeZeile("error", Integer.toString(this.daten.getLogFileKb()));
        dateiSchreiber.verketteUndSchreibeZeile("runden", Boolean.toString(this.daten.isRunden()));
        dateiSchreiber.verketteUndSchreibeZeile("schriftgroesse", Integer.toString(this.daten.getSchriftgroesseInPixel()));
        dateiSchreiber.verketteUndSchreibeZeile("xmx", Integer.toString(this.daten.getXmxInMB()));
        dateiSchreiber.verketteUndSchreibeZeile("film", Boolean.toString(this.daten.isFilmFensterAktiv()));
        dateiSchreiber.verketteUndSchreibeZeile("intro", Boolean.toString(this.daten.isIntroAktiv()));
        dateiSchreiber.verketteUndSchreibeZeile("koordinatenformat", this.daten.getKoordinatenFormat().name());
        dateiSchreiber.schliessen();
    }

    @Override
    public void ladeStandardKonfiguration() {
        this.daten.setBrowserpfad("null");
        this.daten.setLand("Deutschland");
        this.daten.setOrt("Goerlitz");
        this.daten.setKoordinate(new Koordinate(14, 59, 0.0));
        this.daten.setLogFileKb(64);
        this.daten.setProgrammsprache("deutsch");
        this.daten.setSchriftgroesseInPixel(12);
        this.daten.setUpdatesSuchen(true);
        this.daten.setVersion("4.3.3");
        this.daten.setZeitzone("GMT +01:00h");
        this.daten.setZuletztAktualisiert("29.09.2010");
        this.daten.setXmxInMB(512);
        this.daten.setIntroAktiv(true);
        this.daten.setFilmFensterAktiv(true);
        this.daten.setKoordinatenFormat(KoordinatenFormat.STUNDEN_DEZIMAL);
    }

    public boolean existsPlanetensucheNew() {
        File file = new File("planetensuche.new");
        return file.exists();
    }

    @Override
    public void aktualisiereKonfigDateiMitNewDatei() throws IOException {
        File file = new File("planetensuche.new");
        if (!file.exists()) {
            throw new FileNotFoundException(file.getName() + " don't exists");
        }
        this.planetensucheConfig = file;
        this.lesen();
        String string = this.daten.getVersion();
        String string2 = this.daten.getZuletztAktualisiert();
        this.planetensucheConfig = new File(PLANETENSUCHE_CONF);
        this.lesen();
        this.daten.setVersion(string);
        this.daten.setZuletztAktualisiert(string2);
        this.schreiben();
        if (!file.delete()) {
            file.deleteOnExit();
        }
    }
}

