/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.updater;

import de.planetensuche.bugreport.main.BugreportDialog;
import de.planetensuche.core.JavaVersionHelperUtil;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.errorlogger.api.Modulnummer;
import de.planetensuche.guidesigner.GuiDesignerFabrik;
import de.planetensuche.konfigurator.api.IKonfigurator;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import de.planetensuche.konfigurator.impl.KonfiguratorFabrik;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import de.planetensuche.updater.UpdateGui;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JOptionPane;

public final class Start {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForModule(Modulnummer.UPDATE);
    private final String planetensucheVersion;
    private final boolean testModus;
    private final boolean updateFortsetzen;

    private Start(String string, boolean bl, boolean bl2) throws IOException {
        this.planetensucheVersion = string;
        this.testModus = bl;
        this.updateFortsetzen = bl2;
        if (!LOGGER.isBereit()) {
            JOptionPane.showMessageDialog(null, "Fehler beim Erstellen der Logdatei 'update.log'!\nCan't create the logfile 'update.log'!", "Schwerer Fehler / Fatal Error", 0);
            System.exit(0);
        }
        IKonfigurator iKonfigurator = KonfiguratorFabrik.getKonfigurator();
        KonfigurationDTO konfigurationDTO = iKonfigurator.read();
        LoggingFactory.addBugreport(new BugreportDialog(konfigurationDTO));
        LOGGER.info("Update-Prozess gestartet mit Planetensuche Version " + string + " im Testmodus " + bl + " ...");
    }

    private void showUpdateDialog() throws IOException {
        try {
            IKonfigurator iKonfigurator = KonfiguratorFabrik.getKonfigurator();
            KonfigurationDTO konfigurationDTO = iKonfigurator.read();
            GuiDesignerFabrik.init(konfigurationDTO.getSchriftgroesseInPixel());
            LOGGER.setLogdateigroesseInKB(konfigurationDTO.getLogFileInKb());
            String string = this.planetensucheVersion;
            if (string == null) {
                string = konfigurationDTO.getVersion();
            }
            ISprachcontainer iSprachcontainer = SprachcontainerFabrik.getSprachcontainer();
            int n = konfigurationDTO.getXmxInMB();
            if (n < 2560) {
                n = 2560;
            }
            UpdateGui updateGui = new UpdateGui(iSprachcontainer, string, this.testModus, n, this.updateFortsetzen, konfigurationDTO);
            updateGui.setVisible(true);
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(null, "Bitte installieren Sie das Programm zuerst!\nPlease install Planetensuche before use!", "Planetensuche ist nicht installiert", 0);
            Runtime.getRuntime().exec(JavaVersionHelperUtil.getCurrentJavaPath() + " -Xmx2560m -XX:+UseStringDeduplication -jar planetensuche.jar");
        }
    }

    public static void main(String[] stringArray) throws IOException {
        String string = "5.12";
        boolean bl = false;
        boolean bl2 = false;
        if (stringArray != null) {
            string = stringArray[0].trim();
            if (stringArray.length == 2 && "-test".equals(stringArray[1])) {
                LOGGER.info("parameter test detected");
                bl = true;
            } else if (stringArray.length == 2 && "-update".equals(stringArray[1])) {
                LOGGER.info("parameter updateFortsetzen detected");
                bl2 = true;
            } else {
                LOGGER.info("no other parameter detected");
            }
        } else {
            LOGGER.warn("update started without parameter");
        }
        Start start = new Start(string, bl, bl2);
        start.showUpdateDialog();
    }
}

