/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.updater.jre;

import de.planetensuche.core.JavaVersionHelperUtil;
import de.planetensuche.dateihelfer.ScriptWriter;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.updater.IUpdateDialog;
import de.planetensuche.updater.jre.JreDownloadService;
import de.planetensuche.updater.jre.JreUpdateDto;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FileUtils;

public class JreUpdateService {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(JreUpdateService.class);
    private final JreDownloadService downloadService;
    private final KonfigurationDTO configuration;
    private final IUpdateDialog gui;
    private final ISprachcontainer i18n;

    public JreUpdateService(KonfigurationDTO konfigurationDTO, IUpdateDialog iUpdateDialog, ISprachcontainer iSprachcontainer) {
        this.configuration = konfigurationDTO;
        this.gui = iUpdateDialog;
        this.i18n = iSprachcontainer;
        this.downloadService = new JreDownloadService(konfigurationDTO, iUpdateDialog, iSprachcontainer);
    }

    public void searchAndInstallUpdates(int n) {
        try {
            Optional<JreUpdateDto> optional = this.foundNewestUpdateForOs(n);
            if (optional.isEmpty()) {
                LOGGER.info("no JRE updates found");
                this.gui.appendOutput(this.i18n.getString("up_m38"));
                return;
            }
            JreUpdateDto jreUpdateDto = optional.get();
            LOGGER.info("use this jre update: " + String.valueOf(jreUpdateDto));
            String string = jreUpdateDto.getJreMajorVersion() + ".0." + jreUpdateDto.getJreMinorVersion();
            this.gui.appendOutput(this.i18n.getString("up_m31", string));
            File file = this.downloadService.downloadSource(jreUpdateDto);
            if (file.exists()) {
                File file2 = this.extractArchive(file, jreUpdateDto);
                this.gui.appendOutput(this.i18n.getString("up_m22"));
                this.copyExtractedArchiveToTarget(file2, jreUpdateDto);
                this.gui.appendOutput(this.i18n.getString("up_m34"));
                this.writeScribtsWithNewJre();
                this.gui.appendOutput(this.i18n.getString("up_m35"));
            } else {
                LOGGER.warn("failed to download/save archive " + file.getAbsolutePath());
                this.gui.appendOutput(this.i18n.getString("up_m33"));
            }
        }
        catch (UnknownHostException unknownHostException) {
            String string = this.i18n.getString("up_m39") + "\n" + unknownHostException.getLocalizedMessage();
            JOptionPane.showMessageDialog(this.gui.getDialog(), string, this.i18n.getString("up_m8"), 0);
        }
        catch (IOException | RuntimeException exception) {
            String string = exception.getLocalizedMessage() != null ? exception.getLocalizedMessage() : exception.getMessage();
            this.gui.appendOutput(this.i18n.getString("up_m28_1") + " " + string);
            LOGGER.error(exception);
        }
    }

    void writeScribtsWithNewJre() throws IOException {
        new ScriptWriter().writeScripts(this.configuration.getXmxInMB(), this.configuration.getVersion());
    }

    Optional<JreUpdateDto> foundNewestUpdateForOs(int n) throws IOException {
        List list = JavaVersionHelperUtil.getInstalledJavaMajorVersion() < n ? this.downloadService.findInstallableUpdates().stream().filter(jreUpdateDto -> this.getInstalledOperatingSystemName().toLowerCase().contains(jreUpdateDto.getRequiredOperatingSystem().toLowerCase())).filter(jreUpdateDto -> jreUpdateDto.getJreMajorVersion() == n).filter(jreUpdateDto -> this.isJreVersionNewer((JreUpdateDto)jreUpdateDto)).sorted((jreUpdateDto, jreUpdateDto2) -> Integer.compare(jreUpdateDto2.getJreMinorVersion(), jreUpdateDto.getJreMinorVersion())).collect(Collectors.toList()) : this.downloadService.findInstallableUpdates().stream().filter(jreUpdateDto -> this.getInstalledOperatingSystemName().toLowerCase().contains(jreUpdateDto.getRequiredOperatingSystem().toLowerCase())).filter(jreUpdateDto -> this.isJreVersionCompatible((JreUpdateDto)jreUpdateDto)).filter(jreUpdateDto -> this.isJreVersionNewer((JreUpdateDto)jreUpdateDto)).sorted((jreUpdateDto, jreUpdateDto2) -> Integer.compare(jreUpdateDto2.getJreMinorVersion(), jreUpdateDto.getJreMinorVersion())).collect(Collectors.toList());
        LOGGER.info("found " + list.size() + " possible JRE updates");
        if (list.isEmpty()) {
            return Optional.empty();
        }
        JreUpdateDto jreUpdateDto3 = (JreUpdateDto)list.get(0);
        LOGGER.info("the newest jre update found was: " + String.valueOf(jreUpdateDto3));
        return Optional.of(jreUpdateDto3);
    }

    File extractArchive(File file, JreUpdateDto jreUpdateDto) throws IOException {
        if (file.getName().endsWith(".tar.gz")) {
            String string;
            try (InputStream inputStream = Files.newInputStream(Paths.get(file.getAbsolutePath(), new String[0]), new OpenOption[0]);
                 BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                 GzipCompressorInputStream gzipCompressorInputStream = new GzipCompressorInputStream(bufferedInputStream);
                 TarArchiveInputStream tarArchiveInputStream = new TarArchiveInputStream(gzipCompressorInputStream);){
                string = this.copyFilesFromArchiveToFolder(tarArchiveInputStream);
            }
            if (string != null) {
                return this.renameExtractedJreFolder(jreUpdateDto, string);
            }
            throw new IllegalStateException("JRE archive corrupt?");
        }
        if (file.getName().endsWith(".zip")) {
            String string;
            try (InputStream inputStream = Files.newInputStream(Paths.get(file.getAbsolutePath(), new String[0]), new OpenOption[0]);
                 BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                 ZipArchiveInputStream zipArchiveInputStream = new ZipArchiveInputStream(bufferedInputStream);){
                string = this.copyFilesFromArchiveToFolder(zipArchiveInputStream);
            }
            if (string != null) {
                return this.renameExtractedJreFolder(jreUpdateDto, string);
            }
            throw new IllegalStateException("JRE archive corrupt?");
        }
        throw new UnsupportedOperationException("unsupported archive file type for file '" + file.getName() + "'");
    }

    private File renameExtractedJreFolder(JreUpdateDto jreUpdateDto, String string) throws FileSystemException {
        File file = new File("temp" + File.separator + string);
        File file2 = new File("temp" + File.separator + this.getJreDirName(jreUpdateDto));
        LOGGER.debug("rename '" + file.getAbsolutePath() + "' to '" + file2.getAbsolutePath() + "'");
        if (file.renameTo(file2)) {
            return file2;
        }
        throw new FileSystemException(file.getAbsolutePath(), file2.getAbsolutePath(), "rename of folder '" + string + "' failed");
    }

    private String copyFilesFromArchiveToFolder(ArchiveInputStream archiveInputStream) throws IOException {
        Object e;
        String string = null;
        long l = 0L;
        while ((e = archiveInputStream.getNextEntry()) != null) {
            if (string == null && e.isDirectory() && (e.getName().startsWith("jdk") || e.getName().startsWith("zulu"))) {
                string = e.getName();
            }
            Path path = new File("temp" + File.separator + e.getName()).toPath();
            if (e.isDirectory()) {
                Files.createDirectories(path, new FileAttribute[0]);
            } else {
                Files.copy(archiveInputStream, path, new CopyOption[0]);
            }
            ++l;
        }
        LOGGER.info("archive extraction done with " + l + " entries and root folder name '" + string + "'");
        if (string != null && string.indexOf(File.separator) > 0) {
            string = string.substring(0, string.indexOf(File.separator));
        }
        return string;
    }

    String getJreDirName(JreUpdateDto jreUpdateDto) {
        return "jre_" + jreUpdateDto.getJreMajorVersion() + "_" + jreUpdateDto.getJreMinorVersion();
    }

    boolean isJreVersionNewer(JreUpdateDto jreUpdateDto) {
        try {
            return JavaVersionHelperUtil.isVersionNewer(jreUpdateDto.getJreMajorVersion(), jreUpdateDto.getJreMinorVersion());
        }
        catch (IOException iOException) {
            LOGGER.error(iOException);
            return false;
        }
    }

    boolean isJreVersionCompatible(JreUpdateDto jreUpdateDto) {
        try {
            return JavaVersionHelperUtil.isVersionCompatible(jreUpdateDto.getJreMajorVersion());
        }
        catch (IOException iOException) {
            LOGGER.error(iOException);
            return false;
        }
    }

    String getInstalledOperatingSystemName() {
        return System.getProperty("os.name");
    }

    File copyExtractedArchiveToTarget(File file, JreUpdateDto jreUpdateDto) throws IOException {
        File file2 = new File("jre_updates");
        if (!file2.exists()) {
            Files.createDirectory(file2.toPath(), new FileAttribute[0]);
        }
        String string = file.getName() + "_" + jreUpdateDto.getRequiredOperatingSystem().toLowerCase();
        File file3 = new File(file2.getAbsolutePath() + File.separator + string);
        FileUtils.copyDirectory(file, file3);
        file3.setReadable(true, false);
        new File(file3.getAbsolutePath() + File.separator + "bin" + File.separator + "java").setExecutable(true, false);
        new File(file3.getAbsolutePath() + File.separator + "bin" + File.separator + "java.exe").setExecutable(true, false);
        JavaVersionHelperUtil.setNewDefaultJre(jreUpdateDto.getJreMajorVersion() + "+" + jreUpdateDto.getJreMinorVersion(), file3.getAbsolutePath());
        return file3;
    }
}

