/*
 * Decompiled with CFR 0.152.
 */
package com.flickr4java.flickr;

import com.flickr4java.flickr.Flickr;
import com.flickr4java.flickr.FlickrException;
import com.flickr4java.flickr.FlickrRuntimeException;
import com.flickr4java.flickr.RESTResponse;
import com.flickr4java.flickr.RequestContext;
import com.flickr4java.flickr.Response;
import com.flickr4java.flickr.Transport;
import com.flickr4java.flickr.auth.Auth;
import com.flickr4java.flickr.uploader.Payload;
import com.flickr4java.flickr.uploader.UploadMetaData;
import com.flickr4java.flickr.util.DebugInputStream;
import com.flickr4java.flickr.util.IOUtilities;
import com.flickr4java.flickr.util.OAuthUtilities;
import com.flickr4java.flickr.util.UrlUtilities;
import com.github.scribejava.core.httpclient.multipart.FileByteArrayBodyPartPayload;
import com.github.scribejava.core.model.OAuth1AccessToken;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Parameter;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuth10aService;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class REST
extends Transport {
    private static final Logger logger = LoggerFactory.getLogger(REST.class);
    private static final String PATH = "/services/rest/";
    private static final String FLICKR_SERVICE_UNAVAILABLE = "105";
    private boolean proxyAuth = false;
    private String proxyUser = "";
    private String proxyPassword = "";
    private String userAgent = "Flickr4Java/3.x";
    private Integer connectTimeoutMs;
    private Integer readTimeoutMs;

    public REST() {
        this.setTransportType("REST");
        this.setHost("api.flickr.com");
        this.setPath(PATH);
        this.setScheme("https");
        this.setResponseClass(RESTResponse.class);
    }

    public REST(String host) {
        this();
        this.setHost(host);
    }

    public REST(String host, int port) {
        this();
        this.setHost(host);
        this.setPort(port);
    }

    public void setProxy(String proxyHost, int proxyPort) {
        System.setProperty("http.proxySet", "true");
        System.setProperty("http.proxyHost", proxyHost);
        System.setProperty("http.proxyPort", "" + proxyPort);
        System.setProperty("https.proxyHost", proxyHost);
        System.setProperty("https.proxyPort", "" + proxyPort);
    }

    public void setProxy(String proxyHost, int proxyPort, String username, String password) {
        this.setProxy(proxyHost, proxyPort);
        this.proxyAuth = true;
        this.proxyUser = username;
        this.proxyPassword = password;
    }

    public REST setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    @Override
    public Response get(String path, Map<String, Object> parameters, String apiKey, String sharedSecret) throws FlickrException {
        OAuthRequest request = new OAuthRequest(Verb.GET, this.buildUrl(path));
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            request.addQuerystringParameter(entry.getKey(), String.valueOf(entry.getValue()));
        }
        if (this.proxyAuth) {
            request.addHeader("Proxy-Authorization", "Basic " + this.getProxyCredentials());
        }
        request.addHeader("User-Agent", this.userAgent);
        RequestContext requestContext = RequestContext.getRequestContext();
        Auth auth = requestContext.getAuth();
        OAuth10aService service = OAuthUtilities.createOAuthService(apiKey, sharedSecret, this.connectTimeoutMs, this.readTimeoutMs);
        if (auth != null) {
            OAuth1AccessToken requestToken = new OAuth1AccessToken(auth.getToken(), auth.getTokenSecret());
            service.signRequest(requestToken, request);
        } else if (!parameters.containsKey("api_key")) {
            request.addQuerystringParameter("api_key", apiKey);
        }
        if (Flickr.debugRequest) {
            logger.debug("GET: " + request.getCompleteUrl());
        }
        try {
            return this.handleResponse(request, service);
        }
        catch (IOException | InterruptedException | ReflectiveOperationException | ExecutionException | ParserConfigurationException | SAXException e) {
            throw new FlickrRuntimeException(e);
        }
    }

    @Override
    public Response post(String path, Map<String, Object> parameters, String apiKey, String sharedSecret) throws FlickrException {
        OAuthRequest request = OAuthUtilities.buildNormalPostRequest(parameters, this.buildUrl(path));
        request.addHeader("User-Agent", this.userAgent);
        OAuth10aService service = this.createAndSignRequest(apiKey, sharedSecret, request);
        try {
            return this.handleResponse(request, service);
        }
        catch (IOException | InterruptedException | ReflectiveOperationException | ExecutionException | ParserConfigurationException | SAXException e) {
            throw new FlickrRuntimeException(e);
        }
    }

    @Override
    public Response postMultiPart(String path, UploadMetaData metaData, Payload payload, String apiKey, String sharedSecret) throws FlickrException {
        HashMap<String, String> uploadParameters = new HashMap<String, String>(metaData.getUploadParameters());
        OAuthRequest request = OAuthUtilities.buildMultipartRequest(uploadParameters, this.buildUrl(path));
        request.addHeader("User-Agent", this.userAgent);
        OAuth10aService service = this.createAndSignRequest(apiKey, sharedSecret, request);
        uploadParameters.putAll(request.getOauthParameters());
        request.addBodyPartPayloadInMultipartPayload(new FileByteArrayBodyPartPayload(payload.getPayload(), "photo", metaData.getFilename()));
        uploadParameters.forEach((param, uploadPayload) -> request.addBodyPartPayloadInMultipartPayload(new FileByteArrayBodyPartPayload(uploadPayload.getBytes(), (String)param)));
        try {
            return this.handleResponse(request, service);
        }
        catch (IOException | InterruptedException | ReflectiveOperationException | ExecutionException | ParserConfigurationException | SAXException e) {
            throw new FlickrRuntimeException(e);
        }
    }

    private OAuth10aService createAndSignRequest(String apiKey, String sharedSecret, OAuthRequest request) {
        OAuth10aService service = OAuthUtilities.createOAuthService(apiKey, sharedSecret, this.connectTimeoutMs, this.readTimeoutMs);
        OAuthUtilities.signRequest(service, request, this.proxyAuth ? this.getProxyCredentials() : null);
        return service;
    }

    private String buildUrl(String path) {
        return String.format("%s://%s%s", this.getScheme(), this.getHost(), path);
    }

    private Response handleResponse(OAuthRequest request, OAuth10aService service) throws InterruptedException, ExecutionException, IOException, SAXException, ParserConfigurationException, FlickrException, ReflectiveOperationException {
        com.github.scribejava.core.model.Response scribeResponse = service.execute(request);
        if (!scribeResponse.isSuccessful()) {
            throw new FlickrException(FLICKR_SERVICE_UNAVAILABLE, String.format("Received '%s' error from Flickr with status %d", scribeResponse.getMessage(), scribeResponse.getCode()));
        }
        String strXml = scribeResponse.getBody().trim();
        if (Flickr.debugStream) {
            logger.debug(strXml);
        }
        if (strXml.startsWith("oauth_problem=")) {
            throw new FlickrRuntimeException(strXml);
        }
        DocumentBuilder builder = this.getDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(strXml)));
        Response f4jResponse = (Response)this.responseClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        f4jResponse.parse(document);
        return f4jResponse;
    }

    @Override
    public Response getNonOAuth(String path, Map<String, String> parameters) {
        Response response;
        InputStream in = null;
        try {
            URL url = UrlUtilities.buildUrl(this.getScheme(), this.getHost(), this.getPort(), path, parameters);
            if (Flickr.debugRequest) {
                logger.debug("GET: " + url);
            }
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            if (this.proxyAuth) {
                conn.setRequestProperty("Proxy-Authorization", "Basic " + this.getProxyCredentials());
            }
            conn.setRequestProperty("User-Agent", this.userAgent);
            this.setTimeouts(conn);
            conn.connect();
            in = Flickr.debugStream ? new DebugInputStream(conn.getInputStream(), System.out) : conn.getInputStream();
            DocumentBuilder builder = this.getDocumentBuilder();
            Document document = builder.parse(in);
            Response response2 = (Response)this.responseClass.newInstance();
            response2.parse(document);
            response = response2;
        }
        catch (IOException | IllegalAccessException | InstantiationException | ParserConfigurationException | SAXException e) {
            try {
                throw new FlickrRuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtilities.close(in);
                throw throwable;
            }
        }
        IOUtilities.close(in);
        return response;
    }

    public boolean isProxyAuth() {
        return this.proxyAuth;
    }

    public String getProxyCredentials() {
        return new String(Base64.getEncoder().encode((this.proxyUser + ":" + this.proxyPassword).getBytes()));
    }

    private void setTimeouts(HttpURLConnection conn) {
        if (this.connectTimeoutMs != null) {
            conn.setConnectTimeout(this.connectTimeoutMs);
        }
        if (this.readTimeoutMs != null) {
            conn.setReadTimeout(this.readTimeoutMs);
        }
    }

    public void setConnectTimeoutMs(Integer connectTimeoutMs) {
        this.connectTimeoutMs = connectTimeoutMs;
    }

    public void setReadTimeoutMs(Integer readTimeoutMs) {
        this.readTimeoutMs = readTimeoutMs;
    }

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        return builderFactory.newDocumentBuilder();
    }

    private void dumpResponseToFile(OAuthRequest request, String strXml) throws IOException {
        Verb verb = request.getVerb();
        Optional<Object> flickrMethod = Optional.empty();
        switch (verb) {
            case GET: {
                flickrMethod = request.getQueryStringParams().getParams().stream().filter(param -> param.getKey().equals("method")).findFirst().map(Parameter::getValue);
                break;
            }
            case POST: {
                flickrMethod = request.getBodyParams().getParams().stream().filter(param -> param.getKey().equals("method")).findFirst().map(Parameter::getValue);
            }
        }
        if (flickrMethod.isPresent()) {
            String filename = String.format("%s.xml", flickrMethod.get());
            Path filePath = Paths.get("src/test/resources/payloads/" + (Object)((Object)verb), filename);
            Files.write(filePath, strXml.getBytes(), new OpenOption[0]);
            logger.info(String.format("Writing payload to file '%s'", filePath));
        } else {
            logger.warn("Not dumping response to file as method not found in request for URL {}", (Object)request.getUrl());
        }
    }
}

