/*
 * Decompiled with CFR 0.152.
 */
package com.flickr4java.flickr.collections;

import com.flickr4java.flickr.FlickrException;
import com.flickr4java.flickr.Response;
import com.flickr4java.flickr.Transport;
import com.flickr4java.flickr.collections.Collection;
import com.flickr4java.flickr.photos.PhotoUtils;
import com.flickr4java.flickr.photosets.Photoset;
import com.flickr4java.flickr.util.XMLUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CollectionsInterface {
    private static final String METHOD_GET_INFO = "flickr.collections.getInfo";
    private static final String METHOD_GET_TREE = "flickr.collections.getTree";
    private static Logger _log = LoggerFactory.getLogger(CollectionsInterface.class);
    private final String apiKey;
    private final String sharedSecret;
    private final Transport transportAPI;

    public CollectionsInterface(String apiKey, String sharedSecret, Transport transportAPI) {
        this.apiKey = apiKey;
        this.sharedSecret = sharedSecret;
        this.transportAPI = transportAPI;
    }

    public Collection getInfo(String collectionId) throws FlickrException {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_INFO);
        parameters.put("collection_id", collectionId);
        Response response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Collection collection = this.parseCollection(response.getPayload());
        return collection;
    }

    public List<Collection> getTree(String collectionId, String userId) throws FlickrException {
        Response response;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_TREE);
        if (collectionId != null) {
            parameters.put("collection_id", collectionId);
        }
        if (userId != null) {
            parameters.put("user_id", userId);
        }
        if ((response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret)).isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        ArrayList<Collection> collections = new ArrayList<Collection>();
        Element mElement = response.getPayload();
        NodeList collectionElements = mElement.getElementsByTagName("collection");
        for (int i = 0; i < collectionElements.getLength(); ++i) {
            Element element = (Element)collectionElements.item(i);
            collections.add(this.parseTreeCollection(element));
        }
        return collections;
    }

    private Collection parseCollection(Element collectionElement) {
        Collection collection = new Collection();
        collection.setId(collectionElement.getAttribute("id"));
        collection.setServer(collectionElement.getAttribute("server"));
        collection.setSecret(collectionElement.getAttribute("secret"));
        collection.setChildCount(collectionElement.getAttribute("child_count"));
        collection.setIconLarge(collectionElement.getAttribute("iconlarge"));
        collection.setIconSmall(collectionElement.getAttribute("iconsmall"));
        collection.setDateCreated(collectionElement.getAttribute("datecreate"));
        collection.setTitle(XMLUtilities.getChildValue(collectionElement, "title"));
        collection.setDescription(XMLUtilities.getChildValue(collectionElement, "description"));
        Element iconPhotos = XMLUtilities.getChild(collectionElement, "iconphotos");
        if (iconPhotos != null) {
            NodeList photoElements = iconPhotos.getElementsByTagName("photo");
            for (int i = 0; i < photoElements.getLength(); ++i) {
                Element photoElement = (Element)photoElements.item(i);
                collection.addPhoto(PhotoUtils.createPhoto(photoElement));
            }
        }
        return collection;
    }

    private Collection parseTreeCollection(Element collectionElement) {
        Collection collection = new Collection();
        this.parseCommonFields(collectionElement, collection);
        collection.setTitle(collectionElement.getAttribute("title"));
        collection.setDescription(collectionElement.getAttribute("description"));
        NodeList childCollectionElements = collectionElement.getElementsByTagName("collection");
        for (int i = 0; i < childCollectionElements.getLength(); ++i) {
            Element childCollectionElement = (Element)childCollectionElements.item(i);
            collection.addCollection(this.parseTreeCollection(childCollectionElement));
        }
        NodeList childPhotosetElements = collectionElement.getElementsByTagName("set");
        for (int i = 0; i < childPhotosetElements.getLength(); ++i) {
            Element childPhotosetElement = (Element)childPhotosetElements.item(i);
            collection.addPhotoset(this.createPhotoset(childPhotosetElement));
        }
        return collection;
    }

    private Photoset createPhotoset(Element childPhotosetElement) {
        Photoset photoset = new Photoset();
        photoset.setId(childPhotosetElement.getAttribute("id"));
        photoset.setTitle(childPhotosetElement.getAttribute("title"));
        photoset.setDescription(childPhotosetElement.getAttribute("description"));
        return photoset;
    }

    private void parseCommonFields(Element collectionElement, Collection collection) {
        collection.setId(collectionElement.getAttribute("id"));
        collection.setIconLarge(collectionElement.getAttribute("iconlarge"));
        collection.setIconSmall(collectionElement.getAttribute("iconsmall"));
    }
}

